/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GenProviderKind implements Enumerator
{
    SINGLETON_LITERAL(0, "Singleton", "Singleton"),
    STATEFUL_LITERAL(1, "Stateful", "Stateful"),
    NONE_LITERAL(2, "None", "None");

    public static final int SINGLETON = 0;
    public static final int STATEFUL = 1;
    public static final int NONE = 2;
    private static final GenProviderKind[] VALUES_ARRAY;
    public static final List<GenProviderKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GenProviderKind[]{SINGLETON_LITERAL, STATEFUL_LITERAL, NONE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GenProviderKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GenProviderKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GenProviderKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GenProviderKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GenProviderKind get(int value) {
        switch (value) {
            case 0: {
                return SINGLETON_LITERAL;
            }
            case 1: {
                return STATEFUL_LITERAL;
            }
            case 2: {
                return NONE_LITERAL;
            }
        }
        return null;
    }

    private GenProviderKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

