/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.examples.jet.article2.model;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.examples.jet.article2.model.Attribute;
import org.eclipse.emf.examples.jet.article2.model.Instance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypesafeEnum {
    private String mPackageName = "";
    private String mClassName = "";
    private String mAuthor = "";
    private String mVersion = "";
    private ArrayList<Instance> mInstances = new ArrayList();
    private ArrayList<Attribute> mAttributes = new ArrayList();
    private Instance mDefaultInstance = null;

    public String constructorParameterDescription() {
        return this.parameterDescription(this.attributes());
    }

    public String keyParameterDescription() {
        return this.parameterDescription(this.keyAttributes());
    }

    private String parameterDescription(Iterator<Attribute> attributes) {
        StringBuffer result = new StringBuffer();
        Iterator<Attribute> i = attributes;
        while (i.hasNext()) {
            Attribute attrib = i.next();
            result.append(attrib.getType()).append(' ');
            result.append(attrib.getUncappedName());
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public boolean hasDefaultInstance() {
        return this.getDefaultInstance() != null;
    }

    public Instance getDefaultInstance() {
        return this.mDefaultInstance;
    }

    public void setDefaultInstance(Instance newDefault) {
        this.mDefaultInstance = newDefault;
    }

    public String getAuthor() {
        return this.mAuthor;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setAuthor(String author) {
        this.mAuthor = author;
    }

    public void setClassName(String className) {
        this.mClassName = className;
    }

    public void setPackageName(String packageName) {
        this.mPackageName = packageName;
    }

    public void setVersion(String version) {
        this.mVersion = version;
    }

    public Iterator<Instance> instances() {
        return this.mInstances.iterator();
    }

    public Iterator<Attribute> attributes() {
        return this.mAttributes.iterator();
    }

    public Iterator<Attribute> keyAttributes() {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        Iterator<Attribute> i = this.attributes();
        while (i.hasNext()) {
            Attribute attrib = i.next();
            if (!attrib.isKey()) continue;
            result.add(attrib);
        }
        return result.iterator();
    }

    public void addInstance(Instance instance) {
        this.mInstances.add(instance);
        instance.setType(this);
    }

    public boolean removeInstance(Instance instance) {
        boolean result = this.mInstances.remove(instance);
        if (result) {
            instance.setType(null);
        }
        return result;
    }

    public int instanceCount() {
        return this.mInstances.size();
    }

    public void addAttribute(Attribute attribute) {
        this.mAttributes.add(attribute);
    }

    public boolean removeAttribute(Attribute attribute) {
        return this.mAttributes.remove(attribute);
    }

    public int attributeCount() {
        return this.mAttributes.size();
    }

    public boolean isLast(Attribute attribute) {
        return this.mAttributes.indexOf(attribute) == this.attributeCount() - 1;
    }

    public boolean isFirst(Attribute attribute) {
        return this.mAttributes.indexOf(attribute) == 0;
    }

    public boolean isLast(Instance instance) {
        return this.mInstances.indexOf(instance) == this.instanceCount() - 1;
    }

    public boolean isFirst(Instance instance) {
        return this.mInstances.indexOf(instance) == 0;
    }

    public boolean hasAttribute(String attributeName) {
        Iterator<Attribute> i = this.attributes();
        while (i.hasNext()) {
            if (!i.next().getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    public Attribute[] attributeArray() {
        return this.mAttributes.toArray(new Attribute[this.mAttributes.size()]);
    }
}

