/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.part;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.diagram.sequence.edit.parts.BehaviorExecutionSpecificationEditPart;
import org.eclipse.uml2.diagram.sequence.edit.parts.InteractionEditPart;
import org.eclipse.uml2.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.uml2.diagram.sequence.edit.parts.MessageEditPart;
import org.eclipse.uml2.diagram.sequence.edit.policies.InteractionNestedLayoutRequest;
import org.eclipse.uml2.diagram.sequence.model.SDModelAccess;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDBehaviorSpec;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDExecution;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDLifeLine;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDMessage;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDModel;
import org.eclipse.uml2.diagram.sequence.model.sequenced.SDTrace;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.UMLPackage;

public class MessageCreationAction
implements IObjectActionDelegate {
    private Context myContext;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        action.setText("Creation");
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.myContext = null;
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return;
        }
        MessageEditPart messageEP = (MessageEditPart)((Object)((IStructuredSelection)selection).getFirstElement());
        this.myContext = this.createCreationContext(messageEP);
        action.setEnabled(this.myContext != null && (this.myContext.isCreation() || this.myContext.canBeCreation()));
        action.setChecked(this.myContext != null && this.myContext.isCreation());
    }

    public void run(IAction action) {
        if (this.myContext == null) {
            return;
        }
        TransactionalEditingDomain domain = this.myContext.getMessageEP().getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(domain, "Toggle Destruction");
        SetRequest request = new SetRequest((EObject)this.myContext.getSdMessage().getUmlMessage(), (EStructuralFeature)UMLPackage.eINSTANCE.getMessage_MessageSort(), (Object)(this.myContext.isCreation() ? MessageSort.SYNCH_CALL_LITERAL : MessageSort.CREATE_MESSAGE_LITERAL));
        cc.compose((IUndoableOperation)new SetValueCommand(request));
        InteractionNestedLayoutRequest layoutRequest = new InteractionNestedLayoutRequest();
        layoutRequest.requestTotalLayout();
        Command geflayout = this.myContext.findInteractionEditPart().getCommand(layoutRequest);
        if (geflayout != null) {
            cc.compose((IUndoableOperation)new CommandProxy(geflayout));
        }
        if (cc.canExecute()) {
            this.myContext.getMessageEP().getDiagramEditDomain().getDiagramCommandStack().execute((Command)new ICommandProxy(cc.reduce()));
        }
    }

    private Context createCreationContext(MessageEditPart messageEP) {
        if (!(messageEP.getTarget() instanceof BehaviorExecutionSpecificationEditPart)) {
            return null;
        }
        BehaviorExecutionSpecificationEditPart targetEP = (BehaviorExecutionSpecificationEditPart)messageEP.getTarget();
        View specView = targetEP.getNotationView();
        EObject entity = specView.getElement();
        if (!(entity instanceof ExecutionSpecification)) {
            return null;
        }
        SDModel sdModel = SDModelAccess.findSDModel(specView);
        if (sdModel == null) {
            return null;
        }
        SDTrace tracing = sdModel.getUMLTracing();
        SDBehaviorSpec sdSpec = tracing.findBehaviorSpec((ExecutionSpecification)entity);
        if (!(sdSpec instanceof SDExecution)) {
            return null;
        }
        SDExecution sdExecution = (SDExecution)sdSpec;
        if (!(sdExecution.getBracketContainer() instanceof SDLifeLine)) {
            return null;
        }
        SDMessage incomingMessage = sdExecution.getIncomingMessage();
        if (incomingMessage == null) {
            return null;
        }
        return new Context(messageEP, incomingMessage, sdExecution);
    }

    private static class Context {
        private final SDExecution mySdExecution;
        private final MessageEditPart myMessageEP;
        private final SDMessage mySdMessage;

        public Context(MessageEditPart messageEP, SDMessage sdMessage, SDExecution sdExecution) {
            this.myMessageEP = messageEP;
            this.mySdMessage = sdMessage;
            this.mySdExecution = sdExecution;
        }

        public MessageEditPart getMessageEP() {
            return this.myMessageEP;
        }

        public SDExecution getSdExecution() {
            return this.mySdExecution;
        }

        public SDMessage getSdMessage() {
            return this.mySdMessage;
        }

        public boolean canBeCreation() {
            EList brackets = this.mySdExecution.getBracketContainer().getBrackets();
            return brackets.indexOf(this.mySdExecution) == 0;
        }

        public boolean isCreation() {
            return this.mySdMessage.getUmlMessage().getMessageSort() == MessageSort.CREATE_MESSAGE_LITERAL;
        }

        public InteractionEditPart findInteractionEditPart() {
            EditPart ep = this.myMessageEP.getTarget();
            RootEditPart root = ep.getRoot();
            while (ep != root && ep != null) {
                if (ep instanceof InteractionEditPart) {
                    return (InteractionEditPart)ep;
                }
                ep = ep.getParent();
            }
            return null;
        }

        public LifelineEditPart findLifeLineEditpart() {
            EditPart ep = this.myMessageEP.getTarget();
            RootEditPart root = ep.getRoot();
            while (ep != root && ep != null) {
                if (ep instanceof LifelineEditPart) {
                    return (LifelineEditPart)ep;
                }
                ep = ep.getParent();
            }
            return null;
        }
    }
}

