/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.profile.action;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.AbstractEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.uml2.diagram.common.stereo.ProfileRegistry;
import org.eclipse.uml2.diagram.profile.edit.parts.ProfileEditPart;
import org.eclipse.uml2.diagram.profile.part.CustomMessages;
import org.eclipse.uml2.uml.Profile;

public class DefineProfileAction
extends DiagramAction {
    private static final String UNDEFINED_LABEL = CustomMessages.DefineProfileAction_indefined;

    public DefineProfileAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
        this.setText(this.calculateText());
    }

    protected Command getCommand() {
        ProfileEditPart profileEditPart = this.getProfileEditPart();
        TransactionalEditingDomain editingDomain = profileEditPart.getEditingDomain();
        Profile profile = (Profile)profileEditPart.getNotationView().getElement();
        AbstractEditCommandRequest request = new AbstractEditCommandRequest(editingDomain){

            public Object getEditHelperContext() {
                return null;
            }
        };
        ICommandProxy command = new ICommandProxy((ICommand)new DefineProfileCommand(CustomMessages.DefineProfileAction_define_profile_command, profile, (IEditCommandRequest)request));
        return command;
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    public boolean isEnabled() {
        return this.getProfileEditPart() != null;
    }

    public void refresh() {
        super.refresh();
        this.setText(this.calculateText());
    }

    private String calculateText() {
        ProfileEditPart profileEditPart = this.getProfileEditPart();
        if (profileEditPart == null) {
            return UNDEFINED_LABEL;
        }
        Profile profile = (Profile)profileEditPart.getNotationView().getElement();
        return profile.isDefined() ? CustomMessages.DefineProfileAction_redefine_action : CustomMessages.DefineProfileAction_define_action;
    }

    private ProfileEditPart getProfileEditPart() {
        for (Object next : this.getSelectedObjects()) {
            if (!(next instanceof ProfileEditPart)) continue;
            ProfileEditPart profileEditPart = (ProfileEditPart)((Object)next);
            return profileEditPart;
        }
        return null;
    }

    private class DefineProfileCommand
    extends EditElementCommand {
        Profile myProfile;

        protected DefineProfileCommand(String label, Profile elementToEdit, IEditCommandRequest request) {
            super(label, (EObject)elementToEdit, request);
            this.myProfile = elementToEdit;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.myProfile.define();
            ProfileRegistry.getInstance().addProfile(this.myProfile);
            return CommandResult.newOKCommandResult((Object)this.myProfile);
        }
    }
}

