/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.activity.edit.parts;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.diagram.activity.edit.policies.MergeNode2CanonicalEditPolicy;
import org.eclipse.uml2.diagram.activity.edit.policies.MergeNode2ItemSemanticEditPolicy;
import org.eclipse.uml2.diagram.common.editparts.PrimaryShapeEditPart;

public class MergeNode2EditPart
extends ShapeNodeEditPart
implements PrimaryShapeEditPart {
    public static final int VISUAL_ID = 3063;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public MergeNode2EditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new MergeNode2ItemSemanticEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new MergeNode2CanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        ScalableRhombFigure figure = new ScalableRhombFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public ScalableRhombFigure getPrimaryShape() {
        return (ScalableRhombFigure)this.primaryShape;
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(this.getMapMode().DPtoLP(40), this.getMapMode().DPtoLP(40));
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public class ScalableRhombFigure
    extends Shape {
        private final PointList myTemplate = new PointList();
        private Rectangle myTemplateBounds;

        public ScalableRhombFigure() {
            this.addPoint(new Point(MergeNode2EditPart.this.getMapMode().DPtoLP(20), MergeNode2EditPart.this.getMapMode().DPtoLP(0)));
            this.addPoint(new Point(MergeNode2EditPart.this.getMapMode().DPtoLP(40), MergeNode2EditPart.this.getMapMode().DPtoLP(20)));
            this.addPoint(new Point(MergeNode2EditPart.this.getMapMode().DPtoLP(20), MergeNode2EditPart.this.getMapMode().DPtoLP(40)));
            this.addPoint(new Point(MergeNode2EditPart.this.getMapMode().DPtoLP(0), MergeNode2EditPart.this.getMapMode().DPtoLP(20)));
        }

        public void addPoint(Point point) {
            this.myTemplate.addPoint(point);
            this.myTemplateBounds = null;
        }

        protected void fillShape(Graphics graphics) {
            Rectangle bounds = this.getBounds();
            graphics.pushState();
            graphics.translate(bounds.x, bounds.y);
            graphics.fillPolygon(this.scalePointList());
            graphics.popState();
        }

        protected void outlineShape(Graphics graphics) {
            Rectangle bounds = this.getBounds();
            graphics.pushState();
            graphics.translate(bounds.x, bounds.y);
            graphics.drawPolygon(this.scalePointList());
            graphics.popState();
        }

        private Rectangle getTemplateBounds() {
            if (this.myTemplateBounds == null) {
                this.myTemplateBounds = this.myTemplate.getBounds().getCopy().union(0, 0);
                if (this.myTemplateBounds.width < 1) {
                    this.myTemplateBounds.width = 1;
                }
                if (this.myTemplateBounds.height < 1) {
                    this.myTemplateBounds.height = 1;
                }
            }
            return this.myTemplateBounds;
        }

        private int[] scalePointList() {
            Rectangle pointsBounds = this.getTemplateBounds();
            Rectangle actualBounds = this.getBounds();
            float xScale = (float)actualBounds.width / (float)pointsBounds.width;
            float yScale = (float)actualBounds.height / (float)pointsBounds.height;
            if (xScale == 1.0f && yScale == 1.0f) {
                return this.myTemplate.toIntArray();
            }
            int[] scaled = (int[])this.myTemplate.toIntArray().clone();
            int i = 0;
            while (i < scaled.length) {
                scaled[i] = (int)Math.floor((float)scaled[i] * xScale);
                scaled[i + 1] = (int)Math.floor((float)scaled[i + 1] * yScale);
                i += 2;
            }
            return scaled;
        }
    }
}

