/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AttributeOwner;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.OperationOwner;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ProfileUtil
extends UMLUtil {
    private static EPackage umlMetamodel = UMLPackage.eINSTANCE;

    public static boolean isDirty(Package _package, Profile _profile) {
        URI prof_URI;
        Resource modelResource;
        boolean isDirty = false;
        if (_profile == null || _profile.eResource() == null || _package == null || _package.eResource() == null) {
            return false;
        }
        ResourceSet pkge_resourceSet = _package.eResource().getResourceSet();
        if (pkge_resourceSet != null && (modelResource = pkge_resourceSet.getResource(prof_URI = _profile.eResource().getURI(), true)) != null && modelResource.getContents().get(0) instanceof Profile) {
            Profile profileInFile = (Profile)modelResource.getContents().get(0);
            ProfileApplication profileApplication = _package.getProfileApplication(_profile, true);
            if (profileApplication != null) {
                String fileProfileName;
                EPackage appliedProfileDefinition = profileApplication.getAppliedDefinition();
                EPackage fileProfileDefinition = null;
                String appliedProfileName = _profile.getQualifiedName();
                if (!appliedProfileName.equals(fileProfileName = profileInFile.getQualifiedName())) {
                    for (Profile current : PackageUtil.getSubProfiles((Package)profileInFile)) {
                        fileProfileName = current.getQualifiedName();
                        if (!fileProfileName.equals(appliedProfileName)) continue;
                        profileInFile = current;
                    }
                }
                fileProfileDefinition = profileInFile.getDefinition();
                URIConverter converter = pkge_resourceSet.getURIConverter();
                if (appliedProfileDefinition == null || fileProfileDefinition == null || !UML2Util.safeEquals((Object)converter.normalize(EcoreUtil.getURI((EObject)appliedProfileDefinition)), (Object)converter.normalize(EcoreUtil.getURI((EObject)fileProfileDefinition)))) {
                    isDirty = true;
                }
            }
        }
        return isDirty;
    }

    public static List<Stereotype> findAllSubStereotypes(Stereotype parentStereotype, Package umlPackage, boolean concreteOnly) {
        LinkedHashSet<Stereotype> result = new LinkedHashSet<Stereotype>();
        for (Profile profile : umlPackage.getAllAppliedProfiles()) {
            LinkedList<Stereotype> allStereotypes = new LinkedList<Stereotype>();
            ProfileUtil.findAllStereotypes(profile, allStereotypes);
            for (Stereotype stereotype : allStereotypes) {
                if (concreteOnly && stereotype.isAbstract() || !ProfileUtil.isSubStereotype(parentStereotype, stereotype)) continue;
                result.add(stereotype);
            }
        }
        return new LinkedList<Stereotype>(result);
    }

    public static boolean isSubStereotype(Stereotype parentStereotype, Stereotype childStereotype) {
        if (parentStereotype == childStereotype) {
            return true;
        }
        return childStereotype.getGenerals().contains((Object)parentStereotype);
    }

    public static void findAllStereotypes(Profile profile, List<Stereotype> result) {
        for (Stereotype stereotype : profile.getOwnedStereotypes()) {
            result.add(stereotype);
        }
        for (Package subPackage : profile.getNestedPackages()) {
            if (!(subPackage instanceof Profile)) continue;
            Profile subProfile = (Profile)subPackage;
            ProfileUtil.findAllStereotypes(subProfile, result);
        }
    }

    public static List<EClass> getAllExtendedMetaclasses(Stereotype stereotype, boolean concreteClassesOnly) {
        EList extendedMetaclasses = stereotype.getAllExtendedMetaclasses();
        LinkedHashSet allMetaclasses = new LinkedHashSet();
        for (Class extendedMetaclass : extendedMetaclasses) {
            EClass UMLEClass = ProfileUtil.findEClass(extendedMetaclass);
            allMetaclasses.addAll(EMFHelper.getSubclassesOf((EClass)UMLEClass, (boolean)concreteClassesOnly));
        }
        return new LinkedList<EClass>(allMetaclasses);
    }

    private static EClass findEClass(Class metaclass) {
        for (EClassifier classifier : umlMetamodel.getEClassifiers()) {
            if (!(classifier instanceof EClass) || !classifier.getName().equals(metaclass.getName())) continue;
            return (EClass)classifier;
        }
        return null;
    }

    public static Property findStereotypedProperty(Stereotype stereotype, String associationName) {
        block0: for (Association association : stereotype.getAssociations()) {
            for (Property memberEnd : association.getMemberEnds()) {
                if (memberEnd.getType() != stereotype) continue;
                for (Property oppositeEnd : association.getMemberEnds()) {
                    if (oppositeEnd == memberEnd || !oppositeEnd.getName().equals(associationName) || association.getOwnedEnds().contains((Object)oppositeEnd)) continue;
                    if (!(oppositeEnd.getType() instanceof Stereotype)) break block0;
                    return oppositeEnd;
                }
            }
        }
        for (Property property : stereotype.getAllAttributes()) {
            if (!property.getName().equals(associationName) || !(property.getType() instanceof Stereotype)) continue;
            return property;
        }
        return null;
    }

    public static ProfileApplication getProfileApplication(Element element, EClass stereotypeDefinition, Stereotype stereotype) {
        if (stereotype == null) {
            NamedElement umlDefinition = ProfileUtil.getNamedElement((ENamedElement)stereotypeDefinition, (EObject)element);
            if (umlDefinition instanceof Stereotype) {
                stereotype = (Stereotype)umlDefinition;
            } else {
                return null;
            }
        }
        ProfileApplication result = null;
        Profile profile = ProfileUtil.getContainingProfile((NamedElement)stereotype);
        if (profile != null) {
            result = ProfileUtil.getApplicationOf(profile, element);
        }
        return result;
    }

    @Deprecated
    public static ProfileApplication getProfileApplication(Element element, EClass stereotypeDefinition) {
        return ProfileUtil.getProfileApplication(element, stereotypeDefinition, null);
    }

    static Profile getContainingProfile(NamedElement umlDefinition) {
        Profile result = null;
        Package package_ = umlDefinition.getNearestPackage();
        while (package_ != null) {
            if (package_ instanceof Profile) {
                result = (Profile)package_;
                break;
            }
            package_ = package_.getNestingPackage();
        }
        return result;
    }

    static ProfileApplication getApplicationOf(Profile profile, Element context) {
        ProfileApplication result = null;
        Package package_ = context.getNearestPackage();
        if (package_ != null) {
            result = package_.getProfileApplication(profile, true);
        }
        return result;
    }

    public static void sortProfiles(List<Profile> profiles) {
        final SetMultimap<Profile, Profile> dependencies = ProfileUtil.computeProfileDependencies(profiles);
        ProfileUtil.expand(dependencies);
        Collections.sort(profiles, new Comparator<Profile>(){

            @Override
            public int compare(Profile o1, Profile o2) {
                return dependencies.get((Object)o1).contains(o2) ? 1 : (dependencies.get((Object)o2).contains(o1) ? -1 : 0);
            }
        });
    }

    private static SetMultimap<Profile, Profile> computeProfileDependencies(Collection<? extends Profile> profiles) {
        HashMultimap result = HashMultimap.create();
        for (Profile profile : profiles) {
            for (PackageableElement member : profile.getPackagedElements()) {
                if (member instanceof Classifier) {
                    for (Classifier general : ((Classifier)member).allParents()) {
                        ProfileUtil.addProfileContaining((PackageableElement)general, profile, (SetMultimap<Profile, Profile>)result);
                    }
                }
                if (member instanceof AttributeOwner) {
                    for (Property property : ((AttributeOwner)member).getOwnedAttributes()) {
                        ProfileUtil.addProfileContaining((PackageableElement)property.getType(), profile, (SetMultimap<Profile, Profile>)result);
                    }
                }
                if (!(member instanceof OperationOwner)) continue;
                for (Operation operation : ((OperationOwner)member).getOwnedOperations()) {
                    for (Parameter parameter : operation.getOwnedParameters()) {
                        ProfileUtil.addProfileContaining((PackageableElement)parameter.getType(), profile, (SetMultimap<Profile, Profile>)result);
                    }
                }
            }
            result.remove((Object)profile, (Object)profile);
        }
        return result;
    }

    private static void addProfileContaining(PackageableElement element, Profile dependent, SetMultimap<Profile, Profile> dependencies) {
        if (element != null) {
            Package containingPackage = element.getNearestPackage();
            while (containingPackage != null && !(containingPackage instanceof Profile) && containingPackage.getOwner() != null) {
                containingPackage = containingPackage.getOwner().getNearestPackage();
            }
            if (containingPackage instanceof Profile) {
                dependencies.put((Object)dependent, (Object)((Profile)containingPackage));
            }
        }
    }

    private static void expand(SetMultimap<Profile, Profile> dependencies) {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Profile next : new ArrayList(dependencies.keySet())) {
                for (Profile dep : new ArrayList(dependencies.get((Object)next))) {
                    Set transitive = dependencies.get((Object)dep);
                    if (transitive == null || !dependencies.putAll((Object)next, (Iterable)transitive)) continue;
                    changed = true;
                }
            }
        }
    }
}

