/*****************************************************************************
 * Copyright (c) 2011 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Camille Letavernier (CEA LIST) camille.letavernier@cea.fr - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.views.properties.toolsmiths.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.views.properties.toolsmiths.preferences.CustomizationPreferencePage;
import org.eclipse.papyrus.views.properties.toolsmiths.Activator;

/**
 * The initializer for @see {@link CustomizationPreferencePage}
 *
 * @author Camille Letavernier
 */
public class CustomizationPreferencesInitializer extends AbstractPreferenceInitializer {

	@Override
	public void initializeDefaultPreferences() {
		IPreferenceStore store = Activator.getDefault().getPreferenceStore();
		store.setDefault(CustomizationPreferencePage.OPEN_CUSTOMIZATION_PERSPECTIVE, true);
		store.setDefault(CustomizationPreferencePage.ASK_FOR_CONFIRMATION, true);
	}

}
