/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.AutomaticNotationEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.IdentityAnchorHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.BoundForEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.ConnectToGridEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.GridManagementEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.GrillingEditpart;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.IGrillingEditpolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.NoGrillElementFound;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;

public class ConnectRectangleToGridEditPolicy
extends ConnectToGridEditPolicy
implements AutomaticNotationEditPolicy,
NotificationListener,
IGrillingEditpolicy {
    protected GrillingEditpart grillingCompartment = null;
    public static String CONNECT_TO_GRILLING_MANAGEMENT = "CONNECT_TO_GRILLING_MANAGEMENT";
    protected DecorationNode rowStart = null;
    protected DecorationNode rowFinish = null;
    protected DecorationNode columnStart = null;
    protected DecorationNode columnFinish = null;
    protected int margin = 0;

    public void activate() {
        super.activate();
        this.getDiagramEventBroker().addNotificationListener((EObject)this.getHost().getModel(), (NotificationListener)this);
        DiagramEditPart diagramEditPart = this.getDiagramEditPart(this.getHost());
        Node node = (Node)((GraphicalEditPart)this.getHost()).getNotationView();
        try {
            GridManagementEditPolicy grilling = (GridManagementEditPolicy)diagramEditPart.getEditPolicy((Object)GridManagementEditPolicy.GRID_MANAGEMENT);
            Node nodeContainer = (Node)((GraphicalEditPart)this.getHost()).getNotationView().eContainer();
            Element element = (Element)((GraphicalEditPart)this.getHost()).resolveSemanticElement();
            if (grilling != null) {
                PrecisionRectangle p = NotationHelper.getAbsoluteBounds((Node)((Node)((GraphicalEditPart)this.getHost()).getNotationView()));
                this.initListeningRowStart(grilling, element, p);
                this.initListeningColumnStart(grilling, element, p);
                this.initListeningRowFinish(node, grilling, element, p);
                this.initListeningColumnFinish(node, grilling, element, p);
            }
        }
        catch (NoGrillElementFound e) {
            UMLDiagramEditorPlugin.log.error((Throwable)e);
        }
    }

    protected void initListeningColumnFinish(Node node, GridManagementEditPolicy grilling, Element element, PrecisionRectangle bounds) throws NoGrillElementFound {
        this.columnFinish = grilling.createColumnTolisten(bounds.x + BoundForEditPart.getWidthFromView(node), element);
        this.getDiagramEventBroker().addNotificationListener((EObject)this.columnFinish, (NotificationListener)this);
    }

    protected void initListeningRowFinish(Node node, GridManagementEditPolicy grilling, Element element, PrecisionRectangle bounds) throws NoGrillElementFound {
        this.rowFinish = grilling.createRowTolisten(bounds.y + BoundForEditPart.getHeightFromView(node) + this.margin, element);
        this.getDiagramEventBroker().addNotificationListener((EObject)this.rowFinish, (NotificationListener)this);
    }

    protected void initListeningColumnStart(GridManagementEditPolicy grilling, Element element, PrecisionRectangle bounds) throws NoGrillElementFound {
        this.columnStart = grilling.createColumnTolisten(bounds.x(), element);
        this.getDiagramEventBroker().addNotificationListener((EObject)this.columnStart, (NotificationListener)this);
    }

    protected void initListeningRowStart(GridManagementEditPolicy grid, Element element, PrecisionRectangle bounds) throws NoGrillElementFound {
        this.rowStart = grid.createRowTolisten(bounds.y + this.margin, element);
        this.getDiagramEventBroker().addNotificationListener((EObject)this.rowStart, (NotificationListener)this);
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public void deactivate() {
        this.getDiagramEventBroker().removeNotificationListener((EObject)this.getHost().getModel(), (NotificationListener)this);
        if (this.rowStart != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)this.rowStart, (NotificationListener)this);
        }
        if (this.columnStart != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)this.columnStart, (NotificationListener)this);
        }
        if (this.rowFinish != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)this.rowFinish, (NotificationListener)this);
        }
        if (this.columnFinish != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)this.columnFinish, (NotificationListener)this);
        }
        super.deactivate();
    }

    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == 4) {
            return;
        }
        Node nodeContainer = (Node)((GraphicalEditPart)this.getHost()).getNotationView().eContainer();
        if (nodeContainer != null) {
            PrecisionRectangle originPosition = NotationHelper.getAbsoluteBounds((Node)nodeContainer);
            Bounds currentBounds = (Bounds)((Node)((GraphicalEditPart)this.getHost()).getNotationView()).getLayoutConstraint();
            if (notification.getEventType() == 1 && notification.getNotifier() instanceof Location && ((EObject)notification.getNotifier()).eContainer().equals(this.rowStart)) {
                this.updateYFromAxisNotification(originPosition, currentBounds);
            }
            if (notification.getEventType() == 1 && notification.getNotifier() instanceof Location && ((EObject)notification.getNotifier()).eContainer().equals(this.columnStart)) {
                this.updateXFromAxisNotification(originPosition, currentBounds);
            }
            if (notification.getEventType() == 1 && notification.getNotifier() instanceof Location && ((EObject)notification.getNotifier()).eContainer().equals(this.rowFinish)) {
                this.updateHeightFromAxisNotification(originPosition, currentBounds);
            }
            if (notification.getEventType() == 1 && notification.getNotifier() instanceof Location && ((EObject)notification.getNotifier()).eContainer().equals(this.columnFinish)) {
                this.updateWidthFromAxisNotification(originPosition, currentBounds);
            }
            if (notification.getEventType() == 1 && notification.getNotifier() instanceof Bounds) {
                IdentityAnchor anchor;
                Edge edge;
                Object targetEdge;
                IdentityAnchor anchor2;
                EList sourceEdge;
                Node node;
                PrecisionRectangle bounds = NotationHelper.getAbsoluteBounds((Node)((Node)((GraphicalEditPart)this.getHost()).getNotationView()));
                UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+ EVENT: BOUNDS change " + notification.getNewValue());
                if (notification.getFeature().equals(NotationPackage.eINSTANCE.getSize_Height())) {
                    this.updateRowFinishFromHeightNotification(bounds);
                    if (((EObject)notification.getNotifier()).eContainer().equals((EObject)this.getHost().getModel())) {
                        node = (Node)this.getHost().getModel();
                        sourceEdge = node.getSourceEdges();
                        for (Edge edge2 : sourceEdge) {
                            anchor2 = (IdentityAnchor)edge2.getSourceAnchor();
                            if (!(anchor2 instanceof IdentityAnchor)) continue;
                            this.updateAnchorFromHeight(anchor2, (Node)this.getHost().getModel(), notification.getNewIntValue() - notification.getOldIntValue());
                        }
                        targetEdge = node.getTargetEdges();
                        anchor2 = targetEdge.iterator();
                        while (anchor2.hasNext()) {
                            edge = (Edge)anchor2.next();
                            anchor = (IdentityAnchor)edge.getTargetAnchor();
                            if (!(anchor instanceof IdentityAnchor)) continue;
                            this.updateAnchorFromHeight(anchor, (Node)this.getHost().getModel(), notification.getNewIntValue() - notification.getOldIntValue());
                        }
                    }
                }
                if (notification.getFeature().equals(NotationPackage.eINSTANCE.getSize_Width())) {
                    this.updateColumFinishFromWitdhNotification(bounds);
                }
                if (notification.getFeature().equals(NotationPackage.eINSTANCE.getLocation_Y())) {
                    this.updateRowStartFromYNotification(bounds);
                    if (((EObject)notification.getNotifier()).eContainer().equals((EObject)this.getHost().getModel())) {
                        node = (Node)this.getHost().getModel();
                        for (Object child : node.getChildren()) {
                            EObject element;
                            if (!(child instanceof Node) || !((element = ((Node)child).getElement()) instanceof ExecutionSpecification)) continue;
                            this.updateExecutionSpecificationFromY((Node)child, notification.getNewIntValue(), notification.getOldIntValue());
                        }
                        sourceEdge = node.getSourceEdges();
                        for (Edge edge2 : sourceEdge) {
                            anchor2 = (IdentityAnchor)edge2.getSourceAnchor();
                            if (!(anchor2 instanceof IdentityAnchor)) continue;
                            this.updateAnchorFromY(anchor2, (Node)this.getHost().getModel(), notification.getOldIntValue(), notification.getNewIntValue());
                        }
                        targetEdge = node.getTargetEdges();
                        Iterator iterator = targetEdge.iterator();
                        while (iterator.hasNext()) {
                            edge = (Edge)iterator.next();
                            anchor = (IdentityAnchor)edge.getTargetAnchor();
                            if (!(anchor instanceof IdentityAnchor)) continue;
                            this.updateAnchorFromY(anchor, (Node)this.getHost().getModel(), notification.getOldIntValue(), notification.getNewIntValue());
                        }
                    }
                }
                if (notification.getFeature().equals(NotationPackage.eINSTANCE.getLocation_X())) {
                    this.updateColumnStartFromXNotification(bounds);
                }
            }
        }
    }

    protected void updateExecutionSpecificationFromY(Node execSpecNode, int newYValue, int oldYValue) {
        LayoutConstraint layoutConstraint = execSpecNode.getLayoutConstraint();
        if (layoutConstraint instanceof Bounds) {
            int delta = newYValue - oldYValue;
            this.execute((ICommand)new SetBoundsCommand(this.getDiagramEditPart(this.getHost()).getEditingDomain(), "update ExecutionSpecification", (IAdaptable)new EObjectAdapter((EObject)execSpecNode), new Point(((Bounds)layoutConstraint).getX(), ((Bounds)layoutConstraint).getY() - delta)));
        }
    }

    protected void updateRowFinishFromHeightNotification(PrecisionRectangle p) {
        int newY = p.y + p.height + this.margin;
        this.updatePositionGridAxis(this.rowFinish, 0, newY);
    }

    protected void updateColumFinishFromWitdhNotification(PrecisionRectangle notationBound) {
        int newX = notationBound.x + notationBound.width;
        this.updatePositionGridAxis(this.columnFinish, newX, 0);
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+---->ACTION: modifiy AXIS to  x=" + newX);
    }

    protected void updateRowStartFromYNotification(PrecisionRectangle bounds) {
        int newY = bounds.y() + this.margin;
        this.updatePositionGridAxis(this.rowStart, 0, newY);
        if (this.rowFinish != null) {
            newY = bounds.y + bounds.height + this.margin;
            this.updatePositionGridAxis(this.rowFinish, 0, newY);
        }
    }

    protected void updateColumnStartFromXNotification(PrecisionRectangle bounds) {
        int newX = bounds.x();
        this.updatePositionGridAxis(this.columnStart, newX, 0);
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+---->ACTION: modifiy AXIS START to  x=" + newX);
    }

    protected void updateWidthFromAxisNotification(PrecisionRectangle originPosition, Bounds currentBounds) {
        Location boundsColumn = (Location)this.columnFinish.getLayoutConstraint();
        int newX = boundsColumn.getX() - originPosition.x() - currentBounds.getX();
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+ EVENT: AXIS ROW FINISH change " + newX);
        this.updateSizeOfControler(newX, currentBounds.getHeight());
    }

    protected void updateHeightFromAxisNotification(PrecisionRectangle originPosition, Bounds currentBounds) {
        Location boundsColumn = (Location)this.rowFinish.getLayoutConstraint();
        int newHeight = boundsColumn.getY() - originPosition.y() - currentBounds.getY() - this.margin;
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+ EVENT: AXIS ROW FINISH change " + newHeight);
        this.updateSizeOfControler(currentBounds.getWidth(), newHeight);
    }

    protected void updateXFromAxisNotification(PrecisionRectangle originPosition, Bounds currentBounds) {
        Location boundsColumn = (Location)this.columnStart.getLayoutConstraint();
        int newX = boundsColumn.getX() - originPosition.x();
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+ EVENT: AXIS COLUMN START change " + newX);
        this.updateNodePositionOfControler(newX, currentBounds.getY());
    }

    protected void updateYFromAxisNotification(PrecisionRectangle originPosition, Bounds currentBounds) {
        Location boundsRow = (Location)this.rowStart.getLayoutConstraint();
        int newY = boundsRow.getY() - originPosition.y() - this.margin;
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG_REFERENCEGRID, "+ EVENT: AXIS ROW START change " + newY);
        this.updateNodePositionOfControler(currentBounds.getX(), newY);
        if (this.rowFinish != null) {
            this.updatePositionGridAxis(this.rowFinish, 0, boundsRow.getY() + BoundForEditPart.getHeightFromView((Node)((GraphicalEditPart)this.getHost()).getNotationView()) - this.margin);
        }
    }

    protected void updateAnchorFromHeight(IdentityAnchor anchor, Node node, int deltaHeight) {
        if (anchor != null) {
            double yPercent = IdentityAnchorHelper.getYPercentage((IdentityAnchor)anchor);
            double xPercent = IdentityAnchorHelper.getXPercentage((IdentityAnchor)anchor);
            PrecisionRectangle bounds = NotationHelper.getAbsoluteBounds((Node)node);
            double oldHeight = BoundForEditPart.getHeightFromView(node) - deltaHeight;
            double newPercentY = yPercent * oldHeight / bounds.preciseHeight();
            if (newPercentY <= 1.0 && newPercentY >= 0.0 && newPercentY <= 1.0 && newPercentY >= 0.0) {
                String newIdValue = IdentityAnchorHelper.createNewAnchorIdValue((double)xPercent, (double)newPercentY);
                this.execute((Command)new SetCommand((EditingDomain)this.getDiagramEditPart(this.getHost()).getEditingDomain(), (EObject)anchor, (EStructuralFeature)NotationPackage.eINSTANCE.getIdentityAnchor_Id(), (Object)newIdValue));
            }
        }
    }

    protected void updateAnchorFromY(IdentityAnchor anchor, Node node, int oldY, int newY) {
        if (anchor != null && !anchor.getId().trim().equals("")) {
            double yPercent = IdentityAnchorHelper.getYPercentage((IdentityAnchor)anchor);
            double xPercent = IdentityAnchorHelper.getXPercentage((IdentityAnchor)anchor);
            double height = BoundForEditPart.getHeightFromView(node);
            double newPercentY = (double)(oldY - newY) / height + yPercent;
            if (newPercentY < 0.0) {
                newPercentY = 0.01;
            } else if (newPercentY > 1.0) {
                newPercentY = 0.99;
            }
            String newIdValue = IdentityAnchorHelper.createNewAnchorIdValue((double)xPercent, (double)newPercentY);
            this.execute((Command)new SetCommand((EditingDomain)this.getDiagramEditPart(this.getHost()).getEditingDomain(), (EObject)anchor, (EStructuralFeature)NotationPackage.eINSTANCE.getIdentityAnchor_Id(), (Object)newIdValue));
        }
    }
}

