/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeListener;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageCreateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageDeleteEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineEditPartUtil;

public class LifeLineRestorePositionEditPolicy
extends SemanticEditPolicy
implements NodeListener {
    public static final String KEY = "LIFELINE_RESTORE_POSITION_EDITPOLICY";

    public void activate() {
        EditPart host = this.getHost();
        if (host instanceof GraphicalEditPart) {
            ((GraphicalEditPart)host).addNodeListener((NodeListener)this);
        }
    }

    public void deactivate() {
        EditPart host = this.getHost();
        if (host instanceof ConnectionEditPart) {
            ((ConnectionEditPart)host).removeNodeListener((NodeListener)this);
        }
    }

    protected Command getSemanticCommand(IEditCommandRequest request) {
        return null;
    }

    public void removingTargetConnection(ConnectionEditPart connection, int index) {
        Command restoreLifelinePositionCommand;
        if (connection instanceof MessageCreateEditPart && (restoreLifelinePositionCommand = LifelineEditPartUtil.getRestoreLifelinePositionOnMessageCreateRemovedCommand(connection)) != null && restoreLifelinePositionCommand.canExecute()) {
            this.executeCommand(restoreLifelinePositionCommand);
        }
        if (connection instanceof MessageDeleteEditPart && (restoreLifelinePositionCommand = LifelineEditPartUtil.getRestoreLifelinePositionOnMessageDeleteRemovedCommand(connection)) != null && restoreLifelinePositionCommand.canExecute()) {
            this.executeCommand(restoreLifelinePositionCommand);
        }
    }

    protected void executeCommand(final Command cmd) {
        Map<String, Boolean> options = null;
        EditPart ep = this.getHost();
        boolean isActivating = true;
        EditPartViewer viewer = ep.getViewer();
        if (viewer instanceof DiagramGraphicalViewer) {
            isActivating = ((DiagramGraphicalViewer)viewer).isInitializing();
        }
        if (isActivating || !EditPartUtil.isWriteTransactionInProgress((IGraphicalEditPart)((IGraphicalEditPart)this.getHost()), (boolean)false, (boolean)false)) {
            options = Collections.singletonMap("unprotected", Boolean.TRUE);
        }
        AbstractEMFOperation operation = new AbstractEMFOperation(((IGraphicalEditPart)this.getHost()).getEditingDomain(), "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                cmd.execute();
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void removingSourceConnection(ConnectionEditPart connection, int index) {
    }

    public void sourceConnectionAdded(ConnectionEditPart connection, int index) {
    }

    public void targetConnectionAdded(ConnectionEditPart connection, int index) {
    }
}

