/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.advices;

import java.util.List;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.uml.diagram.activity.edit.commands.util.PinUpdateCommand;
import org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater.IPinUpdater;
import org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater.PinUpdaterFactory;
import org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater.preferences.AutomatedModelCompletionPreferencesInitializer;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.tools.utils.ElementUtil;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.StartObjectBehaviorAction;
import org.eclipse.uml2.uml.UMLPackage;

public class BehaviorEditHelperAdvice
extends AbstractEditHelperAdvice {
    public ICommand getAfterSetCommand(SetRequest request) {
        if (request.getFeature().equals(UMLPackage.eINSTANCE.getBehavior_OwnedParameter())) {
            IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
            boolean synchronizePin = false;
            CompositeCommand command = new CompositeCommand("Update pins on modification of a behavior");
            synchronizePin = prefStore.getString("org.eclipse.papyrus.uml.diagram.activity.preferences.startObjectBehaviorAction").equals(AutomatedModelCompletionPreferencesInitializer.PIN_SYNCHRONIZATION);
            if (synchronizePin) {
                Behavior behavior = (Behavior)request.getElementToEdit();
                Package root = PackageUtil.getRootPackage((Element)behavior);
                if (root != null) {
                    List allStartObjectBehaviorAction = ElementUtil.getInstancesFilteredByType((Package)root, StartObjectBehaviorAction.class, null);
                    for (StartObjectBehaviorAction startObjectBehaviorAction : allStartObjectBehaviorAction) {
                        if (startObjectBehaviorAction.behavior() != behavior) continue;
                        IPinUpdater updater = PinUpdaterFactory.getInstance().instantiate((ActivityNode)startObjectBehaviorAction);
                        command.add(new PinUpdateCommand<StartObjectBehaviorAction>("Update start object behavior action pins", updater, startObjectBehaviorAction));
                    }
                }
                if (!command.isEmpty()) {
                    return command;
                }
            }
        }
        return super.getAfterSetCommand(request);
    }
}

