/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.assistants.codegen.generator;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.dev.assistants.codegen.generator.ModelingAssistantProviderRule;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ElementType;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.papyrus.infra.filters.Filter;
import org.eclipse.papyrus.infra.gmfdiag.assistant.AssistantFactory;
import org.eclipse.papyrus.infra.gmfdiag.assistant.AssistedElementTypeFilter;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ConnectionAssistant;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ElementTypeFilter;
import org.eclipse.papyrus.infra.gmfdiag.assistant.PopupAssistant;
import org.eclipse.papyrus.uml.profile.assistants.generator.FiltersUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class GMFGenToAssistantRule {
    @Extension
    private static AssistantFactory assistantFactory = AssistantFactory.eINSTANCE;
    @Inject
    @Extension
    private FiltersUtil _filtersUtil;
    @Inject
    @Extension
    private ModelingAssistantProviderRule _modelingAssistantProviderRule;
    private final HashMap<ArrayList<?>, ElementTypeFilter> _createCache_toElementTypeFilter = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, ElementTypeFilter> _createCache_toElementTypeFilter_1 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, PopupAssistant> _createCache_toPopupAssistant = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, PopupAssistant> _createCache_toPopupAssistant_1 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, ConnectionAssistant> _createCache_toConnectionAssistant = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, AssistedElementTypeFilter> _createCache_assistedElementTypeFilter = CollectionLiterals.newHashMap();

    public String cleanedName(String name) {
        String _xblockexpression = null;
        int _lastIndexOf = name.lastIndexOf(".");
        int _plus = _lastIndexOf + 1;
        String result = name.substring(_plus);
        boolean _matches = result.matches("^.*_\\d+$");
        if (_matches) {
            result = result.substring(0, result.lastIndexOf("_"));
        }
        _xblockexpression = result = result.replaceAll("([a-z])([A-Z])", "$1 $2");
        return _xblockexpression;
    }

    protected GenEditorGenerator _rootEditor(EObject element) {
        EObject _eContainer = element.eContainer();
        GenEditorGenerator _rootEditor = null;
        if (_eContainer != null) {
            _rootEditor = this.rootEditor(_eContainer);
        }
        return _rootEditor;
    }

    protected GenEditorGenerator _rootEditor(GenDiagram diagram) {
        return diagram.getEditorGen();
    }

    public Iterable<GenNode> validNodes(GenDiagram diagram) {
        Functions.Function1 _function = it -> {
            TypeModelFacet _modelFacet = it.getModelFacet();
            return !Objects.equals(_modelFacet, null);
        };
        return IterableExtensions.filter((Iterable)diagram.getAllNodes(), (Functions.Function1)_function);
    }

    public Iterable<GenLink> validLinks(GenDiagram diagram) {
        Functions.Function1 _function = it -> {
            LinkModelFacet _modelFacet = it.getModelFacet();
            return !Objects.equals(_modelFacet, null);
        };
        return IterableExtensions.filter((Iterable)diagram.getLinks(), (Functions.Function1)_function);
    }

    protected ElementTypeFilter _toElementTypeFilter(EObject element) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ElementTypeFilter _toElementTypeFilter(GenDiagram diagram) {
        ElementTypeFilter _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new GenDiagram[]{diagram});
        HashMap<ArrayList<?>, ElementTypeFilter> hashMap = this._createCache_toElementTypeFilter;
        synchronized (hashMap) {
            ElementTypeFilter _createElementTypeFilter;
            if (this._createCache_toElementTypeFilter.containsKey(_cacheKey)) {
                return this._createCache_toElementTypeFilter.get(_cacheKey);
            }
            _result = _createElementTypeFilter = assistantFactory.createElementTypeFilter();
            this._createCache_toElementTypeFilter.put(_cacheKey, _result);
        }
        this._init_toElementTypeFilter(_result, diagram);
        return _result;
    }

    private void _init_toElementTypeFilter(ElementTypeFilter it, GenDiagram diagram) {
        it.setElementTypeID(diagram.getElementType().getUniqueIdentifier());
        it.setName(this.cleanedName(diagram.getDomainDiagramElement().getFormattedName()));
        this._modelingAssistantProviderRule.toModelingAssistantProvider(diagram.getEditorGen()).getOwnedFilters().add((Object)it);
    }

    private ElementType getElementType(ModelFacet facet) {
        EObject _eContainer = facet.eContainer();
        return ((GenCommonBase)_eContainer).getElementType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ElementTypeFilter _toElementTypeFilter(ModelFacet modelFacet) {
        ElementTypeFilter _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ModelFacet[]{modelFacet});
        HashMap<ArrayList<?>, ElementTypeFilter> hashMap = this._createCache_toElementTypeFilter_1;
        synchronized (hashMap) {
            ElementTypeFilter _createElementTypeFilter;
            if (this._createCache_toElementTypeFilter_1.containsKey(_cacheKey)) {
                return this._createCache_toElementTypeFilter_1.get(_cacheKey);
            }
            _result = _createElementTypeFilter = assistantFactory.createElementTypeFilter();
            this._createCache_toElementTypeFilter_1.put(_cacheKey, _result);
        }
        this._init_toElementTypeFilter_1(_result, modelFacet);
        return _result;
    }

    private void _init_toElementTypeFilter_1(ElementTypeFilter it, ModelFacet modelFacet) {
        it.setElementTypeID(this.getElementType(modelFacet).getUniqueIdentifier());
        it.setName(this.getElementType(modelFacet).getDisplayName());
        this._modelingAssistantProviderRule.toModelingAssistantProvider(this.rootEditor((EObject)modelFacet)).getOwnedFilters().add((Object)it);
    }

    protected PopupAssistant _toPopupAssistant(GenNode node) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PopupAssistant _toPopupAssistant(GenTopLevelNode node) {
        PopupAssistant _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new GenTopLevelNode[]{node});
        HashMap<ArrayList<?>, PopupAssistant> hashMap = this._createCache_toPopupAssistant;
        synchronized (hashMap) {
            PopupAssistant _createPopupAssistant;
            if (this._createCache_toPopupAssistant.containsKey(_cacheKey)) {
                return this._createCache_toPopupAssistant.get(_cacheKey);
            }
            _result = _createPopupAssistant = assistantFactory.createPopupAssistant();
            this._createCache_toPopupAssistant.put(_cacheKey, _result);
        }
        this._init_toPopupAssistant(_result, node);
        return _result;
    }

    private void _init_toPopupAssistant(PopupAssistant it, GenTopLevelNode node) {
        it.setElementTypeID(this.getElementType((ModelFacet)node.getModelFacet()).getUniqueIdentifier());
        it.setFilter((Filter)this.toElementTypeFilter((EObject)node.getDiagram()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PopupAssistant _toPopupAssistant(GenChildNode node) {
        PopupAssistant _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new GenChildNode[]{node});
        HashMap<ArrayList<?>, PopupAssistant> hashMap = this._createCache_toPopupAssistant_1;
        synchronized (hashMap) {
            PopupAssistant _createPopupAssistant;
            if (this._createCache_toPopupAssistant_1.containsKey(_cacheKey)) {
                return this._createCache_toPopupAssistant_1.get(_cacheKey);
            }
            _result = _createPopupAssistant = assistantFactory.createPopupAssistant();
            this._createCache_toPopupAssistant_1.put(_cacheKey, _result);
        }
        this._init_toPopupAssistant_1(_result, node);
        return _result;
    }

    private void _init_toPopupAssistant_1(PopupAssistant it, GenChildNode node) {
        it.setElementTypeID(this.getElementType((ModelFacet)node.getModelFacet()).getUniqueIdentifier());
        Filter _reduce = this._filtersUtil.reduce(this.createPossibleOwnersFilter(node));
        AssistedElementTypeFilter _assistedElementTypeFilter = this.assistedElementTypeFilter(this.rootEditor((EObject)node));
        Filter _and = this._filtersUtil.operator_and(_reduce, (Filter)_assistedElementTypeFilter);
        it.setFilter(_and);
        boolean _isCompound = this._filtersUtil.isCompound(it.getFilter());
        if (_isCompound) {
            it.setOwnedFilter(it.getFilter());
        }
    }

    private Filter createPossibleOwnersFilter(GenChildNode node) {
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> node.getContainers().contains(it_1);
            return IterableExtensions.exists((Iterable)it.getCompartments(), (Functions.Function1)_function_1);
        };
        Functions.Function1 _function_1 = it -> {
            TypeModelFacet _modelFacet = it.getModelFacet();
            ElementTypeFilter _elementTypeFilter = null;
            if (_modelFacet != null) {
                _elementTypeFilter = this.toElementTypeFilter((EObject)_modelFacet);
            }
            return _elementTypeFilter;
        };
        Functions.Function2 _function_2 = (filter, parentFilter) -> this._filtersUtil.operator_or(filter, (Filter)parentFilter);
        return (Filter)IterableExtensions.fold((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)node.getDiagram().getAllNodes(), (Functions.Function1)_function), (Functions.Function1)_function_1)), null, (Functions.Function2)_function_2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionAssistant toConnectionAssistant(GenLink link) {
        ConnectionAssistant _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new GenLink[]{link});
        HashMap<ArrayList<?>, ConnectionAssistant> hashMap = this._createCache_toConnectionAssistant;
        synchronized (hashMap) {
            ConnectionAssistant _createConnectionAssistant;
            if (this._createCache_toConnectionAssistant.containsKey(_cacheKey)) {
                return this._createCache_toConnectionAssistant.get(_cacheKey);
            }
            _result = _createConnectionAssistant = assistantFactory.createConnectionAssistant();
            this._createCache_toConnectionAssistant.put(_cacheKey, _result);
        }
        this._init_toConnectionAssistant(_result, link);
        return _result;
    }

    private void _init_toConnectionAssistant(ConnectionAssistant it, GenLink link) {
        boolean _isCompound_1;
        it.setElementTypeID(this.getElementType((ModelFacet)link.getModelFacet()).getUniqueIdentifier());
        Filter _reduce = this._filtersUtil.reduce(this.createPossibleSourcesFilter(link));
        AssistedElementTypeFilter _assistedElementTypeFilter = this.assistedElementTypeFilter(this.rootEditor((EObject)link));
        Filter _and = this._filtersUtil.operator_and(_reduce, (Filter)_assistedElementTypeFilter);
        it.setSourceFilter(_and);
        Filter _reduce_1 = this._filtersUtil.reduce(this.createPossibleTargetsFilter(link));
        AssistedElementTypeFilter _assistedElementTypeFilter_1 = this.assistedElementTypeFilter(this.rootEditor((EObject)link));
        Filter _and_1 = this._filtersUtil.operator_and(_reduce_1, (Filter)_assistedElementTypeFilter_1);
        it.setTargetFilter(_and_1);
        boolean _isCompound = this._filtersUtil.isCompound(it.getSourceFilter());
        if (_isCompound) {
            it.setOwnedSourceFilter(it.getSourceFilter());
        }
        if (_isCompound_1 = this._filtersUtil.isCompound(it.getTargetFilter())) {
            it.setOwnedTargetFilter(it.getTargetFilter());
        }
    }

    private Filter createPossibleSourcesFilter(GenLink link) {
        Functions.Function1 _function = it -> {
            TypeModelFacet _modelFacet = it.getModelFacet();
            ElementTypeFilter _elementTypeFilter = null;
            if (_modelFacet != null) {
                _elementTypeFilter = this.toElementTypeFilter((EObject)_modelFacet);
            }
            return _elementTypeFilter;
        };
        Functions.Function2 _function_1 = (filter, parentFilter) -> this._filtersUtil.operator_or(filter, (Filter)parentFilter);
        return (Filter)IterableExtensions.fold((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)link.getSources(), GenNode.class), (Functions.Function1)_function)), null, (Functions.Function2)_function_1);
    }

    private Filter createPossibleTargetsFilter(GenLink link) {
        Functions.Function1 _function = it -> {
            TypeModelFacet _modelFacet = it.getModelFacet();
            ElementTypeFilter _elementTypeFilter = null;
            if (_modelFacet != null) {
                _elementTypeFilter = this.toElementTypeFilter((EObject)_modelFacet);
            }
            return _elementTypeFilter;
        };
        Functions.Function2 _function_1 = (filter, parentFilter) -> this._filtersUtil.operator_or(filter, (Filter)parentFilter);
        return (Filter)IterableExtensions.fold((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)link.getTargets(), GenNode.class), (Functions.Function1)_function)), null, (Functions.Function2)_function_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AssistedElementTypeFilter assistedElementTypeFilter(GenEditorGenerator genEditor) {
        AssistedElementTypeFilter _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new GenEditorGenerator[]{genEditor});
        HashMap<ArrayList<?>, AssistedElementTypeFilter> hashMap = this._createCache_assistedElementTypeFilter;
        synchronized (hashMap) {
            AssistedElementTypeFilter _createAssistedElementTypeFilter;
            if (this._createCache_assistedElementTypeFilter.containsKey(_cacheKey)) {
                return this._createCache_assistedElementTypeFilter.get(_cacheKey);
            }
            _result = _createAssistedElementTypeFilter = assistantFactory.createAssistedElementTypeFilter();
            this._createCache_assistedElementTypeFilter.put(_cacheKey, _result);
        }
        this._init_assistedElementTypeFilter(_result, genEditor);
        return _result;
    }

    private void _init_assistedElementTypeFilter(AssistedElementTypeFilter it, GenEditorGenerator genEditor) {
        this._modelingAssistantProviderRule.toModelingAssistantProvider(genEditor).getOwnedFilters().add((Object)it);
    }

    public GenEditorGenerator rootEditor(EObject diagram) {
        if (diagram instanceof GenDiagram) {
            return this._rootEditor((GenDiagram)diagram);
        }
        if (diagram != null) {
            return this._rootEditor(diagram);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(diagram).toString());
    }

    public ElementTypeFilter toElementTypeFilter(EObject diagram) {
        if (diagram instanceof GenDiagram) {
            return this._toElementTypeFilter((GenDiagram)diagram);
        }
        if (diagram instanceof ModelFacet) {
            return this._toElementTypeFilter((ModelFacet)diagram);
        }
        if (diagram != null) {
            return this._toElementTypeFilter(diagram);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(diagram).toString());
    }

    public PopupAssistant toPopupAssistant(GenNode node) {
        if (node instanceof GenChildNode) {
            return this._toPopupAssistant((GenChildNode)node);
        }
        if (node instanceof GenTopLevelNode) {
            return this._toPopupAssistant((GenTopLevelNode)node);
        }
        if (node != null) {
            return this._toPopupAssistant(node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node).toString());
    }
}

