/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.p2.impl;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cbi.p2repo.p2.MetadataRepository;
import org.eclipse.cbi.p2repo.p2.P2Factory;
import org.eclipse.cbi.p2repo.p2.P2Package;
import org.eclipse.cbi.p2repo.p2.impl.RepositoryImpl;
import org.eclipse.cbi.p2repo.p2.impl.RepositoryReferenceImpl;
import org.eclipse.cbi.p2repo.p2.util.P2Bridge;
import org.eclipse.cbi.p2repo.util.ExceptionUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.internal.p2.metadata.TranslationSupport;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.LocalMetadataRepository;
import org.eclipse.equinox.p2.core.IPool;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.IRunnableWithProgress;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;

public class MetadataRepositoryImpl
extends RepositoryImpl<IInstallableUnit>
implements MetadataRepository {
    private static final Method LocalMetadataRepository_createRepositoriesSnapshot;
    private static final Pattern proxyFragmentPattern;
    protected EList<IInstallableUnit> installableUnits;
    protected EList<IRepositoryReference> references;
    private IQueryable<IInstallableUnit> queryable;
    private TranslationSupport translationSupport;

    static {
        try {
            LocalMetadataRepository_createRepositoriesSnapshot = LocalMetadataRepository.class.getDeclaredMethod("createRepositoriesSnapshot", new Class[0]);
            LocalMetadataRepository_createRepositoriesSnapshot.setAccessible(true);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        proxyFragmentPattern = Pattern.compile("^[^:]+:(.*)#\\/\\/.*$");
    }

    protected MetadataRepositoryImpl() {
    }

    public void addInstallableUnits(Collection<IInstallableUnit> installableUnits) {
        EList<IInstallableUnit> iuList = this.getInstallableUnits();
        for (IInstallableUnit iu : installableUnits) {
            iuList.add((Object)P2Bridge.importToModel(iu));
        }
    }

    private void addReference(URI location, String nickname, int type, int options) {
        RepositoryReferenceImpl ref = (RepositoryReferenceImpl)P2Factory.eINSTANCE.createRepositoryReference();
        ref.setLocation(location);
        ref.setNickname(nickname);
        ref.setType(type);
        ref.setOptions(options);
        this.getReferences().add((Object)ref);
    }

    public void addReferences(Collection<? extends IRepositoryReference> references) {
        for (IRepositoryReference iRepositoryReference : references) {
            this.addReference(iRepositoryReference.getLocation(), iRepositoryReference.getNickname(), iRepositoryReference.getType(), iRepositoryReference.getOptions());
        }
    }

    public boolean removeReferences(Collection<? extends IRepositoryReference> references) {
        return this.getReferences().removeAll(references);
    }

    public void addRepositoryReferences(IMetadataRepositoryManager mdrMgr, IMetadataRepository mdr) throws CoreException, OperationCanceledException {
        if (mdr instanceof LocalMetadataRepository) {
            try {
                List refs = (List)LocalMetadataRepository_createRepositoriesSnapshot.invoke((Object)mdr, new Object[0]);
                for (RepositoryReference ref : refs) {
                    this.addReference(ref.getLocation(), ref.getNickname(), ref.getType(), ref.getOptions());
                }
            }
            catch (Exception e) {
                throw ExceptionUtils.wrap((Throwable)e);
            }
        } else if (mdr instanceof CompositeMetadataRepository) {
            List children = ((CompositeMetadataRepository)mdr).getChildren();
            for (URI child : children) {
                this.addRepositoryReferences(mdrMgr, mdrMgr.loadRepository(child, null));
            }
        }
    }

    public void compress(IPool<IInstallableUnit> iuPool) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getInstallableUnits();
            }
            case 10: {
                return this.getReferences();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return ((InternalEList)this.getInstallableUnits()).basicRemove((Object)otherEnd, msgs);
            }
            case 10: {
                return ((InternalEList)this.getReferences()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.installableUnits != null && !this.installableUnits.isEmpty();
            }
            case 10: {
                return this.references != null && !this.references.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetadataRepositoryImpl)) {
            return false;
        }
        return this.getSafeLocation().equals(((MetadataRepositoryImpl)obj).getSafeLocation());
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.getInstallableUnits().clear();
                this.getInstallableUnits().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.getReferences().clear();
                this.getReferences().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    protected EClass eStaticClass() {
        return P2Package.Literals.METADATA_REPOSITORY;
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.getInstallableUnits().clear();
                return;
            }
            case 10: {
                this.getReferences().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public IStatus executeBatch(IRunnableWithProgress runnable, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public EList<IInstallableUnit> getInstallableUnits() {
        if (this.installableUnits == null) {
            this.installableUnits = new EObjectContainmentEList.Resolving<IInstallableUnit>(IInstallableUnit.class, (InternalEObject)this, 9){
                private static final long serialVersionUID = 1L;

                protected void didChange() {
                    MetadataRepositoryImpl.this.queryable = null;
                    MetadataRepositoryImpl.this.translationSupport = null;
                    super.didChange();
                }
            };
        }
        return this.installableUnits;
    }

    public URI getLocationFromProxy() {
        Matcher m = proxyFragmentPattern.matcher(this.eProxyURI().toString());
        try {
            return m.matches() ? new URI(m.group(1)) : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public String getNameFromProxy() {
        return null;
    }

    @Override
    public EList<IRepositoryReference> getReferences() {
        if (this.references == null) {
            this.references = new EObjectContainmentEList.Resolving(IRepositoryReference.class, (InternalEObject)this, 10);
        }
        return this.references;
    }

    public URI getSafeLocation() {
        return this.location != null ? this.location : this.getLocationFromProxy();
    }

    public TranslationSupport getTranslationSupport() {
        if (this.translationSupport == null) {
            this.translationSupport = new TranslationSupport((IQueryable)this);
        }
        return this.translationSupport;
    }

    @Override
    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor progress) {
        if (this.queryable == null) {
            EList<IInstallableUnit> installableUnits = this.getInstallableUnits();
            this.queryable = new QueryableArray((IInstallableUnit[])installableUnits.toArray((Object[])new IInstallableUnit[installableUnits.size()]));
        }
        return this.queryable.query(query, progress);
    }

    public void removeAll() {
        this.getInstallableUnits().clear();
    }

    public boolean removeInstallableUnits(Collection<IInstallableUnit> installableUnits) {
        if (installableUnits == null) {
            return false;
        }
        EList<IInstallableUnit> units = this.getInstallableUnits();
        return units.removeAll(installableUnits);
    }
}

