/**
 * Copyright (c) 2006, 2009, 2013, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Alexander Shatalin (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 */
package diagram.editparts;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import impl.diagram.editparts.TextAwareExtent;
import org.eclipse.papyrus.gmf.codegen.gmfgen.CustomBehaviour;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenFloatingLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.LinkLabelAlignment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.CodeStyle;
import xpt.Common;
import xpt.diagram.ViewmapAttributesUtils_qvto;
import xpt.editor.VisualIDRegistry;

@Singleton
@SuppressWarnings("all")
public class LinkLabelEditPart {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private CodeStyle _codeStyle;

  @Inject
  private TextAwareExtent xptTextAware;

  @Inject
  private xpt.diagram.editparts.Common xptEditpartsCommon;

  @Inject
  private VisualIDRegistry xptVisualIDRegistry;

  @Inject
  @Extension
  private ViewmapAttributesUtils_qvto _viewmapAttributesUtils_qvto;

  public CharSequence className(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartClassName = it.getEditPartClassName();
    _builder.append(_editPartClassName);
    return _builder;
  }

  public CharSequence Main(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _attributes = this.attributes(it);
    _builder.append(_attributes, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _initializer = this.initializer(it);
    _builder.append(_initializer, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _constructor = this.constructor(it);
    _builder.append(_constructor, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _createDefaultEditPolicies = this.createDefaultEditPolicies(it);
    _builder.append(_createDefaultEditPolicies, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _keyPointExtent = this.getKeyPointExtent(it);
    _builder.append(_keyPointExtent, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _labelIconNotUseElementIcon = this.xptTextAware.getLabelIconNotUseElementIcon(it, it.isElementIcon(), it.getDiagram());
    _builder.append(_labelIconNotUseElementIcon, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _methodsExtent = this.xptTextAware.methodsExtent(it, false, it.isReadOnly(), it.getModelFacet(), it.getLink());
    _builder.append(_methodsExtent, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _handleNotificationEvent = this.handleNotificationEvent(it);
    _builder.append(_handleNotificationEvent, "\t");
    _builder.newLineIfNotEmpty();
    {
      Viewmap _viewmap = it.getViewmap();
      boolean _not = (!(_viewmap instanceof ParentAssignedViewmap));
      if (_not) {
        _builder.append("\t");
        CharSequence _labelFigure = this.xptEditpartsCommon.labelFigure(it.getViewmap());
        _builder.append(_labelFigure, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence packageName(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartsPackageName = it.getDiagram().getEditPartsPackageName();
    _builder.append(_editPartsPackageName);
    return _builder;
  }

  public CharSequence initializer(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("static {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("registerSnapBackPosition(");
    CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall(it);
    _builder.append(_typeMethodCall, "\t");
    _builder.append(", new org.eclipse.draw2d.geometry.Point(");
    int _labelOffsetX = this._viewmapAttributesUtils_qvto.labelOffsetX(it.getViewmap(), 0);
    _builder.append(_labelOffsetX, "\t");
    _builder.append(", ");
    int _labelOffsetY = this._viewmapAttributesUtils_qvto.labelOffsetY(it.getViewmap(), 0);
    _builder.append(_labelOffsetY, "\t");
    _builder.append("));");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence extendsList(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.papyrus.uml.diagram.common.editparts.AbstractLinkLabelEditPart");
    return _builder;
  }

  public CharSequence implementsList(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenFloatingLabel _labelVisibilityPreference = it.getLabelVisibilityPreference();
      boolean _tripleNotEquals = (_labelVisibilityPreference != null);
      if (_tripleNotEquals) {
        _builder.append("implements org.eclipse.papyrus.uml.diagram.common.editparts.ILabelRoleProvider");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence attributes(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _visualIDConstant = this.xptEditpartsCommon.visualIDConstant(it);
    _builder.append(_visualIDConstant);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence constructor(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("super(view);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence getKeyPointExtent(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      LinkLabelAlignment _alignment = it.getAlignment();
      boolean _notEquals = (!Objects.equal(_alignment, LinkLabelAlignment.MIDDLE_LITERAL));
      if (_notEquals) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("public int getKeyPoint() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return org.eclipse.draw2d.ConnectionLocator.");
        LinkLabelAlignment _alignment_1 = it.getAlignment();
        _builder.append(_alignment_1, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence createDefaultEditPolicies(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* @generated Papyrus Generation");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    CharSequence _overrideC = this._codeStyle.overrideC(it);
    _builder.append(_overrideC);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void createDefaultEditPolicies() {\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("super.createDefaultEditPolicies();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.DIRECT_EDIT_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.SELECTION_FEEDBACK_ROLE, new org.eclipse.papyrus.uml.diagram.common.editpolicies.UMLTextSelectionEditPolicy());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE, new org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.PapyrusLinkLabelDragPolicy());");
    _builder.newLine();
    {
      Iterable<CustomBehaviour> _filter = Iterables.<CustomBehaviour>filter(it.getBehaviour(), CustomBehaviour.class);
      for(final CustomBehaviour CustomBehaviour : _filter) {
        _builder.append("\t");
        _builder.append("installEditPolicy(");
        String _key = CustomBehaviour.getKey();
        _builder.append(_key, "\t");
        _builder.append(", new ");
        String _editPolicyQualifiedClassName = CustomBehaviour.getEditPolicyQualifiedClassName();
        _builder.append(_editPolicyQualifiedClassName, "\t");
        _builder.append("());");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence handleNotificationEvent(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isElementIcon = it.isElementIcon();
      if (_isElementIcon) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append(_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void handleNotificationEvent(org.eclipse.emf.common.notify.Notification event) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(event.getNewValue() instanceof org.eclipse.emf.ecore.EAnnotation && org.eclipse.papyrus.infra.emf.appearance.helper.VisualInformationPapyrusConstants.DISPLAY_NAMELABELICON.equals(((org.eclipse.emf.ecore.EAnnotation)event.getNewValue()).getSource())){\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("refreshLabel();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.handleNotificationEvent(event);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }

  public CharSequence additions(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      GenFloatingLabel _labelVisibilityPreference = it.getLabelVisibilityPreference();
      boolean _tripleNotEquals = (_labelVisibilityPreference != null);
      if (_tripleNotEquals) {
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append(_generatedClassComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append(_overrideI);
        _builder.newLineIfNotEmpty();
        _builder.append("public String getLabelRole(){");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return \"");
        String _role = it.getLabelVisibilityPreference().getRole();
        _builder.append(_role, "\t");
        _builder.append("\";//$NON-NLS-1$");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generatedClassComment_1 = this._common.generatedClassComment();
        _builder.append(_generatedClassComment_1);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideI_1 = this._codeStyle.overrideI(it);
        _builder.append(_overrideI_1);
        _builder.newLineIfNotEmpty();
        _builder.append("public String getIconPathRole(){");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return \"");
        String _iconPathRole = it.getLabelVisibilityPreference().getIconPathRole();
        _builder.append(_iconPathRole, "\t");
        _builder.append("\";//$NON-NLS-1$");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
}
