/**
 * Copyright (c) 2007-2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.diagram.commands;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class ReorientLinkCommand {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  private ReorientLinkUtils xptReorientLinkUtils;
  
  public CharSequence className(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    String _reorientCommandClassName = it.getReorientCommandClassName();
    _builder.append(_reorientCommandClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editCommandsPackageName = it.getDiagram().getEditCommandsPackageName();
    _builder.append(_editCommandsPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence ReorientLinkCommand(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" extends org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private final int reorientDirection;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private final org.eclipse.emf.ecore.EObject oldEnd;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private final org.eclipse.emf.ecore.EObject newEnd;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    CharSequence _className_1 = this.className(it);
    _builder.append(_className_1, "\t");
    _builder.append("(org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest request) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("super(request.getLabel(), request.getRelationship(), request);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("reorientDirection = request.getDirection();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("oldEnd = request.getOldRelationshipEnd();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("newEnd = request.getNewRelationshipEnd();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _canReorient = this.xptReorientLinkUtils.canReorient(it.getModelFacet(), it);
    _builder.append(_canReorient, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _reorient = this.xptReorientLinkUtils.reorient(it.getModelFacet());
    _builder.append(_reorient, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _accessors = this.xptReorientLinkUtils.accessors(it);
    _builder.append(_accessors, "\t");
    _builder.newLineIfNotEmpty();
    CharSequence _additions = this.additions(it);
    _builder.append(_additions);
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
}
