/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.helper;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.common.AbstractPapyrusGmfCreateDiagramCommandHandler;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramPrototype;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.AbstractViewTypeHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class GMFDiagramViewTypeHelper
extends AbstractViewTypeHelper<PapyrusDiagram> {
    public GMFDiagramViewTypeHelper() {
        super(PapyrusDiagram.class);
    }

    public boolean isSupported(EObject view) {
        return view instanceof Diagram;
    }

    protected ViewPrototype doGetPrototypeFor(PapyrusDiagram diagramKind) {
        String commandClassName = diagramKind.getCreationCommandClass();
        if (commandClassName != null) {
            Class creationCommandClass = ClassLoaderHelper.loadClass((String)commandClassName, AbstractPapyrusGmfCreateDiagramCommandHandler.class, (URI)EcoreUtil.getURI((EObject)diagramKind));
            if (creationCommandClass != null) {
                AbstractPapyrusGmfCreateDiagramCommandHandler command;
                try {
                    command = (AbstractPapyrusGmfCreateDiagramCommandHandler)((Object)creationCommandClass.newInstance());
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                    return null;
                }
                String language = diagramKind.getLanguage().getId();
                return new DiagramPrototype(diagramKind, language, command);
            }
            Activator.log.error((Throwable)new ClassNotFoundException(String.format("Can not load creation command class %s for diagramKind %s.", commandClassName, diagramKind.getName())));
        }
        return null;
    }

    protected ViewPrototype doGetPrototypeOf(EObject view) {
        Diagram diagram = (Diagram)view;
        PolicyChecker checker = this.getPolicyChecker((EObject)diagram);
        return DiagramUtils.getPrototype(diagram, checker, false);
    }
}

