/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.util.List;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

public class ConnectorUtil {
    public static boolean isDelegation(Class composite, Port port) {
        return ConnectorUtil.getDelegation(composite, port) != null;
    }

    public static ConnectorEnd getDelegation(Class composite, Port port) {
        for (Connector connector : composite.getOwnedConnectors()) {
            ConnectorEnd otherEnd;
            if (!ConnectorUtil.connectsPort(connector, port) || (otherEnd = ConnectorUtil.connEndNotPart(connector, null)) == null) continue;
            return otherEnd;
        }
        return null;
    }

    public static List<ConnectorEnd> getDelegations(Class composite, Port port) {
        UniqueEList conectorEnds = new UniqueEList();
        for (Connector connector : composite.getOwnedConnectors()) {
            ConnectorEnd otherEnd;
            if (!ConnectorUtil.connectsPort(connector, port) || (otherEnd = ConnectorUtil.connEndNotPart(connector, null)) == null) continue;
            conectorEnds.add((Object)otherEnd);
        }
        return conectorEnds;
    }

    public static boolean connectsPort(Connector connection, Port port) {
        for (ConnectorEnd end : connection.getEnds()) {
            if (end.getRole() != port) continue;
            return true;
        }
        return false;
    }

    public static ConnectorEnd connEndForPart(Connector connection, Property part) {
        for (ConnectorEnd end : connection.getEnds()) {
            ConnectableElement role = end.getRole();
            Property connectedPart = null;
            if (role instanceof Port) {
                connectedPart = end.getPartWithPort();
            } else if (role instanceof Property) {
                connectedPart = (Property)role;
            }
            if (connectedPart != part) continue;
            return end;
        }
        return null;
    }

    public static ConnectorEnd connEndNotPart(Connector connection, Property part) {
        for (ConnectorEnd end : connection.getEnds()) {
            ConnectableElement role = end.getRole();
            Property connectedPart = null;
            if (role instanceof Port) {
                connectedPart = end.getPartWithPort();
            } else if (role instanceof Property) {
                connectedPart = (Property)role;
            }
            if (connectedPart == part) continue;
            return end;
        }
        return null;
    }

    public static boolean connectsPart(Connector connection, Property part) {
        return ConnectorUtil.connEndForPart(connection, part) != null;
    }

    public static boolean isAssembly(Connector connection) {
        return ConnectorUtil.connEndForPart(connection, null) == null;
    }

    public static Connector getConnector(Class composite, Property partA, Property partB) {
        for (Connector connector : composite.getOwnedConnectors()) {
            if (!ConnectorUtil.connectsPart(connector, partA) || !ConnectorUtil.connectsPart(connector, partB)) continue;
            return connector;
        }
        return null;
    }

    public static boolean existsConnector(Class composite, Property partA, Property partB) {
        return ConnectorUtil.getConnector(composite, partA, partB) != null;
    }
}

