/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.factory;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IPluginEditor;
import org.eclipse.papyrus.toolsmiths.factory.FileBasedExtensionFactory;
import org.eclipse.papyrus.toolsmiths.messages.Messages;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.CustomizableElement;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.CustomizationPluginPackage;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.FileBasedCustomizableElement;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.Palette;
import org.w3c.dom.Element;

public class PaletteExtensionFactory
extends FileBasedExtensionFactory {
    public static final String PALETTE_ROOT_FOLDER = new String("palette");

    public PaletteExtensionFactory() {
        super(Messages.PaletteFactory_Palette, "org.eclipse.papyrus.infra.gmfdiag.common.paletteDefinition", "path", "paletteDefinition", true);
    }

    public void addElement(CustomizableElement element, IPluginEditor editor) {
        super.addElement(element, editor);
        editor.addDependency("org.eclipse.papyrus.infra.gmfdiag.common");
    }

    protected Element createExtension(FileBasedCustomizableElement customizableElement, IPluginEditor editor) {
        Element extension = super.createExtension(customizableElement, editor);
        if (customizableElement instanceof Palette) {
            Palette element = (Palette)customizableElement;
            extension.setAttribute("ID", element.getID());
            if (element.getName() != null) {
                extension.setAttribute("name", element.getName());
            }
            if (element.getClazz() != null) {
                extension.setAttribute("class", element.getClazz());
            }
            if (element.getProvider() != null) {
                extension.setAttribute("provider", element.getProvider());
            }
            if (element.getPriorityName() != null) {
                Element priority = extension.getOwnerDocument().createElement("Priority");
                priority.setAttribute("name", element.getPriorityName());
                extension.appendChild(priority);
            }
            if (element.getProvider() != null) {
                Element editor2 = extension.getOwnerDocument().createElement("editor");
                editor2.setAttribute("id", element.getEditorId());
                extension.appendChild(editor2);
            }
        }
        return extension;
    }

    protected String getTargetPath(FileBasedCustomizableElement element) {
        return this.getFilePath(element.getFile());
    }

    protected String getFilePath(String file) {
        return String.valueOf(File.separator) + PALETTE_ROOT_FOLDER + File.separator + this.getFileName(file);
    }

    public EClass getCustomizableElementClass() {
        return CustomizationPluginPackage.eINSTANCE.getPalette();
    }

    protected void copyFile(FileBasedCustomizableElement element, IPluginEditor editor) throws FileNotFoundException, IOException {
        this.copyFile(element.getFile(), this.getFilePath(((Palette)element).getFile()), editor);
    }
}

