/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.architecture.merger;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.architecture.Activator;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureFactory;
import org.eclipse.papyrus.infra.core.architecture.Concern;
import org.eclipse.papyrus.infra.core.architecture.Stakeholder;
import org.eclipse.papyrus.infra.core.architecture.TreeViewerConfiguration;
import org.eclipse.papyrus.infra.core.architecture.util.FormattableADElement;
import org.eclipse.papyrus.infra.core.architecture.util.MergeTraceAdapter;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.MergePhase;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.MergeState;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@Singleton
public class ArchitectureExtensions {
    @Extension
    private static ArchitectureFactory factory = ArchitectureFactory.eINSTANCE;
    @Inject
    @Named(value="MERGE_TRACE")
    private BiConsumer<? super ADElement, ? super ADElement> mergeTrace;
    @Inject
    @Extension
    private MergeState _mergeState;
    private final ECrossReferenceAdapter xrefAdapter = new ECrossReferenceAdapter(){

        protected void setTarget(Resource target) {
            super.setTarget(target);
            ResourceSet _resourceSet = target.getResourceSet();
            if (_resourceSet != null) {
                this.addAdapter((Notifier)_resourceSet);
            }
        }

        protected void setTarget(EObject target) {
            super.setTarget(target);
            if (!this.iterating) {
                Procedures.Procedure1 _function = it -> {
                    InternalEObject _eInternalContainer;
                    Resource.Internal _eDirectResource = it.eDirectResource();
                    if (_eDirectResource != null) {
                        this.addAdapter((Notifier)_eDirectResource);
                    }
                    if ((_eInternalContainer = it.eInternalContainer()) != null) {
                        this.addAdapter((Notifier)_eInternalContainer);
                    }
                };
                ObjectExtensions.operator_doubleArrow((Object)((InternalEObject)target), (Procedures.Procedure1)_function);
            }
        }
    };
    private final HashMap<ArrayList<?>, Stakeholder> _createCache_mergedStakeholder = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Concern> _createCache_mergedConcern = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, TreeViewerConfiguration> _createCache_merged = CollectionLiterals.newHashMap();

    private ECrossReferenceAdapter xrefs(EObject object) {
        ECrossReferenceAdapter _elvis = null;
        ECrossReferenceAdapter _crossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)object);
        if (_crossReferenceAdapter != null) {
            _elvis = _crossReferenceAdapter;
        } else {
            ECrossReferenceAdapter _doubleArrow;
            Procedures.Procedure1 _function = it -> {
                EList _eAdapters = object.eAdapters();
                _eAdapters.add(it);
            };
            _elvis = _doubleArrow = (ECrossReferenceAdapter)ObjectExtensions.operator_doubleArrow((Object)this.xrefAdapter, (Procedures.Procedure1)_function);
        }
        return _elvis;
    }

    public <T extends EObject> Iterable<T> invert(EObject target, EReference reference) {
        Functions.Function1 _function = it -> {
            EObject _eObject = it.getEObject();
            return _eObject;
        };
        return IterableExtensions.map((Iterable)this.xrefs(target).getInverseReferences(target, reference, true), (Functions.Function1)_function);
    }

    public boolean isReferenced(EObject target, EReference reference) {
        boolean _isEmpty = this.xrefs(target).getInverseReferences(target, reference, true).isEmpty();
        return !_isEmpty;
    }

    public <T extends ADElement> T trace(T mergedElement) {
        MergeTraceAdapter _mergeTraces = MergeTraceAdapter.getMergeTraces(mergedElement);
        Collection _trace = null;
        if (_mergeTraces != null) {
            _trace = _mergeTraces.trace(mergedElement);
        }
        ADElement _head = (ADElement)IterableExtensions.head(_trace);
        return (T)_head;
    }

    public <T> EList<T> eGetAsList(final EObject owner, final EStructuralFeature feature, Class<T> type) {
        Object _xifexpression = null;
        boolean _isMany = feature.isMany();
        if (_isMany) {
            Object _eGet = owner.eGet(feature);
            _xifexpression = (EList)_eGet;
        } else {
            int _xifexpression_1 = 0;
            Object _eGet_1 = owner.eGet(feature);
            boolean _tripleEquals = _eGet_1 == null;
            _xifexpression_1 = _tripleEquals ? 0 : 1;
            Object _eGet_2 = owner.eGet(feature);
            _xifexpression = new BasicEList<T>(_xifexpression_1, new Object[]{_eGet_2}){

                protected void didAdd(int index, Object newObject) {
                    if (index == 0) {
                        owner.eSet(feature, newObject);
                    }
                }

                protected void didSet(int index, Object newObject, Object oldObject) {
                    if (index == 0) {
                        owner.eSet(feature, newObject);
                    }
                }

                protected void didRemove(int index, Object oldObject) {
                    if (index == 0) {
                        boolean _isEmpty = this.isEmpty();
                        if (_isEmpty) {
                            owner.eSet(feature, null);
                        } else {
                            owner.eSet(feature, this.get(0));
                        }
                    }
                }

                protected void didClear(int size, Object[] oldObjects) {
                    owner.eSet(feature, null);
                }

                protected void didMove(int index, Object movedObject, int oldIndex) {
                    if (index == 0) {
                        owner.eSet(feature, movedObject);
                    }
                }
            };
        }
        return _xifexpression;
    }

    public <T extends ADElement> void traceTo(T target, T source) {
        this.mergeTrace.accept(target, source);
    }

    static void logf(String pattern, Object ... arg) {
        boolean _isTraceEnabled = Activator.log.isTraceEnabled("merge");
        if (_isTraceEnabled) {
            Activator.log.trace("merge", String.format(pattern, FormattableADElement.wrapAll((Object[])arg)));
        }
    }

    public Object formatted(ADElement element) {
        return FormattableADElement.wrap((Object)element);
    }

    public <T extends ADElement> T copy(T target, T source) {
        String _icon_1;
        String _description_1;
        String _id_1;
        String _name_1;
        T _xblockexpression = null;
        String _elvis = null;
        String _name = target.getName();
        _elvis = _name != null ? _name : (_name_1 = source.getName());
        target.setName(_elvis);
        String _elvis_1 = null;
        String _id = target.getId();
        _elvis_1 = _id != null ? _id : (_id_1 = source.getId());
        target.setId(_elvis_1);
        String _elvis_2 = null;
        String _description = target.getDescription();
        _elvis_2 = _description != null ? _description : (_description_1 = source.getDescription());
        target.setDescription(_elvis_2);
        String _elvis_3 = null;
        String _icon = target.getIcon();
        _elvis_3 = _icon != null ? _icon : (_icon_1 = source.getIcon());
        target.setIcon(_elvis_3);
        this.traceTo(target, source);
        _xblockexpression = target;
        return _xblockexpression;
    }

    public Stakeholder mergedStakeholder(String name) {
        return this.mergedStakeholder(name, this.currentScope());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stakeholder mergedStakeholder(String name, Object scope) {
        Stakeholder _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{name, scope});
        HashMap<ArrayList<?>, Stakeholder> hashMap = this._createCache_mergedStakeholder;
        synchronized (hashMap) {
            Stakeholder _createStakeholder;
            if (this._createCache_mergedStakeholder.containsKey(_cacheKey)) {
                return this._createCache_mergedStakeholder.get(_cacheKey);
            }
            _result = _createStakeholder = factory.createStakeholder();
            this._createCache_mergedStakeholder.put(_cacheKey, _result);
        }
        this._init_mergedStakeholder(_result, name, scope);
        return _result;
    }

    private void _init_mergedStakeholder(Stakeholder result, String name, Object scope) {
        Functions.Function1 _function = it -> it.getStakeholders();
        Functions.Function1 _function_1 = it -> {
            String _name = it.getName();
            return Objects.equals(_name, name);
        };
        Consumer<Stakeholder> _function_2 = it -> {
            this.copy((ADElement)result, (ADElement)it);
            EList _concerns = result.getConcerns();
            Functions.Function1 _function_3 = it_1 -> it_1.getName();
            Functions.Function1 _function_4 = it_1 -> this.mergedConcern((String)it_1);
            Iterable _map = IterableExtensions.map(this.mapUnique((Iterable)it.getConcerns(), (Functions.Function1)_function_3), (Functions.Function1)_function_4);
            Iterables.addAll((Collection)_concerns, (Iterable)_map);
            ArchitectureExtensions.logf("Merged %s into %s", it, result);
        };
        IterableExtensions.filter((Iterable)IterableExtensions.flatMap(this.currentScope(), (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
    }

    public Concern mergedConcern(String name) {
        return this.mergedConcern(name, this.currentScope());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Concern mergedConcern(String name, Object scope) {
        Concern _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{name, scope});
        HashMap<ArrayList<?>, Concern> hashMap = this._createCache_mergedConcern;
        synchronized (hashMap) {
            Concern _createConcern;
            if (this._createCache_mergedConcern.containsKey(_cacheKey)) {
                return this._createCache_mergedConcern.get(_cacheKey);
            }
            _result = _createConcern = factory.createConcern();
            this._createCache_mergedConcern.put(_cacheKey, _result);
        }
        this._init_mergedConcern(_result, name, scope);
        return _result;
    }

    private void _init_mergedConcern(Concern result, String name, Object scope) {
        Functions.Function1 _function = it -> it.getConcerns();
        Functions.Function1 _function_1 = it -> {
            String _name = it.getName();
            return Objects.equals(_name, name);
        };
        Consumer<Concern> _function_2 = it -> {
            this.copy((ADElement)result, (ADElement)it);
            ArchitectureExtensions.logf("Merged %s into %s", it, result);
        };
        IterableExtensions.filter((Iterable)IterableExtensions.flatMap(this.currentScope(), (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeViewerConfiguration merged(TreeViewerConfiguration treeViewerConfig) {
        TreeViewerConfiguration _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new TreeViewerConfiguration[]{treeViewerConfig});
        HashMap<ArrayList<?>, TreeViewerConfiguration> hashMap = this._createCache_merged;
        synchronized (hashMap) {
            TreeViewerConfiguration _copy;
            if (this._createCache_merged.containsKey(_cacheKey)) {
                return this._createCache_merged.get(_cacheKey);
            }
            _result = _copy = (TreeViewerConfiguration)EcoreUtil.copy((EObject)treeViewerConfig);
            this._createCache_merged.put(_cacheKey, _result);
        }
        this._init_merged(_result, treeViewerConfig);
        return _result;
    }

    private void _init_merged(TreeViewerConfiguration it, TreeViewerConfiguration treeViewerConfig) {
    }

    public boolean inInheritancePhase() {
        MergePhase _phase = this._mergeState.phase();
        return _phase == MergePhase.INHERITANCE;
    }

    public boolean inExtensionsPhase() {
        return this._mergeState.phase() == MergePhase.EXTENSIONS || this._mergeState.phase() == MergePhase.LEGACY;
    }

    public Set<? extends ArchitectureDomain> currentScope() {
        return this._mergeState.currentDomains();
    }

    public <T> T withScope(Iterable<? extends ArchitectureDomain> domains, Functions.Function0<T> block) {
        return this._mergeState.withDomains(domains, block);
    }

    public void withScope(Iterable<? extends ArchitectureDomain> domains, Procedures.Procedure0 block) {
        Functions.Function0 _function = () -> {
            Object _xblockexpression = null;
            block.apply();
            _xblockexpression = null;
            return _xblockexpression;
        };
        this.withScope(domains, _function);
    }

    @Pure
    public <T, K> Iterable<T> uniqueBy(Iterable<T> iterable, final Functions.Function1<? super T, K> keyer) {
        Iterable _function = () -> {
            abstract class __ArchitectureExtensions_3
            extends AbstractIterator<T> {
                Iterator<T> delegate;
                Set<K> uniquifier;

                __ArchitectureExtensions_3() {
                }
            }
            return new __ArchitectureExtensions_3(this, iterable){
                {
                    this.delegate = iterable.iterator();
                    this.uniquifier = CollectionLiterals.newHashSet();
                }

                protected T computeNext() {
                    Object _xblockexpression = null;
                    while (this.delegate.hasNext()) {
                        Object next = this.delegate.next();
                        Object _apply = keyer.apply(next);
                        boolean _add = this.uniquifier.add(_apply);
                        if (!_add) continue;
                        return next;
                    }
                    _xblockexpression = this.endOfData();
                    return _xblockexpression;
                }
            };
        };
        return _function;
    }

    @Pure
    public <T, R> Iterable<R> mapUnique(Iterable<T> iterable, Functions.Function1<? super T, R> mapper) {
        return this.unique(IterableExtensions.map(iterable, mapper));
    }

    @Pure
    public <T> Iterable<T> unique(Iterable<T> iterable) {
        Iterable _function = () -> {
            abstract class __ArchitectureExtensions_4
            extends AbstractIterator<T> {
                Iterator<T> delegate;
                Set<T> uniquifier;

                __ArchitectureExtensions_4() {
                }
            }
            return new __ArchitectureExtensions_4(this, iterable){
                {
                    this.delegate = iterable.iterator();
                    this.uniquifier = CollectionLiterals.newHashSet();
                }

                protected T computeNext() {
                    Object _xblockexpression = null;
                    while (this.delegate.hasNext()) {
                        Object next = this.delegate.next();
                        boolean _add = this.uniquifier.add(next);
                        if (!_add) continue;
                        return next;
                    }
                    _xblockexpression = this.endOfData();
                    return _xblockexpression;
                }
            };
        };
        return _function;
    }

    @Pure
    public <T extends ADElement> Iterable<T> named(Iterable<T> iterable, String selectedName) {
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return Objects.equals(_name, selectedName);
        };
        return IterableExtensions.filter(iterable, (Functions.Function1)_function);
    }

    @Pure
    public <T> Iterable<T> excluding(Iterable<T> iterable, Object ... excluded) {
        Iterable _xblockexpression = null;
        HashSet unwanted = CollectionLiterals.newHashSet((Object[])excluded);
        Functions.Function1 _function = it -> unwanted.contains(it);
        _xblockexpression = IterableExtensions.reject(iterable, (Functions.Function1)_function);
        return _xblockexpression;
    }
}

