/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.RowPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public class RowGroupReorderCommand
implements ILayerCommand {
    private int level;
    private RowPositionCoordinate fromRowPositionCoordinate;
    private RowPositionCoordinate toRowPositionCoordinate;
    private boolean reorderToTopEdge;
    private boolean performConversion;

    public RowGroupReorderCommand(ILayer layer, int level, int fromRowPosition, int toRowPosition) {
        this(layer, level, fromRowPosition, toRowPosition, true);
    }

    public RowGroupReorderCommand(ILayer layer, int level, int fromRowPosition, int toRowPosition, boolean performConversion) {
        this.fromRowPositionCoordinate = new RowPositionCoordinate(layer, fromRowPosition);
        this.level = level;
        if (toRowPosition < layer.getRowCount()) {
            this.reorderToTopEdge = true;
        } else {
            this.reorderToTopEdge = false;
            --toRowPosition;
        }
        this.toRowPositionCoordinate = new RowPositionCoordinate(layer, toRowPosition);
        this.performConversion = performConversion;
    }

    protected RowGroupReorderCommand(RowGroupReorderCommand command) {
        this.level = command.level;
        this.fromRowPositionCoordinate = command.fromRowPositionCoordinate;
        this.toRowPositionCoordinate = command.toRowPositionCoordinate;
        this.reorderToTopEdge = command.reorderToTopEdge;
        this.performConversion = command.performConversion;
    }

    public int getLevel() {
        return this.level;
    }

    public int getFromRowPosition() {
        return this.fromRowPositionCoordinate.getRowPosition();
    }

    public int getToRowPosition() {
        return this.toRowPositionCoordinate.getRowPosition();
    }

    public boolean isReorderToTopEdge() {
        return this.reorderToTopEdge;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        if (this.performConversion) {
            RowPositionCoordinate targetFromRowPositionCoordinate = LayerCommandUtil.convertRowPositionToTargetContext(this.fromRowPositionCoordinate, targetLayer);
            RowPositionCoordinate targetToRowPositionCoordinate = LayerCommandUtil.convertRowPositionToTargetContext(this.toRowPositionCoordinate, targetLayer);
            if (targetFromRowPositionCoordinate != null && targetToRowPositionCoordinate != null) {
                this.fromRowPositionCoordinate = targetFromRowPositionCoordinate;
                this.toRowPositionCoordinate = targetToRowPositionCoordinate;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public RowGroupReorderCommand cloneCommand() {
        return new RowGroupReorderCommand(this);
    }
}

