/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.advice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.DuplicateDiagramCommand;

public class GMFDiagramDuplicateEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDuplicateCommand(DuplicateElementsRequest request) {
        Object additional = request.getParameter("Additional_Duplicated_Elements");
        if (!(additional instanceof Set)) {
            return super.getBeforeDuplicateCommand(request);
        }
        Set duplicatedObjects = (Set)additional;
        EObject object = this.getDuplicatedEObject(request);
        if (object == null || object.eResource() == null) {
            return super.getBeforeDuplicateCommand(request);
        }
        ArrayList<Diagram> diagramsToDuplicate = new ArrayList<Diagram>();
        ResourceSet resourceSet = object.eResource().getResourceSet();
        ECrossReferenceAdapter adapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)resourceSet);
        if (adapter == null) {
            adapter = new ECrossReferenceAdapter();
            resourceSet.eAdapters().add((Object)adapter);
        }
        if (object instanceof View) {
            return super.getBeforeDuplicateCommand(request);
        }
        Collection settings = adapter.getInverseReferences(object, false);
        for (EStructuralFeature.Setting setting : settings) {
            EObject value = setting.getEObject();
            if (!(value instanceof Diagram)) continue;
            diagramsToDuplicate.add((Diagram)value);
        }
        TreeIterator it = object.eAllContents();
        while (it.hasNext()) {
            EObject child = (EObject)it.next();
            settings = adapter.getInverseReferences(child, false);
            for (EStructuralFeature.Setting setting : settings) {
                EObject value = setting.getEObject();
                if (!(value instanceof Diagram)) continue;
                diagramsToDuplicate.add((Diagram)value);
            }
        }
        if (!diagramsToDuplicate.isEmpty()) {
            CompositeCommand command = null;
            for (Diagram diagramToDuplicate : diagramsToDuplicate) {
                if (duplicatedObjects.contains(diagramToDuplicate)) continue;
                if (command == null) {
                    command = new CompositeCommand("", Arrays.asList(new DuplicateDiagramCommand(request.getEditingDomain(), "Duplicate Diagram", diagramToDuplicate, request.getAllDuplicatedElementsMap())));
                } else {
                    command.add((IUndoableOperation)new DuplicateDiagramCommand(request.getEditingDomain(), "Duplicate Diagram", diagramToDuplicate, request.getAllDuplicatedElementsMap()));
                }
                duplicatedObjects.add(diagramToDuplicate);
            }
            if (command != null) {
                if (super.getBeforeDuplicateCommand(request) != null) {
                    command.add((IUndoableOperation)super.getBeforeDuplicateCommand(request));
                    return command.reduce();
                }
                return command.reduce();
            }
        }
        return super.getBeforeDuplicateCommand(request);
    }

    protected EObject getDuplicatedEObject(DuplicateElementsRequest request) {
        List elementsToBeDuplicated = request.getElementsToBeDuplicated();
        if (elementsToBeDuplicated == null || elementsToBeDuplicated.isEmpty()) {
            return null;
        }
        Object elementToBeDuplicated = elementsToBeDuplicated.get(0);
        if (elementToBeDuplicated instanceof EObject) {
            return (EObject)elementToBeDuplicated;
        }
        return null;
    }
}

