/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.internal.utils;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.infra.services.edit.context.TypeContext;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsPackage;
import org.eclipse.papyrus.infra.types.ExternallyRegisteredType;
import org.eclipse.papyrus.infra.types.MetamodelTypeConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.infra.types.core.registries.ElementTypeSetConfigurationRegistry;
import org.eclipse.papyrus.infra.types.util.ElementTypesConfigurationsSwitch;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.AbstractIndex;

public class ElementTypeConfigurationsIndex
extends AbstractIndex {
    private static final ElementTypeConfigurationsIndex INSTANCE = new ElementTypeConfigurationsIndex();
    private final IContentType elementTypesConfigurationsContentType = Platform.getContentTypeManager().getContentType("org.eclipse.papyrus.infra.types");
    private final ElementTypesRegistry registry = new ElementTypesRegistry();
    private final Switch<EClass> baseClassSwitch = new BaseClassSwitch();
    private final AbstractIndex.Computation<Map<ElementTypeConfiguration, EClass>> elementTypeBaseClasses = new AbstractIndex.Computation<Map>(this, this::computeElementTypeBaseClasses);
    private final AbstractIndex.Computation<Multimap<String, EClass>> creatableRoles = new AbstractIndex.Computation<Multimap>(this, this::computeCreatableRoles);

    private ElementTypeConfigurationsIndex() {
    }

    public static ElementTypeConfigurationsIndex getInstance() {
        return INSTANCE;
    }

    private Map<ElementTypeConfiguration, EClass> computeElementTypeBaseClasses() {
        ImmutableMap.Builder result = ImmutableMap.builder();
        HashSet<ElementTypeSetConfiguration> visitedSets = new HashSet<ElementTypeSetConfiguration>();
        for (Map<String, ElementTypeSetConfiguration> types : this.registry.getElementTypeSetConfigurations().values()) {
            for (ElementTypeSetConfiguration set : types.values()) {
                if (!visitedSets.add(set)) continue;
                set.getElementTypeConfigurations().forEach(type -> {
                    EClass baseClass = this.baseClass((ElementTypeConfiguration)type);
                    if (baseClass != null) {
                        result.put(type, (Object)baseClass);
                    }
                });
            }
        }
        return result.build();
    }

    EClass baseClass(ElementTypeConfiguration type) {
        return (EClass)this.baseClassSwitch.doSwitch((EObject)type);
    }

    private Multimap<String, EClass> computeCreatableRoles() {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        HashSet visitedClasses = new HashSet();
        for (Map<String, ElementTypeSetConfiguration> types : this.registry.getElementTypeSetConfigurations().values()) {
            for (ElementTypeSetConfiguration set : types.values()) {
                set.getElementTypeConfigurations().forEach(type -> {
                    EClass baseClass = this.baseClass((ElementTypeConfiguration)type);
                    if (baseClass != null && visitedClasses.add(baseClass)) {
                        this.getContainmentRoles(baseClass).forEach(ref -> {
                            ImmutableSetMultimap.Builder builder2 = result.put((Object)ref.getName(), (Object)ref.getEReferenceType());
                        });
                    }
                });
            }
        }
        return result.build();
    }

    private Stream<EReference> getContainmentRoles(EClass eClass) {
        return eClass.getEAllReferences().stream().filter(this::isContainment);
    }

    private boolean isContainment(EReference reference) {
        EAnnotation subsetAnnotation;
        boolean result = reference.isContainment();
        if (!result && (subsetAnnotation = reference.getEAnnotation("subsets")) != null) {
            result = subsetAnnotation.getReferences().stream().filter(EReference.class::isInstance).map(EReference.class::cast).anyMatch(this::isContainment);
        }
        return result;
    }

    public CompletableFuture<EClass> getBaseClassAsync(ElementTypeConfiguration type) {
        return this.asyncTransform(this.elementTypeBaseClasses, map -> (EClass)map.get(type));
    }

    public EClass getBaseClass(ElementTypeConfiguration type) {
        return this.transform(this.elementTypeBaseClasses, map -> (EClass)map.get(type));
    }

    public CompletableFuture<Boolean> isCreatableInRoleAsync(ElementTypeConfiguration type, String role) {
        return this.asyncCombine(this.elementTypeBaseClasses, this.creatableRoles, this.isCreatableInRoleFunction(type, role));
    }

    private BiFunction<Map<ElementTypeConfiguration, EClass>, Multimap<String, EClass>, Boolean> isCreatableInRoleFunction(ElementTypeConfiguration type, String role) {
        return (baseClasses, roles) -> {
            ElementTypeConfiguration localType = this.registry.getLocalInstance(type);
            EClass baseClass = (EClass)baseClasses.get(localType);
            if (baseClass != null && roles.get((Object)role).stream().anyMatch(eClass2 -> eClass2.isSuperTypeOf(baseClass))) {
                return true;
            }
            return false;
        };
    }

    public boolean isCreatableInRole(ElementTypeConfiguration type, String role) {
        return this.combine(this.elementTypeBaseClasses, Map.of(), this.creatableRoles, ImmutableMultimap.of(), this.isCreatableInRoleFunction(type, role));
    }

    private class BaseClassSwitch
    extends ElementTypesConfigurationsSwitch<EClass> {
        private BaseClassSwitch() {
        }

        public EClass caseMetamodelTypeConfiguration(MetamodelTypeConfiguration object) {
            return object.getEClass();
        }

        public EClass caseSpecializationTypeConfiguration(SpecializationTypeConfiguration object) {
            EClass result = null;
            for (ElementTypeConfiguration general : object.getSpecializedTypes()) {
                result = (EClass)this.doSwitch((EObject)general);
                if (result != null) break;
            }
            return result;
        }

        public EClass caseExternallyRegisteredType(ExternallyRegisteredType object) {
            IElementType type = ElementTypeRegistry.getInstance().getType(object.getIdentifier());
            return type == null ? null : type.getEClass();
        }
    }

    private final class ElementTypesRegistry
    extends ElementTypeSetConfigurationRegistry {
        private final IResourceChangeListener workspaceListener = this::workspaceChanged;
        private final AbstractIndex.Computation<Map<String, Map<String, ElementTypeSetConfiguration>>> elementTypeSetConfigurationsComputation;

        ElementTypesRegistry() {
            this.elementTypeSetConfigurationsComputation = new AbstractIndex.Computation<Map>(ElementTypeConfigurationsIndex.this, () -> {
                this.init();
                return this.elementTypeSetConfigurations;
            });
        }

        protected void init() {
            super.init();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            try {
                workspace.getRoot().accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        switch (proxy.getType()) {
                            case 1: {
                                if (ElementTypesRegistry.this.isElementTypesFile(proxy)) {
                                    URI uri = URI.createPlatformResourceURI((String)proxy.requestFullPath().toPortableString(), (boolean)true);
                                    ElementTypesRegistry.this.process(uri);
                                }
                                return false;
                            }
                        }
                        return true;
                    }
                }, 0);
            }
            catch (CoreException e) {
                Activator.log.error("Failed to scan workspace for Element Types Configurations model resources.", (Throwable)e);
            }
            workspace.addResourceChangeListener(this.workspaceListener, 1);
        }

        public synchronized void dispose() {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.workspaceListener);
            EMFHelper.unload((ResourceSet)this.elementTypeSetConfigurationResourceSet);
            this.elementTypeSetConfigurations = null;
            ElementTypeConfigurationsIndex.this.resetComputations();
        }

        protected ResourceSet createResourceSet() {
            ResourceSetImpl result = new ResourceSetImpl();
            result.setPackageRegistry(ResourceUtils.createWorkspaceAwarePackageRegistry());
            result.setURIConverter(ResourceUtils.createWorkspaceAwareURIConverter());
            return result;
        }

        public Map<String, Map<String, ElementTypeSetConfiguration>> getElementTypeSetConfigurations() {
            return ElementTypeConfigurationsIndex.this.get(this.elementTypeSetConfigurationsComputation);
        }

        public boolean loadElementTypeSetConfigurations(String contextID, Collection<ElementTypeSetConfiguration> elementTypeSetConfigurationsToRegister) {
            if (contextID == null) {
                return false;
            }
            Map map = this.elementTypeSetConfigurations.computeIfAbsent(contextID, __ -> new HashMap());
            elementTypeSetConfigurationsToRegister.forEach(set -> {
                ElementTypeSetConfiguration elementTypeSetConfiguration = map.put(set.getIdentifier(), set);
            });
            return true;
        }

        private boolean isElementTypesFile(IResourceProxy proxy) throws CoreException {
            boolean result = false;
            if (ElementTypeConfigurationsIndex.this.elementTypesConfigurationsContentType.isAssociatedWith(proxy.getName())) {
                result = this.isElementTypesFile(proxy.requestResource());
            }
            return result;
        }

        private boolean isElementTypesFile(IResource resource) throws CoreException {
            boolean result = false;
            if (resource.getType() == 1 && resource.isAccessible()) {
                IContentDescription desc = ((IFile)resource).getContentDescription();
                result = desc != null && desc.getContentType() != null && desc.getContentType().isKindOf(ElementTypeConfigurationsIndex.this.elementTypesConfigurationsContentType);
            }
            return result;
        }

        private void process(URI resourceURI) {
            Resource resource = this.elementTypeSetConfigurationResourceSet.getResource(resourceURI, false);
            if (resource == null) {
                try {
                    resource = this.elementTypeSetConfigurationResourceSet.getResource(resourceURI, true);
                    Collection sets = EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_SET_CONFIGURATION);
                    if (!sets.isEmpty()) {
                        String clientContextID = TypeContext.getDefaultContextId();
                        this.loadElementTypeSetConfigurations(clientContextID, sets);
                    }
                }
                catch (Exception e) {
                    Activator.log.error("Failed to load Element Types Configurations model resource.", (Throwable)e);
                }
            }
        }

        private void workspaceChanged(IResourceChangeEvent event) {
            final boolean[] needRebuild = new boolean[1];
            try {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        switch (delta.getKind()) {
                            case 4: {
                                if ((delta.getFlags() & 0x100) == 0) break;
                            }
                            case 1: 
                            case 2: {
                                if (delta.getResource().isDerived() || !ElementTypesRegistry.this.isElementTypesFile(delta.getResource())) break;
                                needRebuild[0] = true;
                            }
                        }
                        return !needRebuild[0];
                    }
                });
            }
            catch (CoreException e) {
                Activator.log.error("Failed to process workspace changes.", (Throwable)e);
            }
            if (needRebuild[0]) {
                this.dispose();
            }
        }

        <E extends EObject> E getLocalInstance(E object) {
            if (object == null) {
                return null;
            }
            URI uri = EcoreUtil.getURI(object);
            EObject result = this.elementTypeSetConfigurationResourceSet.getEObject(uri, false);
            if (result != null && result.eClass() == object.eClass()) {
                return (E)result;
            }
            return null;
        }
    }
}

