/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.util;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.cbi.p2repo.aggregator.Contribution;
import org.eclipse.cbi.p2repo.aggregator.IdentificationProvider;
import org.eclipse.cbi.p2repo.aggregator.MappedRepository;
import org.eclipse.cbi.p2repo.aggregator.MappedUnit;
import org.eclipse.cbi.p2repo.aggregator.ValidationSet;
import org.eclipse.cbi.p2repo.aggregator.util.ResourceDiagnosticImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.equinox.internal.p2.director.Explanation;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class VerificationDiagnostic
extends ResourceDiagnosticImpl {
    public static final String ATTR_ROOT_PROBLEM = "p2.verification.root.problem";
    public static final String ATTR_RELATED_DIAGNOSTICS = "p2.verification.related.diagnostics";
    public static final String ATTR_VERIFICATION_TYPE = "p2.verification.error.type";
    public static final String PROP_AGGREGATOR_MODEL_ELEMENT_URI = "org.eclipse.cbi.p2repo.aggregator.model.element.URI";
    protected URI locationURI;

    public static EObject getCorrespondingModelObject(Resource resource, DependencyLink link) {
        String relativeEObjectURI = link.getInstallableUnit().getProperty(PROP_AGGREGATOR_MODEL_ELEMENT_URI);
        URI absoluteEObjectURI = URI.createURI((String)relativeEObjectURI).resolve(resource.getURI());
        return resource.getResourceSet().getEObject(absoluteEObjectURI, true);
    }

    public static String getIdentifierSegment(String type, String value) {
        return type + "(" + value + ")";
    }

    public static void identifyDependencyChain(DependencyLink dependencyChain, Resource resource, String separator, String indent) {
        int level;
        StringBuilder identifierBuilder;
        URI modelElementURI;
        LinkedList<Object> identifierSegmentList;
        block14: {
            identifierSegmentList = new LinkedList<Object>();
            modelElementURI = null;
            identifierBuilder = new StringBuilder();
            DependencyLink currentLink = dependencyChain;
            DependencyLink parentLink = currentLink.getParent();
            if (parentLink != null) {
                DependencyLink previousLink;
                do {
                    previousLink = currentLink;
                    currentLink = parentLink;
                    if ((parentLink = currentLink.getParent()) != null) continue;
                    modelObject = VerificationDiagnostic.getCorrespondingModelObject(resource, currentLink);
                    if (modelObject instanceof MappedRepository) {
                        IInstallableUnit previousIU = previousLink.getInstallableUnit();
                        for (MappedUnit mu : ((MappedRepository)modelObject).getUnits(true)) {
                            if (!mu.getRequirement().isMatch(previousIU)) continue;
                            currentLink = previousLink;
                            modelObject = (EObject)mu;
                            break block13;
                        }
                    }
                    if ((level = VerificationDiagnostic.prependIdentifierSegment(identifierSegmentList, previousLink, null)) < 0) break block13;
                    modelElementURI = previousLink.getModelElementURI();
                    identifierBuilder.append(previousLink.getIdentifier());
                    break block14;
                } while ((level = VerificationDiagnostic.prependIdentifierSegment(identifierSegmentList, previousLink, null)) < 0);
                modelElementURI = previousLink.getModelElementURI();
                identifierBuilder.append(previousLink.getIdentifier());
            } else {
                block13: {
                    modelObject = VerificationDiagnostic.getCorrespondingModelObject(resource, currentLink);
                }
                level = VerificationDiagnostic.prependIdentifierSegment(identifierSegmentList, currentLink, modelObject);
                if (level >= 0) {
                    modelElementURI = currentLink.getModelElementURI();
                    identifierBuilder.append(currentLink.getIdentifier());
                } else {
                    while (!(modelObject instanceof ValidationSet)) {
                        if (modelObject instanceof Contribution) {
                            modelElementURI = EcoreUtil.getURI((EObject)modelObject);
                        }
                        if ((modelObject = modelObject.eContainer()) == null) {
                            modelElementURI = null;
                            break;
                        }
                        VerificationDiagnostic.prependIdentifierSegment(identifierSegmentList, null, modelObject);
                    }
                }
            }
        }
        Iterator segmentIterator = identifierSegmentList.iterator();
        while (segmentIterator.hasNext()) {
            ++level;
            identifierBuilder.append(separator);
            int i = 0;
            while (i <= level) {
                identifierBuilder.append(indent);
                ++i;
            }
            identifierBuilder.append(segmentIterator.next().toString());
        }
        String identifier = identifierBuilder.toString();
        int length = 0;
        while (!identifierSegmentList.isEmpty()) {
            Object segment = identifierSegmentList.removeLast();
            if (!(segment instanceof DependencyLink)) break;
            DependencyLink link = (DependencyLink)segment;
            if (link.level >= 0) break;
            identifier = identifier.substring(0, identifier.length() - length);
            length = link.identifier.length() + separator.length() + indent.length() * (level + 1);
            link.identifier = identifier;
            link.level = level--;
            link.modelElementURI = modelElementURI;
        }
    }

    protected static int prependIdentifierSegment(LinkedList<Object> identifierSegmentList, DependencyLink link, EObject eObject) {
        if (link != null) {
            String identifier = link.getIdentifier();
            if (identifier != null) {
                return link.level;
            }
            link.identifier = eObject == null ? VerificationDiagnostic.getIdentifierSegment("InstallableUnit", link.getInstallableUnit().toString()) : VerificationDiagnostic.getIdentifierSegment(eObject.eClass().getName(), eObject instanceof IdentificationProvider ? ((IdentificationProvider)eObject).getIdentification() : eObject.toString());
            identifierSegmentList.addFirst(link);
            return -1;
        }
        identifierSegmentList.addFirst(VerificationDiagnostic.getIdentifierSegment(eObject.eClass().getName(), eObject instanceof IdentificationProvider ? ((IdentificationProvider)eObject).getIdentification() : eObject.toString()));
        return -1;
    }

    public VerificationDiagnostic(String message, URI locationURI) {
        super(message, locationURI.toString());
        this.locationURI = locationURI;
    }

    public URI getLocationURI() {
        return this.locationURI;
    }

    public void resolveLocation(URI base) {
        URI newLocationURI = this.locationURI.resolve(base);
        if (newLocationURI != this.locationURI) {
            this.location = newLocationURI.toString();
            this.locationURI = newLocationURI;
        }
    }

    public static class DependencyLink {
        IInstallableUnit installableUnit;
        DependencyLink parent;
        URI modelElementURI;
        String identifier;
        int level = -1;

        public DependencyLink(IInstallableUnit value, DependencyLink parent) {
            this.installableUnit = value;
            this.parent = parent;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public IInstallableUnit getInstallableUnit() {
            return this.installableUnit;
        }

        public int getLevel() {
            return this.level;
        }

        public URI getModelElementURI() {
            return this.modelElementURI;
        }

        public DependencyLink getParent() {
            return this.parent;
        }

        public String toString() {
            return this.identifier == null && this.installableUnit != null ? this.installableUnit.toString() : this.identifier;
        }
    }

    public static class Singleton
    extends VerificationDiagnostic {
        private final Explanation rootProblem;
        private final Singleton[] relatedDiagnostics;

        public Singleton(Explanation rootProblem, URI locationURI, Singleton[] relatedDiagnostics) {
            super(rootProblem.toString(), locationURI);
            this.relatedDiagnostics = relatedDiagnostics;
            this.rootProblem = rootProblem;
        }

        public Singleton[] getRelatedDiagnostics() {
            return this.relatedDiagnostics;
        }

        public Explanation getRootProblem() {
            return this.rootProblem;
        }
    }
}

