/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 * 	  Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt.application;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;
import xpt.Externalizer;

@Singleton
@SuppressWarnings("all")
public class WizardNewFileCreationPage {
  @Inject
  @Extension
  private Common _common;

  @Inject
  private Externalizer xptExternalizer;

  public CharSequence className(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("WizardNewFileCreationPage");
    return _builder;
  }

  public CharSequence packageName(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    String _packageName = it.getPackageName();
    _builder.append(_packageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence WizardNewFileCreationPage(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" extends org.eclipse.jface.wizard.WizardPage {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private final org.eclipse.jface.viewers.IStructuredSelection currentSelection;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private String initialFileName;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private org.eclipse.core.runtime.IPath initialContainerFullPath;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private org.eclipse.swt.widgets.Text fileNameEditor;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    CharSequence _className_1 = this.className(it);
    _builder.append(_className_1, "\t");
    _builder.append("(String name, org.eclipse.jface.viewers.IStructuredSelection currentSelection) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("super(name);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.currentSelection = currentSelection;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("String home = System.getProperty(\"user.home\"); //$NON-NLS-1$");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (home != null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("initialContainerFullPath = new org.eclipse.core.runtime.Path(home);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected org.eclipse.jface.viewers.IStructuredSelection getSelection() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return currentSelection;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_6, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public String getFileName() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (fileNameEditor == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return initialFileName;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.core.runtime.IPath path = getFilePath();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (path == null || path.isEmpty() || path.hasTrailingSeparator()) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return path.lastSegment();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_7, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void setFileName(String fileName) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (fileNameEditor == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("initialFileName = fileName;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("setFilePath(getContainerFullPath(), fileName);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_8 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_8, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public org.eclipse.core.runtime.IPath getContainerFullPath() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (fileNameEditor == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return initialContainerFullPath;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.core.runtime.IPath path = getFilePath();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (path == null || path.isEmpty()) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (path.hasTrailingSeparator()) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return path;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("path = path.removeLastSegments(1);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (path.isEmpty()) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return path.addTrailingSeparator();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_9 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_9, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void setContainerFullPath(org.eclipse.core.runtime.IPath containerPath) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (fileNameEditor == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("initialContainerFullPath = containerPath;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("setFilePath(containerPath, getFileName());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_10 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_10, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected org.eclipse.core.runtime.IPath getFilePath() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("String fileName = fileNameEditor.getText().trim();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (fileName.length() == 0) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return new org.eclipse.core.runtime.Path(fileNameEditor.getText());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_11 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_11, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected void setFilePath(org.eclipse.core.runtime.IPath containerPath, String fileName) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (fileName == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("fileName = \"\"; //$NON-NLS-1$");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("fileName = fileName.trim();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (containerPath == null) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("fileNameEditor.setText(fileName);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (!containerPath.hasTrailingSeparator()) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("containerPath = containerPath.addTrailingSeparator();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.core.runtime.IPath path = fileName.length() == 0 ? containerPath : containerPath.append(fileName);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("fileNameEditor.setText(path.toOSString());");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("setPageComplete(validatePage());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_12 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_12, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void createControl(org.eclipse.swt.widgets.Composite parent) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.swt.widgets.Composite plate = new org.eclipse.swt.widgets.Composite(parent, org.eclipse.swt.SWT.NONE);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("plate.setLayout(new org.eclipse.swt.layout.GridLayout(2, false));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.swt.widgets.Label label = new org.eclipse.swt.widgets.Label(plate, org.eclipse.swt.SWT.NONE);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("label.setText(");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForNewFileWizardFileLabel(it));
    _builder.append(_accessorCall, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("label.setLayoutData(new org.eclipse.swt.layout.GridData(org.eclipse.swt.SWT.BEGINNING, org.eclipse.swt.SWT.CENTER, false, false, 2, 1));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("fileNameEditor = new org.eclipse.swt.widgets.Text(plate, org.eclipse.swt.SWT.SINGLE | org.eclipse.swt.SWT.BORDER);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("fileNameEditor.setLayoutData(new org.eclipse.swt.layout.GridData(org.eclipse.swt.SWT.FILL, org.eclipse.swt.SWT.CENTER, true, false));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.swt.widgets.Button button = new org.eclipse.swt.widgets.Button(plate, org.eclipse.swt.SWT.PUSH);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("button.setText(");
    CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForNewFileWizardBrowseButton(it));
    _builder.append(_accessorCall_1, "\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("button.setLayoutData(new org.eclipse.swt.layout.GridData(org.eclipse.swt.SWT.BEGINNING, org.eclipse.swt.SWT.CENTER, false, false));");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// logic");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("fileNameEditor.addModifyListener(new org.eclipse.swt.events.ModifyListener() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("public void modifyText(org.eclipse.swt.events.ModifyEvent e) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("setPageComplete(validatePage());");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("});");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("button.addSelectionListener(new org.eclipse.swt.events.SelectionListener() {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("org.eclipse.swt.widgets.FileDialog dialog = new org.eclipse.swt.widgets.FileDialog(getShell(), org.eclipse.swt.SWT.SAVE);");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("dialog.setText(");
    CharSequence _accessorCall_2 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForNewFileWizardSelectDialog(it));
    _builder.append(_accessorCall_2, "\t\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t");
    _builder.append("dialog.setFileName(getFileName());");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("String fileName = dialog.open();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (fileName != null) {");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("fileNameEditor.setText(fileName);");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("setPageComplete(validatePage());");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("public void widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("});");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// init");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("setFilePath(initialContainerFullPath, initialFileName);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("setControl(plate);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_13 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_13, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("protected boolean validatePage() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("String fileName = fileNameEditor.getText().trim();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (fileName.length() == 0) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("setErrorMessage(");
    CharSequence _accessorCall_3 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForNewFileWizardEmpty(it));
    _builder.append(_accessorCall_3, "\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (!new org.eclipse.core.runtime.Path(\"\").isValidPath(fileName)) { //$NON-NLS-1$");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("setErrorMessage(");
    CharSequence _accessorCall_4 = this.xptExternalizer.accessorCall(it.getEditorGen(), this.i18nKeyForNewFileWizardInvalid(it));
    _builder.append(_accessorCall_4, "\t\t\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("setErrorMessage(null);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence additions(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  @Localization
  public CharSequence i18nValues(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _messageEntry = this.xptExternalizer.messageEntry(this.i18nKeyForNewFileWizardFileLabel(it), "File:");
    _builder.append(_messageEntry);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_1 = this.xptExternalizer.messageEntry(this.i18nKeyForNewFileWizardBrowseButton(it), "Browse");
    _builder.append(_messageEntry_1);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_2 = this.xptExternalizer.messageEntry(this.i18nKeyForNewFileWizardSelectDialog(it), "Select new file");
    _builder.append(_messageEntry_2);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_3 = this.xptExternalizer.messageEntry(this.i18nKeyForNewFileWizardEmpty(it), "Specify file name");
    _builder.append(_messageEntry_3);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_4 = this.xptExternalizer.messageEntry(this.i18nKeyForNewFileWizardInvalid(it), "Invalid file name");
    _builder.append(_messageEntry_4);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Localization
  public CharSequence i18nAccessors(final GenApplication it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _accessorField = this.xptExternalizer.accessorField(this.i18nKeyForNewFileWizardFileLabel(it));
    _builder.append(_accessorField);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_1 = this.xptExternalizer.accessorField(this.i18nKeyForNewFileWizardBrowseButton(it));
    _builder.append(_accessorField_1);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_2 = this.xptExternalizer.accessorField(this.i18nKeyForNewFileWizardSelectDialog(it));
    _builder.append(_accessorField_2);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_3 = this.xptExternalizer.accessorField(this.i18nKeyForNewFileWizardEmpty(it));
    _builder.append(_accessorField_3);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_4 = this.xptExternalizer.accessorField(this.i18nKeyForNewFileWizardInvalid(it));
    _builder.append(_accessorField_4);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Localization
  public String i18nKeyForNewFileWizardFileLabel(final GenApplication app) {
    CharSequence _className = this.className(app);
    return (_className + ".FileLabel");
  }

  @Localization
  public String i18nKeyForNewFileWizardBrowseButton(final GenApplication app) {
    CharSequence _className = this.className(app);
    return (_className + ".BrowseButton");
  }

  @Localization
  public String i18nKeyForNewFileWizardSelectDialog(final GenApplication app) {
    CharSequence _className = this.className(app);
    return (_className + ".SelectNewFileDialog");
  }

  @Localization
  public String i18nKeyForNewFileWizardEmpty(final GenApplication app) {
    CharSequence _className = this.className(app);
    return (_className + ".EmptyFileNameError");
  }

  @Localization
  public String i18nKeyForNewFileWizardInvalid(final GenApplication app) {
    CharSequence _className = this.className(app);
    return (_className + ".InvalidFileNameError");
  }
}
