/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.configuration;

import java.lang.constant.Constable;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;
import org.eclipse.papyrus.infra.ui.util.EclipseCommandUtils;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

@Deprecated
public class PapyrusPopupMenuAction
extends PopupMenuAction {
    private final String category;

    public PapyrusPopupMenuAction(String categoryId) {
        super(null);
        this.category = categoryId;
    }

    public void run(NatTable natTable, MouseEvent event) {
        Menu menu = new Menu((Control)natTable.getShell());
        this.buildMenu(menu, natTable);
        menu.setVisible(true);
    }

    private void buildMenu(Menu popupMenu, NatTable natTable) {
        Collection commands = EclipseCommandUtils.getAllExistingCommandsInCategory((String)this.category);
        for (final Command command : commands) {
            IHandler handler = command.getHandler();
            if (handler == null || !(handler instanceof AbstractHandler)) continue;
            ((AbstractHandler)handler).setEnabled(null);
            boolean isEnabled = handler.isEnabled();
            if (!isEnabled) continue;
            if (this.category.equals("org.eclipse.papyrus.infra.nattable.rows.command.category") && "org.eclipse.papyrus.infra.nattable.row.show.hide.category.command".equals(command.getId())) {
                this.addShowHideCategoryCommandToMenu(popupMenu, command, natTable);
                continue;
            }
            MenuItem item = new MenuItem(popupMenu, 8);
            item.setEnabled(true);
            ImageDescriptor imageDescriptor = EclipseCommandUtils.getCommandIcon((Command)command);
            if (imageDescriptor != null) {
                item.setImage(imageDescriptor.createImage());
            }
            try {
                item.setText(command.getName());
            }
            catch (NotDefinedException e) {
                Activator.log.error((Throwable)e);
            }
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    PapyrusPopupMenuAction.this.executeCommand(command.getId());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    private void executeCommand(String commandId) {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        if (handlerService == null) {
            Activator.log.warn("Handler service not found");
            return;
        }
        try {
            handlerService.executeCommand(commandId, new Event());
        }
        catch (ExecutionException e) {
            Activator.log.error((Throwable)e);
        }
        catch (NotDefinedException e) {
            Activator.log.error((Throwable)e);
        }
        catch (NotEnabledException e) {
            Activator.log.error((Throwable)e);
        }
        catch (NotHandledException e) {
            Activator.log.error((Throwable)e);
        }
    }

    private void addShowHideCategoryCommandToMenu(Menu menu, final Command command, NatTable natTable) {
        Table table = this.getTable(natTable);
        int maxDepth = FillingConfigurationUtils.getMaxDepthForTree(table);
        int min = 0;
        if (!FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(table, 0)) {
            ++min;
        }
        final IHandler handler = command.getHandler();
        int depth = min;
        while (depth <= maxDepth) {
            MenuItem item = new MenuItem(menu, 32);
            final boolean isHidden = this.isHidden(table, depth);
            item.setSelection(!isHidden);
            String text = null;
            text = NLS.bind((String)Messages.PapyrusPopupMenuAction_ShowCategoriesOnDepth, (Object)depth);
            item.setText(text);
            final Integer index = depth;
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    HashMap<String, Constable> parameters = new HashMap<String, Constable>();
                    parameters.put("depth", index);
                    parameters.put("hideCategory", Boolean.valueOf(!isHidden));
                    try {
                        handler.execute(new ExecutionEvent(command, parameters, null, null));
                    }
                    catch (ExecutionException e) {
                        Activator.log.error((Throwable)e);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
            ++depth;
        }
    }

    private boolean isHidden(Table table, int depth) {
        return StyleUtils.getHiddenDepths(table).contains(depth);
    }

    private Table getTable(NatTable natTable) {
        IConfigRegistry configRegistry = natTable.getConfigRegistry();
        INattableModelManager modelManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"nattable_model_manager_id"});
        return modelManager.getTable();
    }
}

