/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.papyrus.infra.nattable.accumulator.CustomRowOverrideLabelAccumulator;
import org.eclipse.papyrus.infra.nattable.celleditor.config.CellAxisConfigurationRegistry;
import org.eclipse.papyrus.infra.nattable.celleditor.config.CellEditorConfigurationFactory;
import org.eclipse.papyrus.infra.nattable.celleditor.config.IAxisCellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.CellEditorDeclaration;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFLabelProvider;

public class CellEditorAxisConfiguration
extends AbstractRegistryConfiguration {
    private Collection<String> messagesAlreadyDisplayed = new ArrayList<String>();
    private static final String CELL_ID = "_cellId";

    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.unregisterConfigAttribute(EditConfigAttributes.CELL_EDITOR, DisplayMode.NORMAL, null);
        INattableModelManager modelManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"nattable_model_manager_id"});
        BodyLayerStack bodyLayerStack = modelManager.getBodyLayerStack();
        CellEditorDeclaration editorDeclaration = TableHelper.getCellEditorDeclaration(modelManager);
        if (editorDeclaration.equals((Object)CellEditorDeclaration.COLUMN)) {
            ColumnOverrideLabelAccumulator accumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyLayerStack.getBodyDataLayer());
            this.declaredCellEditors(modelManager.getColumnElementsList(), configRegistry, accumulator, null);
            bodyLayerStack.getBodyDataLayer().setConfigLabelAccumulator((IConfigLabelAccumulator)accumulator);
        } else if (editorDeclaration.equals((Object)CellEditorDeclaration.ROW)) {
            CustomRowOverrideLabelAccumulator accumulator = new CustomRowOverrideLabelAccumulator((ILayer)bodyLayerStack.getBodyDataLayer());
            this.declaredCellEditors(modelManager.getRowElementsList(), configRegistry, null, accumulator);
            bodyLayerStack.getBodyDataLayer().setConfigLabelAccumulator((IConfigLabelAccumulator)accumulator);
        } else if (editorDeclaration.equals((Object)CellEditorDeclaration.CELL)) {
            throw new UnsupportedOperationException(Messages.EditConfiguration_DeclarationNotYetSupported);
        }
    }

    private void declaredCellEditors(List<Object> elements, IConfigRegistry configRegistry, ColumnOverrideLabelAccumulator columnAccumulator, CustomRowOverrideLabelAccumulator rowAccumulator) {
        boolean declareOnColumn = columnAccumulator != null;
        boolean declareOnRow = rowAccumulator != null;
        Assert.isTrue((boolean)(declareOnColumn ^ declareOnRow));
        int i = 0;
        while (i < elements.size()) {
            Object current = elements.get(i);
            boolean configWithNewRegistry = this.configureWithNewRegistry(configRegistry, current, i, columnAccumulator, rowAccumulator);
            if (!configWithNewRegistry) {
                this.configureWithOldFactory(configRegistry, current, i, columnAccumulator, rowAccumulator);
            }
            ++i;
        }
    }

    private boolean configureWithOldFactory(IConfigRegistry configRegistry, Object current, int indexOfTheAxis, ColumnOverrideLabelAccumulator columnAccumulator, CustomRowOverrideLabelAccumulator rowAccumulator) {
        ICellEditor editor;
        INattableModelManager modelManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"nattable_model_manager_id"});
        Table table = modelManager.getTable();
        IAxisCellEditorConfiguration config = CellEditorConfigurationFactory.INSTANCE.getFirstCellEditorConfiguration(table, current);
        if (config != null && (editor = config.getICellEditor(table, current, modelManager.getTableAxisElementProvider())) != null) {
            String editorId = config.getEditorConfigId() + Integer.toString(indexOfTheAxis);
            StringBuilder builder = new StringBuilder(editorId);
            builder.append(CELL_ID);
            String cellId = builder.toString();
            ICellPainter painter = config.getCellPainter(table, current);
            DisplayMode displayMode = config.getDisplayMode(table, current);
            IDisplayConverter converter = config.getDisplayConvert(table, current, (ILabelProvider)new EMFLabelProvider());
            IDataValidator validator = config.getDataValidator(table, current);
            if (columnAccumulator != null) {
                columnAccumulator.registerColumnOverrides(indexOfTheAxis, new String[]{editorId, cellId, "BODY"});
            } else {
                rowAccumulator.registerRowOverrides(indexOfTheAxis, editorId, cellId, "BODY");
            }
            if (painter != null) {
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)painter, displayMode, cellId);
            }
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)editor, displayMode, editorId);
            if (converter != null) {
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)converter, displayMode, cellId);
            }
            if (validator != null) {
                configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)validator, displayMode, cellId);
            }
            return true;
        }
        return false;
    }

    protected final boolean configureWithNewRegistry(IConfigRegistry configRegistry, Object current, int indexOfTheAxis, ColumnOverrideLabelAccumulator columnAccumulator, CustomRowOverrideLabelAccumulator rowAccumulator) {
        INattableModelManager modelManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"nattable_model_manager_id"});
        ICellAxisConfiguration ceConfig = CellAxisConfigurationRegistry.INSTANCE.getFirstCellEditorConfiguration(modelManager, current);
        if (ceConfig != null) {
            String editorId = ceConfig.getConfigurationId() + Integer.toString(indexOfTheAxis);
            StringBuilder builder = new StringBuilder(editorId);
            builder.append(CELL_ID);
            String cellId = builder.toString();
            ceConfig.configureCellEditor(configRegistry, current, cellId);
            if (columnAccumulator != null) {
                columnAccumulator.registerColumnOverrides(indexOfTheAxis, new String[]{editorId, cellId, "BODY"});
            } else {
                rowAccumulator.registerRowOverrides(indexOfTheAxis, editorId, cellId, "BODY");
            }
            return true;
        }
        return false;
    }
}

