/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.dnd.commands;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActivityActivityContentCompartmentEditPart;

public class CreateTAndUpdateCommand<T extends EObject, E extends EObject, S extends EObject>
extends AbstractCommand {
    protected final EditPart targetEditPart;
    protected final boolean headless;
    protected final Class<T> typeParameterClass;
    protected final E targetElement;
    protected final S sourceElement;
    private final IHintedType typeToCreate;
    private final Point location;
    private String dropEditPartVisualID;
    private EStructuralFeature structuralFeatureToSet;

    public CreateTAndUpdateCommand(EditPart targetEditPart, Class<T> typeParameterClass, E targetElement, S sourceElement, boolean headless, IHintedType typeToCreate, EStructuralFeature structuralFeatureToSet, Point location, String dropEditPartVisualID) {
        super("Create and update in drop action");
        this.targetEditPart = targetEditPart;
        this.headless = headless;
        this.typeParameterClass = typeParameterClass;
        this.targetElement = targetElement;
        this.sourceElement = sourceElement;
        this.typeToCreate = typeToCreate;
        this.location = location;
        this.dropEditPartVisualID = dropEditPartVisualID;
        this.structuralFeatureToSet = structuralFeatureToSet;
    }

    protected T getNewEObject(CreateElementRequest request) {
        if (this.typeParameterClass.isAssignableFrom(request.getNewElement().getClass())) {
            return (T)request.getNewElement();
        }
        return null;
    }

    public T getNewEObject(CommandResult commandResult) {
        Object objectResult = commandResult.getReturnValue();
        if (objectResult instanceof List) {
            List listResult = (List)objectResult;
            for (Object elementResult : listResult) {
                EObject newElement;
                CreateElementRequest request;
                if (!(elementResult instanceof CreateElementRequestAdapter) || (request = (CreateElementRequest)((CreateElementRequestAdapter)elementResult).getAdapter(CreateElementRequest.class)) == null || !this.typeParameterClass.isAssignableFrom((newElement = request.getNewElement()).getClass())) continue;
                EObject newObject = newElement;
                return (T)newObject;
            }
        } else if (this.typeParameterClass.isAssignableFrom(commandResult.getReturnValue().getClass())) {
            return (T)((EObject)commandResult.getReturnValue());
        }
        return null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        TransactionalEditingDomain domain = (TransactionalEditingDomain)EMFHelper.resolveEditingDomain((Object)this.targetEditPart);
        CreateElementRequest createElementRequest = new CreateElementRequest(domain, this.targetElement, (IElementType)this.typeToCreate);
        ICommand creationElementCommand = null;
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider(this.targetElement);
        if (provider != null) {
            creationElementCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest);
        }
        if (creationElementCommand != null) {
            creationElementCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
            CommandResult commandResult = creationElementCommand.getCommandResult();
            if (commandResult != null && !commandResult.getStatus().isOK()) {
                return commandResult;
            }
            T newCreatedElement = this.getNewEObject(commandResult);
            if (newCreatedElement == null) {
                newCreatedElement = this.getNewEObject(createElementRequest);
            }
            if (newCreatedElement == null) {
                return CommandResult.newErrorCommandResult((String)"Could not create the action");
            }
            this.updateNewlyCreatedEObjectWithEObjectDragged(newCreatedElement, this.sourceElement);
            EditPart ownerEditPart = this.getOwnerEditPart();
            this.dropCreatedElement(ownerEditPart, newCreatedElement);
        }
        return CommandResult.newOKCommandResult();
    }

    protected void dropCreatedElement(EditPart contentCompartmentEditPart, T createdElement) {
        if (contentCompartmentEditPart != null) {
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(createdElement), Node.class, this.dropEditPartVisualID, ((IGraphicalEditPart)this.targetEditPart).getDiagramPreferencesHint());
            CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
            createViewRequest.setLocation(this.location);
            Command createViewCommand = contentCompartmentEditPart.getCommand((Request)createViewRequest);
            if (createViewCommand != null && createViewCommand.canExecute()) {
                createViewCommand.execute();
            }
        }
    }

    protected EditPart getOwnerEditPart() {
        ActivityActivityContentCompartmentEditPart compartmentEditPart = null;
        if (this.targetEditPart instanceof ActivityActivityContentCompartmentEditPart) {
            compartmentEditPart = (ActivityActivityContentCompartmentEditPart)this.targetEditPart;
        } else {
            Iterator children = this.targetEditPart.getChildren().iterator();
            while (children.hasNext() && compartmentEditPart == null) {
                Object child = children.next();
                if (!(child instanceof ActivityActivityContentCompartmentEditPart)) continue;
                compartmentEditPart = (ActivityActivityContentCompartmentEditPart)((Object)child);
            }
        }
        return compartmentEditPart;
    }

    protected void updateNewlyCreatedEObjectWithEObjectDragged(T elementToSet, S value) throws ExecutionException {
        this.setElementFeature((EObject)elementToSet, this.structuralFeatureToSet, value);
    }

    protected void setElementFeature(EObject elementToSet, EStructuralFeature structuralFeature, Object value) throws ExecutionException {
        if (structuralFeature != null) {
            ICommand setCommand;
            SetRequest setFeatureRequest = new SetRequest(elementToSet, structuralFeature, value);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)elementToSet);
            if (provider != null && (setCommand = provider.getEditCommand((IEditCommandRequest)setFeatureRequest)) != null && setCommand.canExecute()) {
                setCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
        }
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        throw new ExecutionException("not implemented");
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        throw new ExecutionException("not implemented");
    }
}

