/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.layer;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.widgets.nattable.data.ISpanningDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.SpanningDataLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEvent;
import org.eclipse.papyrus.infra.nattable.manager.refresh.StructuralRefreshConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;

public class PapyrusSpanningDataLayer
extends SpanningDataLayer {
    private TransactionalEditingDomain contextDomain;
    private INattableModelManager manager;

    public PapyrusSpanningDataLayer(TransactionalEditingDomain contextDomain, ISpanningDataProvider dataProvider, int defaultColumnWidth, int defaultRowHeight) {
        super(dataProvider, defaultColumnWidth, defaultRowHeight);
        this.contextDomain = contextDomain;
        this.addConfiguration(new StructuralRefreshConfiguration());
    }

    public PapyrusSpanningDataLayer(TransactionalEditingDomain contextDomain, ISpanningDataProvider dataProvider) {
        super(dataProvider);
        this.contextDomain = contextDomain;
        this.addConfiguration(new StructuralRefreshConfiguration());
    }

    public PapyrusSpanningDataLayer(TransactionalEditingDomain contextEditingDomain, INattableModelManager manager, ISpanningDataProvider spanProvider, int defaultCellWidth, int defaultCellHeight) {
        super(spanProvider, defaultCellWidth, defaultCellHeight);
        this.contextDomain = contextEditingDomain;
        this.manager = manager;
        this.addConfiguration(new StructuralRefreshConfiguration());
    }

    public void setDataValue(final int columnIndex, final int rowIndex, final Object newValue) {
        RecordingCommand recordUpdate = new RecordingCommand(this.contextDomain){

            protected void doExecute() {
                PapyrusSpanningDataLayer.super.setDataValue(columnIndex, rowIndex, newValue);
            }
        };
        this.contextDomain.getCommandStack().execute((Command)recordUpdate);
    }

    public void setColumnWidthPercentageByPosition(int columnPosition, int width, boolean fireEvent) {
        this.columnWidthConfig.setPercentage(columnPosition, width);
        if (fireEvent) {
            this.fireLayerEvent((ILayerEvent)new ColumnResizeEvent((ILayer)this, columnPosition));
        }
    }
}

