/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.editor.internal.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.sirius.editor.internal.messages.Messages;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.IPersistableElement;

public class SiriusDiagramEditorInput
extends SessionEditorInput {
    private final DSemanticDiagram diagram;
    private IStatus status;

    public SiriusDiagramEditorInput(DSemanticDiagram siriusDiagram, URI uri, Session session) {
        super(uri, siriusDiagram.getName(), session);
        this.diagram = siriusDiagram;
    }

    public DSemanticDiagram getSiriusDiagramPrototype() {
        return this.diagram;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        String name = this.diagram.getName();
        return name == null || name.isEmpty() ? Messages.SiriusDiagramEditorInput_NoName : name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    private String getDescription() {
        String description = this.diagram.getDocumentation();
        return description == null || description.isEmpty() ? Messages.SiriusDiagramEditorInput_NoDescription : description;
    }

    public String getToolTipText() {
        return NLS.bind((String)Messages.SiriusDiagramEditorInput_Tooltip, (Object)this.getName(), (Object)this.getDescription());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == URI.class) {
            return adapter.cast(this.diagram.eResource().getURI());
        }
        if (adapter == DSemanticDiagram.class) {
            return adapter.cast(this.diagram);
        }
        if (adapter == null) {
            return super.getAdapter(adapter);
        }
        return null;
    }

    public Session getSession(URI sessionModelURI, boolean restore) {
        Session sessionFromURI;
        try {
            sessionFromURI = SessionManager.INSTANCE.getExistingSession(sessionModelURI);
            if (sessionFromURI == null && restore) {
                this.status = Status.OK_STATUS;
            }
            sessionFromURI = SiriusDiagramEditorInput.openSession(sessionModelURI, restore, sessionFromURI);
        }
        catch (OperationCanceledException e) {
            sessionFromURI = null;
            this.status = new Status(8, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            sessionFromURI = null;
            this.status = new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e);
        }
        return sessionFromURI;
    }

    private static Session openSession(URI sessionModelURI, boolean restore, Session sessionFromURI) {
        Session session = sessionFromURI;
        if (session == null && restore) {
            session = SessionManager.INSTANCE.openSession(sessionModelURI, (IProgressMonitor)new NullProgressMonitor(), SiriusEditPlugin.getPlugin().getUiCallback(), true);
        }
        if (session != null && session.isOpen()) {
            IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(session);
            if (uiSession == null && restore) {
                uiSession = SessionUIManager.INSTANCE.getOrCreateUISession(session);
            }
            if (uiSession != null && !uiSession.isOpen()) {
                uiSession.open();
            }
        }
        return session;
    }
}

