/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler2;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;

public class EMFHelper {
    public static EClass getEClass(String nsUri, String className) {
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsUri);
        if (ePackage == null) {
            Activator.log.warn("Cannot find an EPackage matching the nsURI " + nsUri);
            return null;
        }
        return EMFHelper.getEClass(ePackage, className);
    }

    public static EClass getEClass(EPackage metamodel, String className) {
        EClassifier classifier = metamodel.getEClassifier(className);
        if (classifier == null) {
            Activator.log.warn("Classifier " + className + " not found in metamodel " + metamodel.getName() + " (" + metamodel.getNsURI() + ")");
        }
        if (classifier instanceof EClass) {
            return (EClass)classifier;
        }
        Activator.log.warn("Classifier " + className + " in " + metamodel.getName() + " (" + metamodel.getNsURI() + ") is not an EClass");
        return null;
    }

    public static boolean isInstance(EObject element, String className, EPackage metamodel) {
        EClassifier theClass = metamodel.getEClassifier(className);
        if (theClass == null) {
            String message = String.format("Class %s not found in  metamodel: %s (%s)", className, metamodel.getName(), metamodel.getNsURI());
            Activator.log.warn(message);
            return false;
        }
        return theClass.isInstance((Object)element);
    }

    public static boolean isInstance(EObject selectedItem, String className, String nsUri) {
        EClass actualEClass = selectedItem.eClass();
        if (EMFHelper.isExactMatch(actualEClass, className, nsUri)) {
            return true;
        }
        EList allSuperTypes = actualEClass.getEAllSuperTypes();
        for (EClass eClass : allSuperTypes) {
            if (!EMFHelper.isExactMatch(eClass, className, nsUri)) continue;
            return true;
        }
        return false;
    }

    private static boolean isExactMatch(EClass eClass, String className, String nsUri) {
        return className.equals(eClass.getName()) && nsUri.equals(eClass.getEPackage().getNsURI());
    }

    public static boolean isSubclass(EClass eClass, EClass fromClass) {
        if (eClass != null && fromClass == EcorePackage.eINSTANCE.getEObject()) {
            return true;
        }
        if (eClass == fromClass) {
            return true;
        }
        EList superTypes = eClass.getEAllSuperTypes();
        return superTypes.contains(fromClass);
    }

    public static EObject getEObject(Object source) {
        Object resolved = Activator.getDefault().getEObjectResolver().resolve(source);
        if (resolved != source && EMFHelper.isEMFModelElement(resolved)) {
            return (EObject)resolved;
        }
        if (EMFHelper.isEMFModelElement(source)) {
            return (EObject)source;
        }
        if (source instanceof IAdaptable) {
            EObject eObject = (EObject)((IAdaptable)source).getAdapter(EObject.class);
            if (eObject == null) {
                eObject = (EObject)((IAdaptable)source).getAdapter(EReference.class);
            }
            if (eObject != null) {
                return EMFHelper.asEMFModelElement(eObject);
            }
        }
        if (source != null) {
            return EMFHelper.asEMFModelElement(Platform.getAdapterManager().getAdapter(source, EObject.class));
        }
        return null;
    }

    public static boolean isEMFModelElement(Object object) {
        return object instanceof EObject && !(object instanceof Resource);
    }

    public static EObject asEMFModelElement(Object object) {
        return EMFHelper.isEMFModelElement(object) ? (EObject)object : null;
    }

    public static EditingDomain resolveEditingDomain(Object source) {
        return EMFHelper.resolveEditingDomain(EMFHelper.getEObject(source));
    }

    public static EditingDomain resolveEditingDomain(EObject source) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)source);
        if (domain == null) {
            try {
                domain = ServiceUtils.getInstance().getTransactionalEditingDomain(null);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        return domain;
    }

    public static String getQualifiedName(EClassifier eClassifier, String separator) {
        return EMFHelper.getQualifiedName(eClassifier.getEPackage(), separator) + separator + eClassifier.getName();
    }

    public static String getQualifiedName(EPackage ePackage, String separator) {
        if (ePackage.getESuperPackage() == null) {
            return ePackage.getName();
        }
        return EMFHelper.getQualifiedName(ePackage.getESuperPackage(), separator) + separator + ePackage.getName();
    }

    public static EObject loadEMFModel(ResourceSet resourceSet, URI uri) throws IOException {
        assert (resourceSet != null) : "null resourceSet";
        if (resourceSet == null) {
            Activator.log.warn("Created a new resourceSet to load an EMF model in " + Activator.log.getCallerMethod());
            resourceSet = new ResourceSetImpl();
        }
        try {
            Resource resource = resourceSet.getResource(uri, true);
            if (resource != null && !resource.getContents().isEmpty()) {
                return (EObject)resource.getContents().get(0);
            }
        }
        catch (Exception ex) {
            IOException exception = new IOException(ex.toString());
            exception.initCause(ex);
            throw exception;
        }
        return null;
    }

    public static void unload(ResourceSet resourceSet) {
        ImmutableList resources = ImmutableList.copyOf((Collection)resourceSet.getResources());
        resourceSet.getResources().clear();
        for (Resource next : resources) {
            next.unload();
            next.eAdapters().clear();
        }
        resourceSet.eAdapters().clear();
        EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
        if (packageRegistry != null) {
            packageRegistry.clear();
        }
    }

    public static EPackage getRootPackage(EPackage ePackage) {
        if (ePackage == null) {
            return null;
        }
        if (ePackage.getESuperPackage() == null) {
            return ePackage;
        }
        return EMFHelper.getRootPackage(ePackage.getESuperPackage());
    }

    public static <T extends EObject> T getContainer(EObject object, EClass type) {
        EObject result = null;
        EObject next = object;
        while (next != null && result == null) {
            if (type.isInstance((Object)next)) {
                EObject nextAsT;
                result = nextAsT = next;
            }
            next = next.eContainer();
        }
        return (T)result;
    }

    public static <T extends EObject> T getContainer(EObject object, Class<T> type) {
        EObject result = null;
        EObject next = object;
        while (next != null && result == null) {
            if (type.isInstance(next)) {
                result = (EObject)type.cast(next);
            }
            next = next.eContainer();
        }
        return (T)result;
    }

    public static List<EClass> getSubclassesOf(EClass type, boolean concreteClassesOnly) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        if (!concreteClassesOnly || !type.isAbstract() && !type.isInterface()) {
            result.add(type);
        }
        EPackage ePackage = EMFHelper.getRootPackage(type.getEPackage());
        EMFHelper.getSubclassesOf(type, ePackage, result, concreteClassesOnly);
        return new LinkedList<EClass>(result);
    }

    public static List<EClass> getSubclassesOf(EClass type, boolean concreteClassesOnly, Collection<EPackage> packagesToBrowse) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        if (!concreteClassesOnly || !type.isAbstract() && !type.isInterface()) {
            result.add(type);
        }
        for (EPackage ePackage : packagesToBrowse) {
            EMFHelper.getSubclassesOf(type, ePackage, result, concreteClassesOnly);
        }
        return new LinkedList<EClass>(result);
    }

    public static List<EClass> getSubclassesOf(EClass type, boolean concreteClassesOnly, boolean browseAllRegisteredPackages) {
        EPackage currentPackage = EMFHelper.getRootPackage(type.getEPackage());
        LinkedHashSet<EPackage> allPackages = new LinkedHashSet<EPackage>();
        allPackages.add(currentPackage);
        if (browseAllRegisteredPackages) {
            HashSet allUris = new HashSet(EPackage.Registry.INSTANCE.keySet());
            for (String nsURI : allUris) {
                allPackages.add(EPackage.Registry.INSTANCE.getEPackage(nsURI));
            }
        }
        return EMFHelper.getSubclassesOf(type, concreteClassesOnly, allPackages);
    }

    private static void getSubclassesOf(EClass type, EPackage fromPackage, Set<EClass> result, boolean concreteClassesOnly) {
        for (EClassifier classifier : fromPackage.getEClassifiers()) {
            EClass eClass;
            if (!(classifier instanceof EClass) || !(eClass = (EClass)classifier).getEAllSuperTypes().contains((Object)type) || concreteClassesOnly && (eClass.isAbstract() || eClass.isInterface())) continue;
            result.add(eClass);
        }
        for (EPackage subPackage : fromPackage.getESubpackages()) {
            EMFHelper.getSubclassesOf(type, subPackage, result, concreteClassesOnly);
        }
    }

    public static boolean isReadOnly(EObject eObject) {
        return EMFHelper.isReadOnly(ReadOnlyAxis.anyAxis(), eObject);
    }

    public static boolean isReadOnly(Set<ReadOnlyAxis> axes, EObject eObject) {
        EditingDomain domain = EMFHelper.resolveEditingDomain(eObject);
        return EMFHelper.isReadOnly(axes, eObject, domain);
    }

    public static boolean isReadOnly(EObject eObject, EditingDomain domain) {
        return EMFHelper.isReadOnly((Set<ReadOnlyAxis>)ReadOnlyAxis.anyAxis(), eObject, domain);
    }

    public static boolean isReadOnly(Set<ReadOnlyAxis> axes, EObject eObject, EditingDomain domain) {
        if (domain != null) {
            Object handler = PlatformHelper.getAdapter((Object)domain, IReadOnlyHandler.class);
            if (handler instanceof IReadOnlyHandler2) {
                return (Boolean)((IReadOnlyHandler2)handler).isReadOnly(axes, eObject).get();
            }
            if (handler instanceof IReadOnlyHandler) {
                return axes.contains(ReadOnlyAxis.PERMISSION) && (Boolean)((IReadOnlyHandler)handler).isReadOnly(eObject).get() != false;
            }
            if (eObject.eResource() != null) {
                return domain.isReadOnly(eObject.eResource());
            }
        }
        return false;
    }

    public static boolean isReadOnly(Resource resource, EditingDomain domain) {
        return EMFHelper.isReadOnly((Set<ReadOnlyAxis>)ReadOnlyAxis.anyAxis(), resource, domain);
    }

    public static boolean isReadOnly(Set<ReadOnlyAxis> axes, Resource resource, EditingDomain domain) {
        if (resource == null) {
            return false;
        }
        if (domain != null && resource.getURI() != null) {
            Object handler = PlatformHelper.getAdapter((Object)domain, IReadOnlyHandler.class);
            if (handler instanceof IReadOnlyHandler2) {
                return (Boolean)((IReadOnlyHandler2)handler).anyReadOnly(axes, new URI[]{resource.getURI()}).get();
            }
            if (handler instanceof IReadOnlyHandler) {
                return axes.contains(ReadOnlyAxis.PERMISSION) && (Boolean)((IReadOnlyHandler)handler).anyReadOnly(new URI[]{resource.getURI()}).get() != false;
            }
            return domain.isReadOnly(resource);
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            return false;
        }
        Map attributes = resourceSet.getURIConverter().getAttributes(resource.getURI(), null);
        Boolean readOnly = (Boolean)attributes.get("readOnly");
        return readOnly == null ? false : readOnly;
    }

    public static boolean canMakeWritable(EObject eObject, EditingDomain domain) {
        return EMFHelper.canMakeWritable((Set<ReadOnlyAxis>)ReadOnlyAxis.anyAxis(), eObject, domain);
    }

    public static boolean canMakeWritable(Set<ReadOnlyAxis> axes, EObject eObject, EditingDomain domain) {
        Object handler;
        if (domain != null && (handler = PlatformHelper.getAdapter((Object)domain, IReadOnlyHandler.class)) instanceof IReadOnlyHandler2) {
            return (Boolean)((IReadOnlyHandler2)handler).canMakeWritable(axes, eObject).or((Object)false);
        }
        return false;
    }

    public static boolean canMakeWritable(Resource resource, EditingDomain domain) {
        return EMFHelper.canMakeWritable((Set<ReadOnlyAxis>)ReadOnlyAxis.anyAxis(), resource, domain);
    }

    public static boolean canMakeWritable(Set<ReadOnlyAxis> axes, Resource resource, EditingDomain domain) {
        Object handler;
        if (domain != null && (handler = PlatformHelper.getAdapter((Object)domain, IReadOnlyHandler.class)) instanceof IReadOnlyHandler2) {
            return (Boolean)((IReadOnlyHandler2)handler).canMakeWritable(axes, new URI[]{resource.getURI()}).or((Object)false);
        }
        return false;
    }

    public static boolean isRequired(EStructuralFeature feature) {
        EClassifier eType = feature.getEType();
        if (eType == null) {
            return false;
        }
        if (eType instanceof EEnum) {
            return true;
        }
        if (feature.getLowerBound() >= 1) {
            return true;
        }
        if (eType.getInstanceClass() != null && eType.getInstanceClass().isPrimitive() && !feature.isUnsettable()) {
            return true;
        }
        return feature.getDefaultValueLiteral() != null;
    }

    public static <T> Set<T> allInstances(Resource resource, Class<T> type) {
        TreeIterator iterator = resource.getAllContents();
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        while (iterator.hasNext()) {
            EObject element = (EObject)iterator.next();
            if (!type.isInstance(element)) continue;
            result.add(type.cast(element));
        }
        return result;
    }

    public static Set<EPackage> getAllEPackages(Resource resource) {
        LinkedHashSet<EPackage> result = new LinkedHashSet<EPackage>();
        for (EObject rootElement : resource.getContents()) {
            if (!(rootElement instanceof EPackage)) continue;
            result.add((EPackage)rootElement);
            result.addAll(EMFHelper.getAllNestedPackages((EPackage)rootElement));
        }
        return result;
    }

    public static Set<EPackage> getAllNestedPackages(EPackage basePackage) {
        LinkedHashSet<EPackage> result = new LinkedHashSet<EPackage>();
        for (EPackage nestedPackage : basePackage.getESubpackages()) {
            result.add(nestedPackage);
            result.addAll(EMFHelper.getAllNestedPackages(nestedPackage));
        }
        return result;
    }

    public static Set<EPackage> getMetamodels(Resource resource) {
        HashSet<EPackage> metamodels = new HashSet<EPackage>();
        if (resource != null) {
            ArrayList contents = new ArrayList(resource.getContents());
            for (EObject current : contents) {
                metamodels.add(current.eClass().getEPackage());
            }
        }
        return metamodels;
    }

    public static final String getXMIID(EObject object) {
        String objectID = null;
        if (object != null && object.eResource() instanceof XMIResource) {
            objectID = ((XMIResource)object.eResource()).getID(object);
        }
        return objectID;
    }

    public static Collection<EStructuralFeature.Setting> getUsages(EObject source) {
        return org.eclipse.papyrus.infra.core.utils.EMFHelper.getUsages((EObject)source);
    }

    public static boolean isOnlyUsage(EObject usedObject, EObject knownReferencer) {
        boolean isUsed = false;
        EPackage mmPackage = usedObject.eClass().getEPackage();
        HashSet<EObject> crossReferences = new HashSet<EObject>();
        for (EStructuralFeature.Setting setting : EMFHelper.getUsages(usedObject)) {
            EObject eObj = setting.getEObject();
            if (!eObj.eClass().getEPackage().equals(mmPackage)) continue;
            crossReferences.add(eObj);
        }
        crossReferences.remove(usedObject.eContainer());
        crossReferences.remove(knownReferencer);
        if (crossReferences.isEmpty()) {
            isUsed = true;
        }
        return isUsed;
    }

    public static boolean isSuperType(EClassifier superType, EClassifier subType) {
        if (superType == subType) {
            return true;
        }
        if (superType instanceof EClass && subType instanceof EClass) {
            if (superType == EcorePackage.eINSTANCE.getEObject()) {
                return true;
            }
            EClass superTypeEClass = (EClass)superType;
            EClass subTypeEClass = (EClass)subType;
            return superTypeEClass.isSuperTypeOf(subTypeEClass);
        }
        return superType == EcorePackage.eINSTANCE.getEDataType() && subType instanceof EDataType;
    }

    public static List<EObject> getContainmentPath(EObject element) {
        if (element.eContainer() == null) {
            LinkedList<EObject> result = new LinkedList<EObject>();
            result.add(element);
            return result;
        }
        List<EObject> result = EMFHelper.getContainmentPath(element.eContainer());
        result.add(element);
        return result;
    }

    public static <T extends EObject> T reloadIntoContext(T element, EObject contextElement) {
        ResourceSet loadingContext;
        ResourceSet sourceResourceSet = EMFHelper.getResourceSet(element);
        if (sourceResourceSet == (loadingContext = EMFHelper.getResourceSet(contextElement)) || loadingContext == null) {
            return element;
        }
        URI sourceURI = EcoreUtil.getURI(element);
        EObject result = loadingContext.getEObject(sourceURI, true);
        return (T)result;
    }

    public static ResourceSet getResourceSet(EObject eObject) {
        Resource resource = eObject == null ? null : eObject.eResource();
        return resource == null ? null : resource.getResourceSet();
    }

    public static <T extends EObject> T load(ResourceSet rset, URI uri, Class<T> type) {
        EObject result;
        block2: {
            result = null;
            try {
                result = (EObject)EMFHelper.loadChecked(rset, uri, type);
            }
            catch (Exception e) {
                Activator.log.error("Exception in loading resource " + String.valueOf(uri), (Throwable)e);
                Resource res = rset.getResource(uri, false);
                if (res == null || !res.isLoaded()) break block2;
                result = (EObject)Iterables.getFirst((Iterable)Iterables.filter((Iterable)res.getContents(), type), null);
            }
        }
        return (T)result;
    }

    public static <T extends EObject> T loadChecked(ResourceSet rset, URI uri, Class<T> type) throws IOException {
        try {
            return (T)((EObject)Iterables.getFirst((Iterable)Iterables.filter((Iterable)rset.getResource(uri, true).getContents(), type), null));
        }
        catch (WrappedException e) {
            if (e.exception() instanceof IOException) {
                throw (IOException)e.exception();
            }
            if (e.exception() instanceof RuntimeException) {
                throw (RuntimeException)e.exception();
            }
            throw e;
        }
    }

    public static URI getImageURI(EObject context, String uri) {
        URI result = URI.createURI((String)uri, (boolean)true);
        if (result.isRelative() && result.isHierarchical()) {
            URI baseURI;
            if (result.hasAbsolutePath() && !result.hasAuthority() && !result.hasDevice()) {
                result = URI.createHierarchicalURI((String[])result.segments(), (String)result.query(), (String)result.fragment());
            }
            if ((baseURI = EcoreUtil.getURI((EObject)context)) != null && baseURI.isPlatform()) {
                baseURI = baseURI.trimSegments(baseURI.segmentCount() - 2).trimFragment().appendSegment("");
                result = result.resolve(baseURI);
            }
        }
        return result;
    }
}

