/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.reverse.utils;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.papyrus.robotics.ros2.reverse.Activator;

public class FolderUtils {
    public static IFolder createFolderStructure(IProject project) {
        IFolder fModels = FolderUtils.getOrCreate((IContainer)project, "models");
        FolderUtils.getOrCreate((IContainer)fModels, "components");
        FolderUtils.getOrCreate((IContainer)fModels, "system");
        return fModels;
    }

    public static IFolder getOrCreate(IContainer parent, String name) {
        IFolder folder = parent.getFolder((IPath)new Path(name));
        if (!folder.exists()) {
            try {
                folder.create(false, true, null);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return folder;
    }

    public static IFolder getComponentFolder(IFolder fModels) {
        return FolderUtils.getOrCreate((IContainer)fModels, "components");
    }

    public static IProject obtainProject(String fileName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            Path path = new Path("/models/components/" + fileName);
            IFile file = project.getFile((IPath)path);
            if (file.exists()) {
                return project;
            }
            String diFileName = fileName.substring(0, fileName.length() - ".uml".length()) + ".di";
            path = new Path("/models/components/" + diFileName);
            file = project.getFile((IPath)path);
            if (file.exists()) {
                return project;
            }
            ++n2;
        }
        return null;
    }
}

