/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.reverse.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.robotics.ros2.base.EnvironmentUtils;
import org.eclipse.papyrus.robotics.ros2.reverse.fromsys.ReverseMessages;
import org.eclipse.papyrus.robotics.ros2.reverse.utils.FolderUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ReverseMessagesHandler
extends AbstractHandler {
    protected IContainer container;

    public boolean isEnabled() {
        IStructuredSelection selection = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        Object selected = selection.getFirstElement();
        if (selected instanceof IAdaptable) {
            selected = ((IAdaptable)selected).getAdapter(IContainer.class);
        }
        if (selected instanceof IContainer) {
            this.container = (IContainer)selected;
            return true;
        }
        return false;
    }

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        Shell shell = Display.getCurrent().getActiveShell();
        boolean sourceSh = MessageDialog.openQuestion((Shell)shell, (String)"Add workspace to path?", (String)"Do you want to \"source\" an additional setup.sh scriptbefore starting the reverse (typically in the install folder of a ROS 2 workspace)");
        if (sourceSh) {
            EnvironmentUtils.selectAndSourceScript((String)this.container.getLocation().toString(), (Shell)shell);
        }
        Job job = new Job("Reverse ROS messages and services"){

            protected IStatus run(IProgressMonitor monitor) {
                IFolder folder = null;
                if (ReverseMessagesHandler.this.container instanceof IProject) {
                    IFolder models = FolderUtils.getOrCreate((IContainer)((IProject)ReverseMessagesHandler.this.container), "models");
                    folder = FolderUtils.getOrCreate((IContainer)models, "services");
                } else if (ReverseMessagesHandler.this.container instanceof IFolder) {
                    folder = (IFolder)ReverseMessagesHandler.this.container;
                }
                if (folder != null) {
                    new ReverseMessages(folder).reverseMessages(monitor);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return null;
    }
}

