/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.cpp.skillrealization;

import com.google.common.collect.Iterables;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.designer.languages.common.base.file.ProtSection;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.profile.robotics.commpattern.CommunicationPattern;
import org.eclipse.papyrus.robotics.profile.robotics.skills.InAttribute;
import org.eclipse.papyrus.robotics.profile.robotics.skills.OutAttribute;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillOperationalState;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillParameter;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillSemantic;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.SkillUtils;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Property;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class CreateSkillRealizationCppCode {
    private static String msgAbortMultipleOperationalStatesIsUnsopported() {
        return String.format("abort transformation, code-generation of skill FSMs with many operational states is not supported", new Object[0]);
    }

    private static String msgAbortSystemHasNotCompIf(String ifName) {
        return String.format("abort transformation, there are no components in the system with the required coordination interface (%s)", ifName);
    }

    private static String msgAbortCompIfNotActionNorQuery(String ifName) {
        return String.format("abort transformation, the coordination interface has incompatible type (%s)", ifName);
    }

    public static CharSequence createCppSimplestActionSkill(SkillDefinition skill, SkillOperationalState ops, String actionName) {
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// Generated by Papyrus4Robotics");
        _builder.newLine();
        _builder.append("//");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// ");
        String _protSection = ProtSection.protSection((String)"BtActionNode header files");
        _builder.append(_protSection);
        _builder.newLineIfNotEmpty();
        _builder.append("// ");
        String _protSection_1 = ProtSection.protSection();
        _builder.append(_protSection_1);
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"bt_utils/generic_types_conversions.hpp\"");
        _builder.newLine();
        LinkedHashSet _uniqueSkillParameterTypes = SkillUtils.getUniqueSkillParameterTypes((SkillDefinition)skill);
        for (DataType tp : _uniqueSkillParameterTypes) {
            _builder.append("#include \"");
            String _rOS2TypeIncludePath = SkillUtils.getROS2TypeIncludePath((DataType)tp);
            _builder.append(_rOS2TypeIncludePath);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("#include \"");
        String _coordinationIfIncludePath = SkillUtils.getCoordinationIfIncludePath((SkillOperationalState)ops);
        _builder.append(_coordinationIfIncludePath);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"nav2_behavior_tree/bt_action_node.hpp\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("class ");
        String _name = SkillUtils.getName((SkillDefinition)skill);
        _builder.append(_name);
        _builder.append("Action : public nav2_behavior_tree::BtActionNode<");
        String _coordinationIfQn = SkillUtils.getCoordinationIfQn((SkillOperationalState)ops);
        _builder.append(_coordinationIfQn);
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("  ");
        String _name_1 = SkillUtils.getName((SkillDefinition)skill);
        _builder.append(_name_1, "  ");
        _builder.append("Action(");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("const std::string& name,");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("const std::string & action_name,");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("const BT::NodeConfiguration& conf)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append(": nav2_behavior_tree::BtActionNode<");
        String _coordinationIfQn_1 = SkillUtils.getCoordinationIfQn((SkillOperationalState)ops);
        _builder.append(_coordinationIfQn_1, "  ");
        _builder.append(">(name, action_name, conf)");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)skill.getIns());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("  ");
            _builder.append("void on_tick() override");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("{");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("\t");
            _builder.append("// ");
            String _protSection_2 = ProtSection.protSection((String)"BtActionNode on_tick()");
            _builder.append(_protSection_2, "  \t");
            _builder.newLineIfNotEmpty();
            EList _ins = skill.getIns();
            for (InAttribute param : _ins) {
                _builder.append("  ");
                _builder.append("  ");
                String _rOS2TypeFromMsgName = SkillUtils.getROS2TypeFromMsgName((DataType)SkillUtils.getType((SkillParameter)param));
                _builder.append(_rOS2TypeFromMsgName, "    ");
                _builder.append(" ");
                String _name_2 = SkillUtils.getName((SkillParameter)param);
                _builder.append(_name_2, "    ");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("getInput(\"");
                String _name_3 = SkillUtils.getName((SkillParameter)param);
                _builder.append(_name_3, "    ");
                _builder.append("\", ");
                String _name_4 = SkillUtils.getName((SkillParameter)param);
                _builder.append(_name_4, "    ");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                EList _ownedAttributes = SkillUtils.getType((SkillParameter)param).getOwnedAttributes();
                for (Property prop : _ownedAttributes) {
                    _builder.append("  ");
                    _builder.append("  ");
                    _builder.append("goal_.");
                    String _name_5 = prop.getName();
                    _builder.append(_name_5, "    ");
                    _builder.append(" = ");
                    String _name_6 = SkillUtils.getName((SkillParameter)param);
                    _builder.append(_name_6, "    ");
                    _builder.append(".");
                    String _name_7 = prop.getName();
                    _builder.append(_name_7, "    ");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append("  ");
            _builder.append("\t");
            _builder.append("// ");
            String _protSection_3 = ProtSection.protSection();
            _builder.append(_protSection_3, "  \t");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)skill.getOuts());
        boolean bl2 = _not_1 = !_isNullOrEmpty_1;
        if (_not_1) {
            _builder.append("  ");
            _builder.append("BT::NodeStatus on_success() override");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("{");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("\t");
            _builder.append("// ");
            String _protSection_4 = ProtSection.protSection((String)"BtActionNode on_success()");
            _builder.append(_protSection_4, "  \t");
            _builder.newLineIfNotEmpty();
            EList _outs = skill.getOuts();
            for (OutAttribute param_1 : _outs) {
                _builder.append("  ");
                _builder.append("\t");
                String _rOS2TypeFromMsgName_1 = SkillUtils.getROS2TypeFromMsgName((DataType)SkillUtils.getType((SkillParameter)param_1));
                _builder.append(_rOS2TypeFromMsgName_1, "  \t");
                _builder.append(" ");
                String _name_8 = SkillUtils.getName((SkillParameter)param_1);
                _builder.append(_name_8, "  \t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                EList _ownedAttributes_1 = SkillUtils.getType((SkillParameter)param_1).getOwnedAttributes();
                for (Property prop_1 : _ownedAttributes_1) {
                    _builder.append("  ");
                    _builder.append("\t");
                    String _name_9 = SkillUtils.getName((SkillParameter)param_1);
                    _builder.append(_name_9, "  \t");
                    _builder.append(".");
                    String _name_10 = prop_1.getName();
                    _builder.append(_name_10, "  \t");
                    _builder.append(" = result_.result->");
                    String _name_11 = prop_1.getName();
                    _builder.append(_name_11, "  \t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("  ");
                _builder.append("\t");
                _builder.append("setOutput(\"");
                String _name_12 = SkillUtils.getName((SkillParameter)param_1);
                _builder.append(_name_12, "  \t");
                _builder.append("\", ");
                String _name_13 = SkillUtils.getName((SkillParameter)param_1);
                _builder.append(_name_13, "  \t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("  ");
            _builder.append("\t");
            _builder.append("return BT::NodeStatus::SUCCESS;");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("\t");
            _builder.append("// ");
            String _protSection_5 = ProtSection.protSection();
            _builder.append(_protSection_5, "  \t");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("  ");
        CharSequence _createProvidedPortsMethod = CreateSkillRealizationCppCode.createProvidedPortsMethod(skill, true);
        _builder.append((Object)_createProvidedPortsMethod, "  ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("// ");
        String _protSection_6 = ProtSection.protSection((String)"- BtActionNode other class methods and attributes (if any)");
        _builder.append(_protSection_6);
        _builder.newLineIfNotEmpty();
        _builder.append("// ");
        String _protSection_7 = ProtSection.protSection();
        _builder.append(_protSection_7);
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"behaviortree_cpp_v3/bt_factory.h\"");
        _builder.newLine();
        _builder.append("BT_REGISTER_NODES(factory)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("BT::NodeBuilder builder =");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("[](const std::string & name, const BT::NodeConfiguration & config)");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("return std::make_unique<");
        String _name_14 = SkillUtils.getName((SkillDefinition)skill);
        _builder.append(_name_14, "      ");
        _builder.append("Action>(name, \"");
        _builder.append(actionName, "      ");
        _builder.append("\", config);");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("factory.registerBuilder<");
        String _name_15 = SkillUtils.getName((SkillDefinition)skill);
        _builder.append(_name_15, "  ");
        _builder.append("Action>(\"");
        String _name_16 = SkillUtils.getName((SkillDefinition)skill);
        _builder.append(_name_16, "  ");
        _builder.append("\", builder);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence createCppSimplestQuerySkill(SkillDefinition skill, SkillOperationalState ops, String serviceName) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// Generated by Papyrus4Robotics");
        _builder.newLine();
        _builder.append("//");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// ");
        String _protSection = ProtSection.protSection((String)"BtConditionNode header files");
        _builder.append(_protSection);
        _builder.newLineIfNotEmpty();
        _builder.append("// ");
        String _protSection_1 = ProtSection.protSection();
        _builder.append(_protSection_1);
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"bt_utils/generic_types_conversions.hpp\"");
        _builder.newLine();
        LinkedHashSet _uniqueSkillParameterTypes = SkillUtils.getUniqueSkillParameterTypes((SkillDefinition)skill);
        for (DataType tp : _uniqueSkillParameterTypes) {
            _builder.append("#include \"");
            String _rOS2TypeIncludePath = SkillUtils.getROS2TypeIncludePath((DataType)tp);
            _builder.append(_rOS2TypeIncludePath);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("#include \"");
        String _coordinationIfIncludePath = SkillUtils.getCoordinationIfIncludePath((SkillOperationalState)ops);
        _builder.append(_coordinationIfIncludePath);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"bt_utils/bt_condition_node.hpp\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("class ");
        String _name = SkillUtils.getName((SkillDefinition)skill);
        _builder.append(_name);
        _builder.append("Condition : public bt_utils::BtConditionNode<");
        String _coordinationIfQn = SkillUtils.getCoordinationIfQn((SkillOperationalState)ops);
        _builder.append(_coordinationIfQn);
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("  ");
        String _name_1 = SkillUtils.getName((SkillDefinition)skill);
        _builder.append(_name_1, "  ");
        _builder.append("Condition(");
        _builder.newLineIfNotEmpty();
        _builder.append("      ");
        _builder.append("const std::string& name,");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("const std::string & service_name,");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("const BT::NodeConfiguration& conf)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append(": bt_utils::BtConditionNode<");
        String _coordinationIfQn_1 = SkillUtils.getCoordinationIfQn((SkillOperationalState)ops);
        _builder.append(_coordinationIfQn_1, "  ");
        _builder.append(">(name, service_name, conf)");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)skill.getIns());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("  ");
            _builder.append("void on_tick() override");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("{");
            _builder.newLine();
            _builder.append("  ");
            _builder.append("\t");
            _builder.append("// ");
            String _protSection_2 = ProtSection.protSection((String)"BtConditionNode on_tick()");
            _builder.append(_protSection_2, "  \t");
            _builder.newLineIfNotEmpty();
            EList _ins = skill.getIns();
            for (InAttribute param : _ins) {
                _builder.append("  ");
                _builder.append("  ");
                String _rOS2TypeFromMsgName = SkillUtils.getROS2TypeFromMsgName((DataType)SkillUtils.getType((SkillParameter)param));
                _builder.append(_rOS2TypeFromMsgName, "    ");
                _builder.append(" ");
                String _name_2 = SkillUtils.getName((SkillParameter)param);
                _builder.append(_name_2, "    ");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("getInput(\"");
                String _name_3 = SkillUtils.getName((SkillParameter)param);
                _builder.append(_name_3, "    ");
                _builder.append("\", ");
                String _name_4 = SkillUtils.getName((SkillParameter)param);
                _builder.append(_name_4, "    ");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                EList _ownedAttributes = SkillUtils.getType((SkillParameter)param).getOwnedAttributes();
                for (Property prop : _ownedAttributes) {
                    _builder.append("  ");
                    _builder.append("  ");
                    _builder.append("request_->");
                    String _name_5 = prop.getName();
                    _builder.append(_name_5, "    ");
                    _builder.append(" = ");
                    String _name_6 = SkillUtils.getName((SkillParameter)param);
                    _builder.append(_name_6, "    ");
                    _builder.append(".");
                    String _name_7 = prop.getName();
                    _builder.append(_name_7, "    ");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append("  ");
            _builder.append("\t");
            _builder.append("// ");
            String _protSection_3 = ProtSection.protSection();
            _builder.append(_protSection_3, "  \t");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("  ");
        _builder.append("BT::NodeStatus check_future(");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("std::shared_future<typename ");
        String _coordinationIfQn_2 = SkillUtils.getCoordinationIfQn((SkillOperationalState)ops);
        _builder.append(_coordinationIfQn_2, "      ");
        _builder.append("::Response::SharedPtr> future_result) override");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("rclcpp::FutureReturnCode rc;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("rc = rclcpp::spin_until_future_complete(");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("node_,");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("future_result, server_timeout_);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if (rc == rclcpp::FutureReturnCode::SUCCESS) {");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("auto res = future_result.get()->data;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("      ");
        _builder.append("return (res == true) ? BT::NodeStatus::SUCCESS : BT::NodeStatus::FAILURE;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("} else if (rc == rclcpp::FutureReturnCode::TIMEOUT) {");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("RCLCPP_WARN(");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("node_->get_logger(),");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("\"Node timed out while executing service call to %s.\", service_name_.c_str());");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("on_wait_for_result();");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return BT::NodeStatus::FAILURE;");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        CharSequence _createProvidedPortsMethod = CreateSkillRealizationCppCode.createProvidedPortsMethod(skill, true);
        _builder.append((Object)_createProvidedPortsMethod, "  ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("// ");
        String _protSection_4 = ProtSection.protSection((String)"- BtConditionNode other class methods and attributes (if any)");
        _builder.append(_protSection_4);
        _builder.newLineIfNotEmpty();
        _builder.append("// ");
        String _protSection_5 = ProtSection.protSection();
        _builder.append(_protSection_5);
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"behaviortree_cpp_v3/bt_factory.h\"");
        _builder.newLine();
        _builder.append("BT_REGISTER_NODES(factory)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("BT::NodeBuilder builder =");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("[](const std::string & name, const BT::NodeConfiguration & config)");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("return std::make_unique<");
        String _name_8 = SkillUtils.getName((SkillDefinition)skill);
        _builder.append(_name_8, "      ");
        _builder.append("Condition>(name, \"");
        _builder.append(serviceName, "      ");
        _builder.append("\", config);");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("factory.registerBuilder<");
        String _name_9 = SkillUtils.getName((SkillDefinition)skill);
        _builder.append(_name_9, "  ");
        _builder.append("Condition>(\"");
        String _name_10 = SkillUtils.getName((SkillDefinition)skill);
        _builder.append(_name_10, "  ");
        _builder.append("\", builder);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence createCppSimplestSkillNoInteraction(SkillDefinition skill) {
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// Generated by Papyrus4Robotics");
        _builder.newLine();
        _builder.append("// ...");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include <string>");
        _builder.newLine();
        _builder.append("// ");
        String _protSection = ProtSection.protSection((String)"ActionNodeBase header files");
        _builder.append(_protSection);
        _builder.newLineIfNotEmpty();
        _builder.append("// ");
        String _protSection_1 = ProtSection.protSection();
        _builder.append(_protSection_1);
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"rclcpp/rclcpp.hpp\"");
        _builder.newLine();
        _builder.append("#include \"bt_utils/generic_types_conversions.hpp\"");
        _builder.newLine();
        LinkedHashSet _uniqueSkillParameterTypes = SkillUtils.getUniqueSkillParameterTypes((SkillDefinition)skill);
        for (DataType tp : _uniqueSkillParameterTypes) {
            _builder.append("#include \"");
            String _rOS2TypeIncludePath = SkillUtils.getROS2TypeIncludePath((DataType)tp);
            _builder.append(_rOS2TypeIncludePath);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("#include \"behaviortree_cpp_v3/action_node.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("class ");
        String _name = SkillUtils.getName((SkillDefinition)skill);
        _builder.append(_name);
        _builder.append("Action : public BT::ActionNodeBase");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("// Any TreeNode with ports must have a constructor with this signature");
        _builder.newLine();
        _builder.append("  ");
        String _name_1 = SkillUtils.getName((SkillDefinition)skill);
        _builder.append(_name_1, "  ");
        _builder.append("Action(");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("const std::string& name,");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("const BT::NodeConfiguration& config)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append(": ActionNodeBase(name, config)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("  ");
        CharSequence _createProvidedPortsMethod = CreateSkillRealizationCppCode.createProvidedPortsMethod(skill, false);
        _builder.append((Object)_createProvidedPortsMethod, "  ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("BT::NodeStatus tick() override");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("  \t");
        _builder.append("// ");
        String _protSection_2 = ProtSection.protSection((String)"ActionNodeBase tick()");
        _builder.append(_protSection_2, "  \t");
        _builder.newLineIfNotEmpty();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)skill.getIns());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append("\t");
            _builder.append("// Read from input ports");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//");
            _builder.newLine();
            EList _ins = skill.getIns();
            for (InAttribute param : _ins) {
                _builder.append("\t");
                String _rOS2TypeFromMsgName = SkillUtils.getROS2TypeFromMsgName((DataType)SkillUtils.getType((SkillParameter)param));
                _builder.append(_rOS2TypeFromMsgName, "\t");
                _builder.append(" ");
                String _name_2 = SkillUtils.getName((SkillParameter)param);
                _builder.append(_name_2, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("getInput(\"");
                String _name_3 = SkillUtils.getName((SkillParameter)param);
                _builder.append(_name_3, "\t");
                _builder.append("\", ");
                String _name_4 = SkillUtils.getName((SkillParameter)param);
                _builder.append(_name_4, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* ----------------------------------------------");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("* USER CODE HERE USING READINGS FROM INPUT PORTS");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("* ----------------------------------------------");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
        }
        _builder.newLine();
        if (IterableExtensions.isNullOrEmpty((Iterable)skill.getIns()) && IterableExtensions.isNullOrEmpty((Iterable)skill.getOuts())) {
            _builder.append("\t");
            _builder.append("/* -------------------");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("* SOME USER CODE HERE");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("* -------------------");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
        }
        _builder.newLine();
        boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)skill.getOuts());
        boolean bl2 = _not_1 = !_isNullOrEmpty_1;
        if (_not_1) {
            _builder.append("\t");
            _builder.append("// Share through the blackboard");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("//");
            _builder.newLine();
            EList _outs = skill.getOuts();
            for (OutAttribute param_1 : _outs) {
                _builder.append("\t");
                String _rOS2TypeFromMsgName_1 = SkillUtils.getROS2TypeFromMsgName((DataType)SkillUtils.getType((SkillParameter)param_1));
                _builder.append(_rOS2TypeFromMsgName_1, "\t");
                _builder.append(" ");
                String _name_5 = SkillUtils.getName((SkillParameter)param_1);
                _builder.append(_name_5, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("/* -----------------------------------------");
                _builder.newLine();
                _builder.append("\t");
                _builder.append(" ");
                _builder.append("* USER CODE HERE TO INITIALIZE THE VARIABLE");
                _builder.newLine();
                _builder.append("\t");
                _builder.append(" ");
                _builder.append("* -----------------------------------------");
                _builder.newLine();
                _builder.append("\t");
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("setOutput(\"");
                String _name_6 = SkillUtils.getName((SkillParameter)param_1);
                _builder.append(_name_6, "\t");
                _builder.append("\", ");
                String _name_7 = SkillUtils.getName((SkillParameter)param_1);
                _builder.append(_name_7, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
            }
        }
        _builder.append("  \t");
        _builder.append("return BT::NodeStatus::SUCCESS;");
        _builder.newLine();
        _builder.append("  \t");
        _builder.append("// ");
        String _protSection_3 = ProtSection.protSection();
        _builder.append(_protSection_3, "  \t");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// ");
        String _protSection_4 = ProtSection.protSection((String)"- ActionNodeBase other class methods and attributes (if any)");
        _builder.append(_protSection_4);
        _builder.newLineIfNotEmpty();
        _builder.append("// ");
        String _protSection_5 = ProtSection.protSection();
        _builder.append(_protSection_5);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"behaviortree_cpp_v3/bt_factory.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// This function must be implemented in the .cpp file to create");
        _builder.newLine();
        _builder.append("// a plugin that can be loaded at run-time");
        _builder.newLine();
        _builder.append("BT_REGISTER_NODES(factory)");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("factory.registerNodeType<");
        String _name_8 = SkillUtils.getName((SkillDefinition)skill);
        _builder.append(_name_8, "    ");
        _builder.append("Action>(\"");
        String _name_9 = SkillUtils.getName((SkillDefinition)skill);
        _builder.append(_name_9, "    ");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence createProvidedPortsMethod(SkillDefinition skill, boolean need_basic_ports) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// ");
        String _name = SkillUtils.getName((SkillDefinition)skill);
        _builder.append(_name);
        _builder.append(" has a constructor in the form (const std::string&, const NodeConfiguration&) => must provide a providedPorts method");
        _builder.newLineIfNotEmpty();
        _builder.append("static BT::PortsList providedPorts()");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("return");
        if (need_basic_ports) {
            _builder.append(" providedBasicPorts(");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("{");
        _builder.newLine();
        _builder.append("  \t");
        CharSequence _createPortConstructionCommands = CreateSkillRealizationCppCode.createPortConstructionCommands(skill);
        _builder.append((Object)_createPortConstructionCommands, "  \t");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("}");
        if (need_basic_ports) {
            _builder.append(")");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence createPortConstructionCommands(SkillDefinition skill) {
        StringConcatenation _builder = new StringConcatenation();
        EList _ins = skill.getIns();
        EList _outs = skill.getOuts();
        Iterable _plus = Iterables.concat((Iterable)_ins, (Iterable)_outs);
        boolean _hasElements = false;
        for (SkillParameter param : _plus) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            boolean _contains = skill.getIns().contains((Object)param);
            if (_contains) {
                _builder.append("BT::InputPort<");
            } else {
                _builder.append("BT::OutputPort<");
            }
            String _rOS2TypeFromMsgName = SkillUtils.getROS2TypeFromMsgName((DataType)SkillUtils.getType((SkillParameter)param));
            _builder.append(_rOS2TypeFromMsgName);
            _builder.append(">(\"");
            String _name = SkillUtils.getName((SkillParameter)param);
            _builder.append(_name);
            _builder.append("\")");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static void genCode(IPFileSystemAccess fileAccess, Map<SkillDefinition, SkillSemantic> skdefToSemanticsMap, Map<Interface, String> serviceToNameMap) {
        try {
            Set<Map.Entry<SkillDefinition, SkillSemantic>> _entrySet = skdefToSemanticsMap.entrySet();
            for (Map.Entry<SkillDefinition, SkillSemantic> entry : _entrySet) {
                boolean _greaterThan;
                SkillDefinition definition = entry.getKey();
                SkillSemantic semantics = entry.getValue();
                int _size = semantics.getOperational().size();
                boolean bl = _greaterThan = _size > 1;
                if (_greaterThan) {
                    String _msgAbortMultipleOperationalStatesIsUnsopported = CreateSkillRealizationCppCode.msgAbortMultipleOperationalStatesIsUnsopported();
                    throw new TransformationException(_msgAbortMultipleOperationalStatesIsUnsopported);
                }
                SkillOperationalState ops = SkillUtils.getFirstOpState((SkillSemantic)semantics);
                String _realizationFileName = SkillUtils.realizationFileName((SkillDefinition)definition);
                String skillRealizationFileName = _realizationFileName + ".cpp";
                boolean _doesConfigAndCoordOfComponents = SkillUtils.doesConfigAndCoordOfComponents((SkillOperationalState)ops);
                if (_doesConfigAndCoordOfComponents) {
                    boolean _not;
                    Interface cIf = SkillUtils.getCompInterface((SkillOperationalState)ops);
                    boolean _containsKey = serviceToNameMap.containsKey(cIf);
                    boolean bl2 = _not = !_containsKey;
                    if (_not) {
                        String _msgAbortSystemHasNotCompIf = CreateSkillRealizationCppCode.msgAbortSystemHasNotCompIf(cIf.getName());
                        throw new TransformationException(_msgAbortSystemHasNotCompIf);
                    }
                    if (!InteractionUtils.isAction((CommunicationPattern)InteractionUtils.getCommunicationPattern((Interface)cIf)) && !InteractionUtils.isQuery((CommunicationPattern)InteractionUtils.getCommunicationPattern((Interface)cIf))) {
                        String _msgAbortCompIfNotActionNorQuery = CreateSkillRealizationCppCode.msgAbortCompIfNotActionNorQuery(cIf.getName());
                        throw new TransformationException(_msgAbortCompIfNotActionNorQuery);
                    }
                    boolean _isAction = InteractionUtils.isAction((CommunicationPattern)InteractionUtils.getCommunicationPattern((Interface)cIf));
                    if (_isAction) {
                        String actionName = serviceToNameMap.get(cIf);
                        fileAccess.generateFile(skillRealizationFileName, CreateSkillRealizationCppCode.createCppSimplestActionSkill(definition, ops, actionName).toString());
                        continue;
                    }
                    String serviceName = serviceToNameMap.get(cIf);
                    fileAccess.generateFile(skillRealizationFileName, CreateSkillRealizationCppCode.createCppSimplestQuerySkill(definition, ops, serviceName).toString());
                    continue;
                }
                fileAccess.generateFile(skillRealizationFileName, CreateSkillRealizationCppCode.createCppSimplestSkillNoInteraction(definition).toString());
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

