/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.common.launch;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.robotics.bpc.profile.bpc.Entity;
import org.eclipse.papyrus.robotics.core.utils.InstanceUtils;
import org.eclipse.papyrus.robotics.core.utils.ParameterUtils;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillDefinition;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.SequencerUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.SkillUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ConfigYAML {
    public static CharSequence createParameterFile(Class system) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        List _compInstanceList = InstanceUtils.getCompInstanceList((Class)system);
        for (Property part : _compInstanceList) {
            if (!(part.getType() instanceof Class) || ParameterUtils.getAllParameters((Class)((Class)part.getType())).size() <= 0) continue;
            String _name = part.getName();
            _builder.append(_name);
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("ros__parameters:");
            _builder.newLine();
            ArrayList<String> names = new ArrayList<String>();
            _builder.newLineIfNotEmpty();
            Type _type = part.getType();
            List _allParameters = ParameterUtils.getAllParameters((Class)((Class)_type));
            for (Property param : _allParameters) {
                String _hierarchicalName = ConfigYAML.hierarchicalName((NamedElement)param, names);
                _builder.append(_hierarchicalName);
                _builder.append(" : ");
                String _paramValue = ConfigYAML.paramValue(part, param);
                _builder.append(_paramValue);
                _builder.newLineIfNotEmpty();
            }
        }
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(SkillUtils.getUniqueSkills(system));
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _sequencerName = SequencerUtils.getSequencerName(system);
            _builder.append(_sequencerName);
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("ros__parameters:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("default_bt_xml_filename: \"$(find-pkg-share ");
            String _rOS2PackageNameOfDefaultTask = SkillUtils.getROS2PackageNameOfDefaultTask(system);
            _builder.append(_rOS2PackageNameOfDefaultTask, "    ");
            _builder.append(")/");
            String _packageRelativeFolderNameOfDefaultTask = SkillUtils.getPackageRelativeFolderNameOfDefaultTask(system);
            _builder.append(_packageRelativeFolderNameOfDefaultTask, "    ");
            _builder.append("/");
            String _bTFileNameOfDefaultTask = SkillUtils.getBTFileNameOfDefaultTask(system);
            _builder.append(_bTFileNameOfDefaultTask, "    ");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("plugin_lib_names: [");
            _builder.newLine();
            LinkedHashSet<SkillDefinition> _uniqueSkills = SkillUtils.getUniqueSkills(system);
            boolean _hasElements = false;
            for (SkillDefinition skill : _uniqueSkills) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "    ");
                }
                _builder.append("    ");
                String _realizationFileName = SkillUtils.realizationFileName(skill);
                String _plus = "  \"" + _realizationFileName;
                _builder.append(_plus, "    ");
                _builder.append("_bt_node\"");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("    ");
            _builder.append("]");
            _builder.newLine();
        }
        return _builder;
    }

    public static String paramValue(Property part, Property parameter) {
        Entity entity;
        int _length;
        boolean _equals;
        ValueSpecification _defaultValue_1;
        InstanceSpecification is;
        Object value = "";
        ValueSpecification _defaultValue = part.getDefaultValue();
        if (_defaultValue instanceof InstanceValue && (is = ((InstanceValue)(_defaultValue_1 = part.getDefaultValue())).getInstance()) != null) {
            EList _slots = is.getSlots();
            for (Slot slot : _slots) {
                if (!Objects.equals(slot.getDefiningFeature(), parameter) || DepUtils.firstValue((Slot)slot) == null) continue;
                value = ConfigYAML.quoteEmpty(DepUtils.firstValue((Slot)slot).stringValue());
            }
        }
        boolean bl = _equals = (_length = ((String)value).length()) == 0;
        if (_equals) {
            boolean _tripleNotEquals;
            ValueSpecification _defaultValue_2 = parameter.getDefaultValue();
            boolean bl2 = _tripleNotEquals = _defaultValue_2 != null;
            if (_tripleNotEquals) {
                String _quoteEmpty = ConfigYAML.quoteEmpty(parameter.getDefaultValue().stringValue());
                String _plus = _quoteEmpty + " # (default)";
                value = _plus;
            } else {
                value = "'' # (empty)";
            }
        }
        if ((entity = (Entity)UMLUtil.getStereotypeApplication((Element)parameter, Entity.class)) != null && entity.getDescription() != null) {
            boolean _not;
            boolean _contains = ((String)value).contains("#");
            boolean bl3 = _not = !_contains;
            if (_not) {
                Object _value = value;
                value = (String)_value + " #";
            }
            Object _value_1 = value;
            String _description = entity.getDescription();
            String _plus_1 = " " + _description;
            value = (String)_value_1 + _plus_1;
        }
        return value;
    }

    public static String quoteEmpty(String value) {
        boolean _equals;
        int _length = value.length();
        boolean bl = _equals = _length == 0;
        if (_equals) {
            return "''";
        }
        return value;
    }

    public static String hierarchicalName(NamedElement ne, List<String> names) {
        String[] _split;
        Object result = "";
        Object indent = "    ";
        Object qName = "";
        String[] stringArray = _split = ne.getName().split("\\.");
        int n = _split.length;
        int n2 = 0;
        while (n2 < n) {
            boolean _not;
            Object _qName = qName;
            String part = stringArray[n2];
            boolean _contains = names.contains(qName = (String)_qName + part + ".");
            boolean bl = _not = !_contains;
            if (_not) {
                boolean _greaterThan;
                names.add((String)qName);
                int _length = ((String)result).length();
                boolean bl2 = _greaterThan = _length > 4;
                if (_greaterThan) {
                    String _result = result;
                    result = _result + ":\n";
                }
                String _result_1 = result;
                result = _result_1 + (String)indent + part;
            }
            String _indent = indent;
            indent = _indent + "  ";
            ++n2;
        }
        return result;
    }
}

