/**
 * Copyright (c) 2025 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr - Bug #22, dummy robot example is broken
 *          (better separate YAML file creation by moving into separate class)
 */
package org.eclipse.papyrus.robotics.ros2.codegen.common.launch;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.robotics.bpc.profile.bpc.Entity;
import org.eclipse.papyrus.robotics.core.utils.InstanceUtils;
import org.eclipse.papyrus.robotics.core.utils.ParameterUtils;
import org.eclipse.papyrus.robotics.profile.robotics.skills.SkillDefinition;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.SequencerUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.SkillUtils;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Create a set of launch scripts
 */
@SuppressWarnings("all")
public class ConfigYAML {
  /**
   * initialize parameter values from instance specifications and the (implicit) system sequencer model
   * (In the current implementation, the default skill semantics realization is always selected)
   */
  public static CharSequence createParameterFile(final org.eclipse.uml2.uml.Class system) {
    StringConcatenation _builder = new StringConcatenation();
    {
      List<Property> _compInstanceList = InstanceUtils.getCompInstanceList(system);
      for(final Property part : _compInstanceList) {
        {
          if (((part.getType() instanceof org.eclipse.uml2.uml.Class) && (ParameterUtils.getAllParameters(((org.eclipse.uml2.uml.Class) part.getType())).size() > 0))) {
            String _name = part.getName();
            _builder.append(_name);
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            _builder.append("ros__parameters:");
            _builder.newLine();
            final ArrayList<String> names = new ArrayList<String>();
            _builder.newLineIfNotEmpty();
            {
              Type _type = part.getType();
              List<Property> _allParameters = ParameterUtils.getAllParameters(((org.eclipse.uml2.uml.Class) _type));
              for(final Property param : _allParameters) {
                String _hierarchicalName = ConfigYAML.hierarchicalName(param, names);
                _builder.append(_hierarchicalName);
                _builder.append(" : ");
                String _paramValue = ConfigYAML.paramValue(part, param);
                _builder.append(_paramValue);
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
      }
    }
    {
      boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(SkillUtils.getUniqueSkills(system));
      boolean _not = (!_isNullOrEmpty);
      if (_not) {
        String _sequencerName = SequencerUtils.getSequencerName(system);
        _builder.append(_sequencerName);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("ros__parameters:");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("default_bt_xml_filename: \"$(find-pkg-share ");
        String _rOS2PackageNameOfDefaultTask = SkillUtils.getROS2PackageNameOfDefaultTask(system);
        _builder.append(_rOS2PackageNameOfDefaultTask, "    ");
        _builder.append(")/");
        String _packageRelativeFolderNameOfDefaultTask = SkillUtils.getPackageRelativeFolderNameOfDefaultTask(system);
        _builder.append(_packageRelativeFolderNameOfDefaultTask, "    ");
        _builder.append("/");
        String _bTFileNameOfDefaultTask = SkillUtils.getBTFileNameOfDefaultTask(system);
        _builder.append(_bTFileNameOfDefaultTask, "    ");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("plugin_lib_names: [");
        _builder.newLine();
        {
          LinkedHashSet<SkillDefinition> _uniqueSkills = SkillUtils.getUniqueSkills(system);
          boolean _hasElements = false;
          for(final SkillDefinition skill : _uniqueSkills) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(",", "    ");
            }
            _builder.append("    ");
            String _realizationFileName = SkillUtils.realizationFileName(skill);
            String _plus = ("  \"" + _realizationFileName);
            _builder.append(_plus, "    ");
            _builder.append("_bt_node\"");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("    ");
        _builder.append("]");
        _builder.newLine();
      }
    }
    return _builder;
  }

  /**
   * Return either the specific value configured on the instance level or the default value
   */
  public static String paramValue(final Property part, final Property parameter) {
    String value = "";
    ValueSpecification _defaultValue = part.getDefaultValue();
    if ((_defaultValue instanceof InstanceValue)) {
      ValueSpecification _defaultValue_1 = part.getDefaultValue();
      final InstanceSpecification is = ((InstanceValue) _defaultValue_1).getInstance();
      if ((is != null)) {
        EList<Slot> _slots = is.getSlots();
        for (final Slot slot : _slots) {
          if ((Objects.equals(slot.getDefiningFeature(), parameter) && (DepUtils.firstValue(slot) != null))) {
            value = ConfigYAML.quoteEmpty(DepUtils.firstValue(slot).stringValue());
          }
        }
      }
    }
    int _length = value.length();
    boolean _equals = (_length == 0);
    if (_equals) {
      ValueSpecification _defaultValue_2 = parameter.getDefaultValue();
      boolean _tripleNotEquals = (_defaultValue_2 != null);
      if (_tripleNotEquals) {
        String _quoteEmpty = ConfigYAML.quoteEmpty(parameter.getDefaultValue().stringValue());
        String _plus = (_quoteEmpty + " # (default)");
        value = _plus;
      } else {
        value = "\'\' # (empty)";
      }
    }
    final Entity entity = UMLUtil.<Entity>getStereotypeApplication(parameter, Entity.class);
    if (((entity != null) && (entity.getDescription() != null))) {
      boolean _contains = value.contains("#");
      boolean _not = (!_contains);
      if (_not) {
        String _value = value;
        value = (_value + " #");
      }
      String _value_1 = value;
      String _description = entity.getDescription();
      String _plus_1 = (" " + _description);
      value = (_value_1 + _plus_1);
    }
    return value;
  }

  /**
   * #22: if a parameter or default parameter is empty, replace with 2 single quotes
   */
  public static String quoteEmpty(final String value) {
    int _length = value.length();
    boolean _equals = (_length == 0);
    if (_equals) {
      return "\'\'";
    } else {
      return value;
    }
  }

  /**
   * Calculate the YAML representation of a hierarchical name with "." separator
   * If the parent is used the first time, emit it
   */
  public static String hierarchicalName(final NamedElement ne, final List<String> names) {
    String result = "";
    String indent = "    ";
    String qName = "";
    String[] _split = ne.getName().split("\\.");
    for (final String part : _split) {
      {
        String _qName = qName;
        qName = (_qName + (part + "."));
        boolean _contains = names.contains(qName);
        boolean _not = (!_contains);
        if (_not) {
          names.add(qName);
          int _length = result.length();
          boolean _greaterThan = (_length > 4);
          if (_greaterThan) {
            String _result = result;
            result = (_result + ":\n");
          }
          String _result_1 = result;
          result = (_result_1 + (indent + part));
        }
        String _indent = indent;
        indent = (_indent + "  ");
      }
    }
    return result;
  }
}
