/**
 * Copyright (c) 2023 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 */
package org.eclipse.papyrus.robotics.ros2.codegen.common.component;

import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.robotics.codegen.common.utils.ActivityUtils;
import org.eclipse.uml2.uml.Port;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class CallbackGroups {
  /**
   * name of a callback group for a port (which is connected to an activity)
   */
  public static String callbackGroupName(final Port port) {
    try {
      final org.eclipse.uml2.uml.Class activity = ActivityUtils.getActivity(port.getClass_(), port);
      if ((activity == null)) {
        String _format = String.format("no activity is associated with port \'%s\' => cannot determine callback group", port.getName());
        throw new TransformationException(_format);
      }
      return CallbackGroups.callbackGroupName(activity);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }

  /**
   * Name of a callback group of a class representing an activity
   */
  public static String callbackGroupName(final org.eclipse.uml2.uml.Class activityCl) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("cbg_");
    String _name = activityCl.getName();
    _builder.append(_name);
    _builder.append("_");
    return _builder.toString();
  }

  /**
   * name of a callback group for a timer of an activity
   */
  public static String tCallbackGroupName(final org.eclipse.uml2.uml.Class activityCl) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("cbg_t_");
    String _name = activityCl.getName();
    _builder.append(_name);
    _builder.append("_");
    return _builder.toString();
  }
}
