/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.parameters.utils;

import org.eclipse.papyrus.robotics.parameters.utils.UMLPrimitiveTypesUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class ParameterTableUtils {
    public static boolean isProperty(Object modelElement) {
        return modelElement instanceof Property;
    }

    public static boolean hasDefaultValue(Property property) {
        return property.getDefaultValue() != null;
    }

    public static boolean isSlotValueAnOpaqueExpression(Slot slot) {
        if (slot != null && slot.getValues().size() == 1) {
            return slot.getValues().iterator().next() instanceof OpaqueExpression;
        }
        return false;
    }

    public static OpaqueExpression getSlotValue(Slot slot) {
        ValueSpecification specification;
        if (slot != null && slot.getValues().size() == 1 && (specification = (ValueSpecification)slot.getValues().iterator().next()) instanceof OpaqueExpression) {
            return (OpaqueExpression)specification;
        }
        return null;
    }

    public static ValueSpecification createValueSpecification(Element context, Slot slot, String value) {
        if (slot != null && slot.getDefiningFeature() != null && slot.getDefiningFeature().getType() != null) {
            Type type = slot.getDefiningFeature().getType();
            return ParameterTableUtils.createValueSpecification(context, type, value);
        }
        return null;
    }

    public static ValueSpecification createValueSpecification(Element context, Type type, String value) {
        LiteralInteger specification = null;
        if (type == UMLPrimitiveTypesUtils.getInteger(context)) {
            specification = UMLFactory.eINSTANCE.createLiteralInteger();
            Integer integerValue = null;
            try {
                integerValue = Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (integerValue != null) {
                specification.setValue(integerValue.intValue());
            }
        } else if (type == UMLPrimitiveTypesUtils.getBoolean(context)) {
            specification = UMLFactory.eINSTANCE.createLiteralBoolean();
            Boolean booleanValue = null;
            try {
                booleanValue = Boolean.parseBoolean(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (booleanValue != null) {
                ((LiteralBoolean)specification).setValue(booleanValue.booleanValue());
            }
        } else if (type == UMLPrimitiveTypesUtils.getUnlimitedNatural(context)) {
            specification = UMLFactory.eINSTANCE.createLiteralUnlimitedNatural();
            Integer integerValue = null;
            try {
                integerValue = Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (integerValue != null) {
                ((LiteralUnlimitedNatural)specification).setValue(integerValue.intValue());
            }
        } else if (type == UMLPrimitiveTypesUtils.getReal(context)) {
            specification = UMLFactory.eINSTANCE.createLiteralReal();
            Double doubleValue = null;
            try {
                doubleValue = Double.parseDouble(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (doubleValue != null) {
                ((LiteralReal)specification).setValue(doubleValue.doubleValue());
            }
        } else if (type == UMLPrimitiveTypesUtils.getString(context)) {
            specification = UMLFactory.eINSTANCE.createLiteralString();
            ((LiteralString)specification).setValue(value);
        } else {
            specification = UMLFactory.eINSTANCE.createOpaqueExpression();
            ((OpaqueExpression)specification).getLanguages().add((Object)"VSL");
            ((OpaqueExpression)specification).getBodies().add((Object)value);
        }
        return specification;
    }
}

