/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.faultinjection.ui.utils;

import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.robotics.faultinjection.FIElement;
import org.eclipse.papyrus.robotics.faultinjection.FaultList;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

public class FaultInjectionUtils {
    public static FaultList getFaultList(Element element) {
        Resource r = FaultInjectionUtils.getFaultInjectionResource((EObject)element);
        return FaultInjectionUtils.getFaultList(r);
    }

    public static FaultList getFaultList(Resource resource) {
        if (resource != null && resource.getContents().size() > 0 && resource.getContents().get(0) instanceof FaultList) {
            return (FaultList)resource.getContents().get(0);
        }
        return null;
    }

    public static List<FIElement> getFaultsFromPart(Property part) {
        FaultList fl = FaultInjectionUtils.getFaultList((Element)part.getModel());
        BasicEList faults = new BasicEList();
        if (fl != null) {
            for (FIElement fault : fl.getElements()) {
                if (fault.getComponent() != part) continue;
                faults.add(fault);
            }
        }
        return faults;
    }

    public static List<FIElement> getFaultsFromPort(Port port) {
        FaultList fl = FaultInjectionUtils.getFaultList((Element)port.getModel());
        BasicEList faults = new BasicEList();
        if (fl != null) {
            for (FIElement fault : fl.getElements()) {
                if (fault.getPort() != port) continue;
                faults.add(fault);
            }
        }
        return faults;
    }

    public static List<FIElement> getFaultsFromPartAndPort(Property part, Port port) {
        FaultList fl = FaultInjectionUtils.getFaultList((Element)port.getModel());
        BasicEList faults = new BasicEList();
        if (fl != null) {
            for (FIElement fault : fl.getElements()) {
                if (fault.getPort() != port || fault.getComponent() != part) continue;
                faults.add(fault);
            }
        }
        return faults;
    }

    public static Resource getFaultInjectionResource(EObject eObj) {
        if (eObj != null && eObj.eResource() != null) {
            ResourceSet rs = eObj.eResource().getResourceSet();
            for (Resource r : rs.getResources()) {
                if (FaultInjectionUtils.getFaultList(r) == null) continue;
                return r;
            }
        }
        return null;
    }

    public static void removeFaultInjectionResource(EObject eObj) {
        Resource r = FaultInjectionUtils.getFaultInjectionResource(eObj);
        if (r != null) {
            eObj.eResource().getResourceSet().getResources().remove((Object)r);
        }
    }
}

