/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.dashboard.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.robotics.dashboard.ui.extrasections.ExtraSectionsHelper;
import org.eclipse.papyrus.robotics.dashboard.ui.extrasections.IDashboardSection;
import org.eclipse.papyrus.robotics.dashboard.ui.pages.CompIntegrationVVPage;
import org.eclipse.papyrus.robotics.dashboard.ui.pages.ComponentDesignPage;
import org.eclipse.papyrus.robotics.dashboard.ui.pages.MissionDefinitionPage;
import org.eclipse.papyrus.robotics.dashboard.ui.pages.SystemIntegrationPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.osgi.framework.Bundle;

public class DashboardEditor
extends SharedHeaderFormEditor {
    public static final String ID = "org.eclipse.papyrus.robotics.dashboard.ui.editor";
    Map<String, Integer> pageIdToPageIndexMap = new HashMap<String, Integer>();

    protected void addPages() {
        this.createGlobalPage();
        this.createPage1();
        this.createPage2();
        this.createPage3();
        this.createPage4();
        List<IDashboardSection> extraSections = ExtraSectionsHelper.getAllExtraDashboardSections();
        for (IDashboardSection extraSection : extraSections) {
            String pageID = extraSection.getExtendedPageID();
            Integer index = this.pageIdToPageIndexMap.get(pageID);
            if (index == null) {
                System.err.println(String.format("Extra section for P4R Dashboard: %s not found", pageID));
                continue;
            }
            final ScrolledForm composite = (ScrolledForm)this.pages.get(index);
            FormToolkit toolkit = new FormToolkit(composite.getDisplay());
            Section section = toolkit.createSection(composite.getBody(), 450);
            TableWrapData td = new TableWrapData(256);
            td.colspan = 2;
            section.setLayoutData((Object)td);
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    composite.reflow(true);
                }
            });
            section.setText(extraSection.getName());
            section.setDescription(extraSection.getDescription());
            Composite sectionClient = toolkit.createComposite((Composite)section);
            sectionClient.setLayout((Layout)new GridLayout());
            extraSection.createComposite(sectionClient);
            section.setClient((Control)sectionClient);
        }
    }

    private void createPage1() {
        MissionDefinitionPage page = new MissionDefinitionPage();
        int index = this.addPage((Control)page.getPageBody(this.getContainer()));
        this.setPageText(index, "Robot Mission Definition");
        this.pageIdToPageIndexMap.put("Robot Mission Definition", index);
    }

    private void createPage2() {
        ComponentDesignPage page = new ComponentDesignPage();
        int index = this.addPage((Control)page.getPageBody(this.getContainer()));
        this.setPageText(index, "Component Design");
        this.pageIdToPageIndexMap.put("Component Design", index);
    }

    private void createPage3() {
        SystemIntegrationPage page = new SystemIntegrationPage();
        int index = this.addPage((Control)page.getPageBody(this.getContainer()));
        this.setPageText(index, "System Composition");
        this.pageIdToPageIndexMap.put("System Composition", index);
    }

    private void createPage4() {
        CompIntegrationVVPage page = new CompIntegrationVVPage();
        int index = this.addPage((Control)page.getPageBody(this.getContainer()));
        this.setPageText(index, "Validation && Verification");
        this.pageIdToPageIndexMap.put("Validation && Verification", index);
    }

    private void createGlobalPage() {
        FormToolkit toolkit = new FormToolkit(this.getContainer().getDisplay());
        ScrolledForm composite = toolkit.createScrolledForm(this.getContainer());
        composite.setText("Papyrus for Robotics Compositional Development Process");
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        composite.getBody().setLayout((Layout)layout);
        toolkit.createLabel(composite.getBody(), "");
        toolkit.createLabel(composite.getBody(), "");
        ImageHyperlink goTo1 = toolkit.createImageHyperlink(composite.getBody(), 0x1000000);
        String path = "icons/robotics_mision.png";
        Bundle bundle = Platform.getBundle((String)"org.eclipse.papyrus.robotics.dashboard.ui");
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        ImageDescriptor imageDesc = ImageDescriptor.createFromURL((URL)url);
        Image goTo1Image = imageDesc.createImage();
        goTo1.setImage(goTo1Image);
        goTo1.setText("Robot Mission Definition");
        goTo1.setUnderlined(false);
        goTo1.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DashboardEditor.this.setActivePage(1);
            }
        });
        toolkit.createLabel(composite.getBody(), "Define the services and skills the robot should perform to execute a mission", 64);
        toolkit.createLabel(composite.getBody(), "");
        toolkit.createLabel(composite.getBody(), "");
        ImageHyperlink goTo2 = toolkit.createImageHyperlink(composite.getBody(), 64);
        String path2 = "icons/robotics_component.png";
        URL url2 = FileLocator.find((Bundle)bundle, (IPath)new Path(path2), null);
        ImageDescriptor imageDesc2 = ImageDescriptor.createFromURL((URL)url2);
        Image goTo2Image = imageDesc2.createImage();
        goTo2.setImage(goTo2Image);
        goTo2.setText("Component Design");
        goTo2.setUnderlined(false);
        goTo2.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DashboardEditor.this.setActivePage(2);
            }
        });
        toolkit.createLabel(composite.getBody(), "A component supplier (Tier 3) creates software components as units of composition that provide or require services (service-level) and contain functions. He/she models the component by using service definitions and functions. Implement a skill that lifts the abstraction of a component from the service level to the task level", 64);
        toolkit.createLabel(composite.getBody(), "");
        toolkit.createLabel(composite.getBody(), "");
        ImageHyperlink goTo3 = toolkit.createImageHyperlink(composite.getBody(), 64);
        String path3 = "icons/robotics_system.png";
        URL url3 = FileLocator.find((Bundle)bundle, (IPath)new Path(path3), null);
        ImageDescriptor imageDesc3 = ImageDescriptor.createFromURL((URL)url3);
        Image goTo3Image = imageDesc3.createImage();
        goTo3.setImage(goTo3Image);
        goTo3.setText("System Composition");
        goTo3.setUnderlined(false);
        goTo3.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DashboardEditor.this.setActivePage(3);
            }
        });
        toolkit.createLabel(composite.getBody(), "Define the scope of the system, define the system Architecture, elicit system assertion", 64);
        toolkit.createLabel(composite.getBody(), "");
        toolkit.createLabel(composite.getBody(), "");
        ImageHyperlink goTo4 = toolkit.createImageHyperlink(composite.getBody(), 64);
        String path4 = "icons/robotics_VV.png";
        URL url4 = FileLocator.find((Bundle)bundle, (IPath)new Path(path4), null);
        ImageDescriptor imageDesc4 = ImageDescriptor.createFromURL((URL)url4);
        Image goTo4Image = imageDesc4.createImage();
        goTo4.setImage(goTo4Image);
        goTo4.setText("Validation & Verification");
        goTo4.setUnderlined(false);
        goTo4.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DashboardEditor.this.setActivePage(4);
            }
        });
        toolkit.createLabel(composite.getBody(), "Validate component Contracts and execute Safety/Security Analyses", 64);
        int index = this.addPage((Control)composite);
        this.setPageText(index, "Global View");
        this.setPageImage(index, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_HOME_NAV"));
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

