/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.codegen.common.utils;

import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.designer.languages.common.base.StdUriConstants;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.External;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class Helpers {
    public static Type getUMLPrimitiveType(Element element, String qualifiedName) {
        return Helpers.getTypeFromRS(element, StdUriConstants.UML_PRIM_TYPES_URI, qualifiedName, true);
    }

    public static Type getTypeFromRS(Element element, URI resourceURI, String qualifiedName, boolean needCopy) {
        NamedElement ne = ElementUtils.getQualifiedElementFromRS((Element)element, (URI)resourceURI, (String)qualifiedName);
        if (needCopy) {
            ne = (NamedElement)TransformationContext.current.copier.getCopy((Element)ne);
        }
        if (ne instanceof Type) {
            return (Type)ne;
        }
        return null;
    }

    public static String externalName(Type type) {
        if (type != null) {
            External external = (External)UMLUtil.getStereotypeApplication((Element)type, External.class);
            if (external != null) {
                return external.getName();
            }
            return type.getQualifiedName();
        }
        return null;
    }

    public static void useSharedPtr(TypedElement typedElement) {
        Ptr ptr = (Ptr)StereotypeUtil.applyApp((Element)typedElement, Ptr.class);
        ptr.setDeclaration("::SharedPtr");
    }
}

