/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.languages.stl.ui.contribution;

import com.google.inject.Injector;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.assignments;
import org.eclipse.papyrus.robotics.assertions.languages.stl.ui.internal.StlActivator;
import org.eclipse.papyrus.uml.xtext.integration.AbstractXtextDirectEditorConfiguration;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.OpaqueExpression;

public class STLEditorConfigurationContribution
extends AbstractXtextDirectEditorConfiguration
implements ICustomDirectEditorConfiguration {
    OpaqueExpression oe;

    public Object preEditAction(Object objectToEdit) {
        Constraint c;
        if (objectToEdit instanceof Constraint && (c = (Constraint)objectToEdit).getSpecification() instanceof OpaqueExpression) {
            this.oe = (OpaqueExpression)c.getSpecification();
        }
        return super.preEditAction(objectToEdit);
    }

    public int getStyle() {
        return 66;
    }

    public String getTextToEdit(Object editedObject) {
        if (this.oe != null) {
            return (String)this.oe.getBodies().get(0);
        }
        return "not an opaque expression";
    }

    public Injector getInjector() {
        return StlActivator.getInstance().getInjector("org.eclipse.papyrus.robotics.assertions.languages.stl.STL");
    }

    public ICommand getParseCommand(EObject modelObject, EObject xtextObject) {
        if (!(modelObject instanceof OpaqueExpression)) {
            return null;
        }
        assignments stlText = (assignments)xtextObject;
        TransactionalEditingDomain dom = TransactionUtil.getEditingDomain((EObject)this.oe);
        UpdateComponentCommand updateCommand = new UpdateComponentCommand(dom, stlText);
        return updateCommand;
    }

    protected class UpdateComponentCommand
    extends AbstractTransactionalCommand {
        private Class clazz;
        private assignments stlText;

        public UpdateComponentCommand(TransactionalEditingDomain domain, assignments stlText) {
            super(domain, "Update component", UpdateComponentCommand.getWorkspaceFiles((EObject)STLEditorConfigurationContribution.this.oe));
            this.stlText = stlText;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            return CommandResult.newOKCommandResult((Object)this.clazz);
        }
    }
}

