/*
 * generated by Xtext 2.27.0
 */
package org.eclipse.papyrus.robotics.assertions.languages.stl.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.robotics.assertions.languages.stl.services.STLGrammarAccess;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.StlTextPackage;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.assignment;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.assignments;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.expression;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.expression_cont;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.expression_start;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.interval;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.num_literal;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.real_expression;
import org.eclipse.papyrus.robotics.assertions.languages.stl.stlText.real_expression_nl;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class STLSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private STLGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == StlTextPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case StlTextPackage.ASSIGNMENT:
				sequence_assignment(context, (assignment) semanticObject); 
				return; 
			case StlTextPackage.ASSIGNMENTS:
				sequence_assignments(context, (assignments) semanticObject); 
				return; 
			case StlTextPackage.EXPRESSION:
				sequence_expression(context, (expression) semanticObject); 
				return; 
			case StlTextPackage.EXPRESSION_CONT:
				sequence_expression_cont(context, (expression_cont) semanticObject); 
				return; 
			case StlTextPackage.EXPRESSION_START:
				sequence_expression_start(context, (expression_start) semanticObject); 
				return; 
			case StlTextPackage.INTERVAL:
				sequence_interval(context, (interval) semanticObject); 
				return; 
			case StlTextPackage.NUM_LITERAL:
				sequence_num_literal(context, (num_literal) semanticObject); 
				return; 
			case StlTextPackage.REAL_EXPRESSION:
				sequence_real_expression(context, (real_expression) semanticObject); 
				return; 
			case StlTextPackage.REAL_EXPRESSION_NL:
				sequence_real_expression_nl(context, (real_expression_nl) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * <pre>
	 * Contexts:
	 *     assignment returns assignment
	 *
	 * Constraint:
	 *     (id=Identifier expr=expression)
	 * </pre>
	 */
	protected void sequence_assignment(ISerializationContext context, assignment semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, StlTextPackage.Literals.ASSIGNMENT__ID) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, StlTextPackage.Literals.ASSIGNMENT__ID));
			if (transientValues.isValueTransient(semanticObject, StlTextPackage.Literals.ASSIGNMENT__EXPR) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, StlTextPackage.Literals.ASSIGNMENT__EXPR));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getAssignmentAccess().getIdIdentifierTerminalRuleCall_0_0(), semanticObject.getId());
		feeder.accept(grammarAccess.getAssignmentAccess().getExprExpressionParserRuleCall_2_0(), semanticObject.getExpr());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     assignments returns assignments
	 *
	 * Constraint:
	 *     assignments+=assignment+
	 * </pre>
	 */
	protected void sequence_assignments(ISerializationContext context, assignments semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression_cont returns expression_cont
	 *
	 * Constraint:
	 *     (
	 *         (i=interval? e=expression) | 
	 *         (i=interval? e=expression) | 
	 *         (i=interval? e=expression) | 
	 *         (i=interval? e=expression) | 
	 *         e=expression | 
	 *         e=expression | 
	 *         e=expression | 
	 *         e=expression | 
	 *         e=expression | 
	 *         e=expression | 
	 *         e=expression | 
	 *         e=expression_cont | 
	 *         e=expression | 
	 *         e=expression | 
	 *         e=expression
	 *     )
	 * </pre>
	 */
	protected void sequence_expression_cont(ISerializationContext context, expression_cont semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression returns expression
	 *
	 * Constraint:
	 *     (first=expression_start ec=expression_cont?)
	 * </pre>
	 */
	protected void sequence_expression(ISerializationContext context, expression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression_start returns expression_start
	 *
	 * Constraint:
	 *     (r=real_expression | (e1=real_expression e2=real_expression))
	 * </pre>
	 */
	protected void sequence_expression_start(ISerializationContext context, expression_start semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     interval returns interval
	 *
	 * Constraint:
	 *     (time1=intervalTime time2=intervalTime)
	 * </pre>
	 */
	protected void sequence_interval(ISerializationContext context, interval semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, StlTextPackage.Literals.INTERVAL__TIME1) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, StlTextPackage.Literals.INTERVAL__TIME1));
			if (transientValues.isValueTransient(semanticObject, StlTextPackage.Literals.INTERVAL__TIME2) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, StlTextPackage.Literals.INTERVAL__TIME2));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getIntervalAccess().getTime1IntervalTimeParserRuleCall_1_0(), semanticObject.getTime1());
		feeder.accept(grammarAccess.getIntervalAccess().getTime2IntervalTimeParserRuleCall_3_0(), semanticObject.getTime2());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     num_literal returns num_literal
	 *     intervalTime returns num_literal
	 *
	 * Constraint:
	 *     (ilit=IntegerLiteral | rlit=RealLiteral | lit=num_literal)
	 * </pre>
	 */
	protected void sequence_num_literal(ISerializationContext context, num_literal semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     real_expression_nl returns real_expression_nl
	 *
	 * Constraint:
	 *     (exp=real_expression | exp=real_expression | exp=real_expression | exp=real_expression)
	 * </pre>
	 */
	protected void sequence_real_expression_nl(ISerializationContext context, real_expression_nl semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     real_expression returns real_expression
	 *
	 * Constraint:
	 *     (
	 *         id=Identifier | 
	 *         lit=num_literal | 
	 *         exp=real_expression | 
	 *         exp=real_expression | 
	 *         exp=real_expression | 
	 *         (exp1=real_expression exp2=real_expression)
	 *     )
	 * </pre>
	 */
	protected void sequence_real_expression(ISerializationContext context, real_expression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
}
