/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.breakpoint.commands;

import java.util.Collections;
import javax.sound.sampled.Port;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.moka.tracepoint.service.Activator;
import org.eclipse.papyrus.moka.tracepoint.service.ITraceMechanism;
import org.eclipse.papyrus.moka.tracepoint.service.TraceActions;
import org.eclipse.papyrus.moka.tracepoint.service.TraceMechanism;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.State;

public abstract class AbstractTraceAndDebugCommand
extends AbstractTransactionalCommand {
    protected TransactionalEditingDomain domain;
    protected EObject selectedElement;
    protected Resource resource;
    protected IResource iresource;
    protected String uri;

    public AbstractTraceAndDebugCommand(String label, TransactionalEditingDomain domain, EObject selectedElement) {
        super(domain, label, Collections.EMPTY_LIST);
        this.domain = domain;
        this.selectedElement = selectedElement;
    }

    protected void updateResourceAndURI() {
        this.resource = this.selectedElement.eResource();
        this.uri = this.resource.getURI() + "#" + this.resource.getURIFragment(this.selectedElement);
        this.iresource = WorkspaceSynchronizer.getFile((Resource)this.selectedElement.eResource());
    }

    protected IMarker findMarker(String type) {
        if (this.iresource != null) {
            try {
                IMarker[] iMarkerArray = this.iresource.findMarkers(type, false, 2);
                int n = iMarkerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    String markerURI = marker.getAttribute("uri", "");
                    if (markerURI != null && markerURI.equals(this.uri)) {
                        return marker;
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    protected IMarker toggleMarker() {
        try {
            if (this.iresource != null) {
                IMarker marker = this.findMarker("org.eclipse.papyrus.tracepointmarker");
                if (marker == null) {
                    marker = this.iresource.createMarker("org.eclipse.papyrus.tracepointmarker");
                    marker.setAttribute("uri", (Object)this.uri);
                    marker.setAttribute("isActive", true);
                    marker.setAttribute("isTracepoint", true);
                    marker.setAttribute("traceAction", (Object)TraceActions.actionFromPreferences((EObject)this.selectedElement));
                    marker.setAttribute("traceMechanism", (Object)TraceMechanism.getDefaultMechanism((EObject)this.selectedElement));
                    IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                    String id = null;
                    if (this.selectedElement instanceof Operation) {
                        id = store.getDefaultString("papyrus.trace.implementation.op");
                    } else if (this.selectedElement instanceof Port) {
                        id = store.getDefaultString("papyrus.trace.implementation.port");
                    } else if (this.selectedElement instanceof State) {
                        id = store.getDefaultString("papyrus.trace.implementation.sm");
                    }
                    if (id != null) {
                        for (ITraceMechanism mechanism : TraceMechanism.getTraceMechanisms()) {
                            for (String providedID : mechanism.getTraceMechanismIDs(this.selectedElement)) {
                                if (!id.equals(providedID)) continue;
                                mechanism.applyTraceMechanism(this.selectedElement, id, 0);
                            }
                        }
                    }
                    return marker;
                }
                marker.delete();
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    protected void toggleMarkerActivation() {
        try {
            if (this.iresource != null) {
                IMarker marker = this.findMarker("org.eclipse.papyrus.tracepointmarker");
                if (marker == null) {
                    marker = this.toggleMarker();
                } else {
                    boolean isSet = marker.getAttribute("isActive", false);
                    marker.setAttribute("isActive", !isSet);
                }
            }
        }
        catch (CoreException ce) {
            throw new RuntimeException(ce);
        }
    }

    public boolean canExecute() {
        return this.selectedElement != null;
    }
}

