/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.target;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.papyrus.moka.debug.engine.IDebuggableExecutionEngine;
import org.eclipse.papyrus.moka.debug.engine.IDebuggableExecutionEngineThread;
import org.eclipse.papyrus.moka.debug.target.ExecutionEngineDebugElement;
import org.eclipse.papyrus.moka.debug.target.IExecutionEngineDebugTarget;
import org.eclipse.papyrus.moka.debug.target.IExecutionEngineThread;
import org.eclipse.papyrus.moka.utils.helper.semantics.SemanticHelper;

public class ExecutionEngineStackFrame
extends ExecutionEngineDebugElement
implements IStackFrame {
    protected IExecutionEngineThread thread;

    public ExecutionEngineStackFrame(IExecutionEngineThread t) {
        super(t.getDebugTarget());
        this.thread = t;
    }

    private IDebuggableExecutionEngine<?, ?> getExecutionEngine() {
        IExecutionEngineDebugTarget target = (IExecutionEngineDebugTarget)this.getDebugTarget();
        if (target != null) {
            return target.getExecutionEngine();
        }
        return null;
    }

    public boolean canStepInto() {
        return this.thread.canStepInto();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.thread.canStepReturn();
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        IDebuggableExecutionEngineThread<?, ?> debuggableThread;
        IDebuggableExecutionEngine<?, ?> engine = this.getExecutionEngine();
        if (engine != null && (debuggableThread = engine.getThread(this.thread.getID())) != null) {
            return debuggableThread.getVariables(this.getDebugTarget()).toArray(new IVariable[0]);
        }
        return new IVariable[0];
    }

    public boolean hasVariables() throws DebugException {
        IDebuggableExecutionEngine<?, ?> engine = this.getExecutionEngine();
        if (engine != null) {
            return engine.getThread(this.thread.getID()) != null;
        }
        return false;
    }

    public int getLineNumber() throws DebugException {
        return 0;
    }

    public int getCharStart() throws DebugException {
        return 0;
    }

    public int getCharEnd() throws DebugException {
        return 0;
    }

    public String getName() throws DebugException {
        IDebuggableExecutionEngineThread<?, ?> debuggableThread;
        IDebuggableExecutionEngine<?, ?> engine = this.getExecutionEngine();
        if (engine != null && (debuggableThread = engine.getThread(this.thread.getID())) != null) {
            return SemanticHelper.getName(debuggableThread.getSuspensionContext());
        }
        return null;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }
}

