/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine.uml.scheduling;

import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.papyrus.moka.engine.uml.scheduling.UMLTaskExecution;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IClassifierBehaviorInvocationEventAccepter;
import org.eclipse.papyrus.moka.fuml.commonbehavior.IObjectActivation;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IObject_;
import org.eclipse.papyrus.moka.fuml.tasks.IUMLEventDispatchLoopExecution;
import org.eclipse.papyrus.moka.kernel.scheduling.control.IExecutionLoop;
import org.eclipse.papyrus.moka.kernel.scheduling.execution.ITaskExecution;

public class UMLEventDispatchLoopTaskExecution
extends UMLTaskExecution
implements IUMLEventDispatchLoopExecution {
    protected IObjectActivation dispatchLoop;
    protected ReentrantLock dispatchLoopLock = new ReentrantLock(true);
    private int signalCount = 0;
    private ReentrantLock signalCountLock = new ReentrantLock(true);

    public UMLEventDispatchLoopTaskExecution(IExecutionLoop loop) {
        super(loop);
    }

    public boolean canExecute() {
        boolean canExecute = false;
        if (!this.dispatchLoopLock.isHeldByCurrentThread()) {
            this.dispatchLoopLock.lock();
        }
        boolean bl = canExecute = this.dispatchLoop != null;
        if (this.dispatchLoopLock.isHeldByCurrentThread()) {
            this.dispatchLoopLock.unlock();
        }
        return canExecute;
    }

    public void newSignalArrival() {
        if (!this.signalCountLock.isHeldByCurrentThread()) {
            this.signalCountLock.lock();
        }
        ++this.signalCount;
        if (this.signalCount == 1) {
            this.schedule();
        }
        if (this.signalCountLock.isHeldByCurrentThread()) {
            this.signalCountLock.unlock();
        }
    }

    public void dispatchNextEvent() {
        if (!this.dispatchLoopLock.isHeldByCurrentThread()) {
            this.dispatchLoopLock.lock();
        }
        try {
            try {
                this.dispatchLoop.dispatchNextEvent();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.dispatchLoopLock.isHeldByCurrentThread()) {
                    this.dispatchLoopLock.unlock();
                }
            }
        }
        finally {
            if (this.dispatchLoopLock.isHeldByCurrentThread()) {
                this.dispatchLoopLock.unlock();
            }
        }
    }

    public void execute() {
        this.dispatchNextEvent();
        if (!this.signalCountLock.isHeldByCurrentThread()) {
            this.signalCountLock.lock();
        }
        --this.signalCount;
        if (this.signalCount > 0) {
            this.executionLoop.include((ITaskExecution)this);
        }
        if (this.signalCountLock.isHeldByCurrentThread()) {
            this.signalCountLock.unlock();
        }
    }

    @Override
    public IValue new_() {
        UMLEventDispatchLoopTaskExecution dispatchLoopExecution = new UMLEventDispatchLoopTaskExecution(this.executionLoop);
        dispatchLoopExecution.dispatchLoop = this.dispatchLoop;
        return dispatchLoopExecution;
    }

    public String toString() {
        return "EventDispatchLoopExecution(" + this.dispatchLoop + ")";
    }

    @Override
    public void suspend() {
        if (!this.dispatchLoopLock.isHeldByCurrentThread()) {
            this.dispatchLoopLock.lock();
        }
        for (IClassifierBehaviorInvocationEventAccepter cbInvocation : this.dispatchLoop.getClassifierBehaviorInvocations()) {
            cbInvocation.getExecution();
        }
        if (this.dispatchLoopLock.isHeldByCurrentThread()) {
            this.dispatchLoopLock.unlock();
        }
    }

    @Override
    public void resume() {
    }

    @Override
    public void terminate() {
        if (!this.dispatchLoopLock.isHeldByCurrentThread()) {
            this.dispatchLoopLock.lock();
        }
        this.dispatchLoopLock.lock();
        IObject_ context = this.getContext();
        if (context != null) {
            context.destroy();
        }
        this.dispatchLoop = null;
        if (this.dispatchLoopLock.isHeldByCurrentThread()) {
            this.dispatchLoopLock.unlock();
        }
    }

    @Override
    public void setObjectActivation(IObjectActivation objectActivation) {
        if (!this.dispatchLoopLock.isHeldByCurrentThread()) {
            this.dispatchLoopLock.lock();
        }
        this.dispatchLoop = objectActivation;
        if (this.dispatchLoopLock.isHeldByCurrentThread()) {
            this.dispatchLoopLock.unlock();
        }
    }

    @Override
    public IObject_ getContext() {
        IObject_ context = null;
        if (!this.dispatchLoopLock.isHeldByCurrentThread()) {
            this.dispatchLoopLock.lock();
        }
        if (this.dispatchLoop != null) {
            context = this.dispatchLoop.getObject();
        }
        if (this.dispatchLoopLock.isHeldByCurrentThread()) {
            this.dispatchLoopLock.unlock();
        }
        return context;
    }
}

