/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.jdt.project.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.JavaProjectWizard;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizard;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.AbstractSettings;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangProjectSupport;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.MavenProject;
import org.eclipse.papyrus.designer.languages.java.jdt.project.Messages;
import org.eclipse.papyrus.designer.languages.java.jdt.project.ui.CustomizePOMFile;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class JavaProjectSupport
implements ILangProjectSupport {
    private int dialogStatus;
    private MavenProject mavenProjectDetails;
    protected String LAST_MODULE_NFO = "org.eclipse.jdt.ui.last.selected.create.moduleinfo";

    public IProject createProject(final String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        this.dialogStatus = 0;
        try {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    boolean changePrefs;
                    boolean useSrcBin = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects");
                    if (!useSrcBin && (changePrefs = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Java preference", (String)Messages.JavaProjectSupport_PREF_WARN))) {
                        PreferenceConstants.getPreferenceStore().setValue("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects", true);
                    }
                    JavaProjectWizard wiz = new JavaProjectWizard();
                    wiz.init(PlatformUI.getWorkbench(), null);
                    WizardDialog wizDiag = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wiz);
                    wizDiag.create();
                    IDialogSettings ds = JavaPlugin.getDefault().getDialogSettings();
                    ds.put(JavaProjectSupport.this.LAST_MODULE_NFO, false);
                    IWizardPage page = wiz.getPages()[0];
                    if (page instanceof NewJavaProjectWizardPageOne) {
                        ((NewJavaProjectWizardPageOne)page).setProjectName(projectName);
                    }
                    JavaProjectSupport.this.dialogStatus = wizDiag.open();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            project = null;
        }
        if (this.dialogStatus == 1) {
            return null;
        }
        if (project == null || !project.exists()) {
            throw new RuntimeException(Messages.JavaProjectSupport_COULD_NOT_CREATE);
        }
        return project;
    }

    public IProject createProject(String projectName, Package modelRoot) {
        this.mavenProjectDetails = (MavenProject)UMLUtil.getStereotypeApplication((Element)modelRoot, MavenProject.class);
        if (this.mavenProjectDetails == null) {
            return this.createProject(projectName);
        }
        return this.createMavenProject(projectName);
    }

    @Deprecated
    protected IProject createMavenProject(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            final MavenProjectWizard mavenWiz = new MavenProjectWizard();
            mavenWiz.setWindowTitle(projectName);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbench wb = PlatformUI.getWorkbench();
                    mavenWiz.init(wb, (IStructuredSelection)new StructuredSelection());
                    Shell shell = wb.getActiveWorkbenchWindow().getShell();
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)mavenWiz);
                    dialog.create();
                    dialog.open();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IProject project = root.getProject(projectName);
        return project;
    }

    public void setSettings(IProject project, AbstractSettings settings) {
        if (project != null && this.mavenProjectDetails != null) {
            CustomizePOMFile customizePOMFile = new CustomizePOMFile(project, this.mavenProjectDetails);
            customizePOMFile.execute();
        }
    }

    public AbstractSettings initialConfigurationData() {
        return null;
    }

    public void gatherConfigData(Classifier implementation, AbstractSettings settings) {
    }
}

