/**
 * Copyright (c) 2022, 2024 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 *     Ansgar Radermacher - [4] Pre-pragma content is used for post-pragma
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.xtend;

import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Pragma;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.PragmaOption;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.util.UMLUtil;

/**
 * Get a pragma pre or post declaration from a pragma reference.
 * The reference points to a class stereotyped with PragmaOption
 */
@SuppressWarnings("all")
public class CppPragma {
  public static String prePragma(final Classifier cl) {
    final Pragma pragmaRef = UMLUtil.<Pragma>getStereotypeApplication(cl, Pragma.class);
    if ((pragmaRef != null)) {
      final PragmaOption option = pragmaRef.getPragma();
      if ((option != null)) {
        return option.getPreDecl();
      }
    }
    return "";
  }

  public static String postPragma(final Classifier cl) {
    final Pragma pragmaRef = UMLUtil.<Pragma>getStereotypeApplication(cl, Pragma.class);
    if ((pragmaRef != null)) {
      final PragmaOption option = pragmaRef.getPragma();
      if ((option != null)) {
        return option.getPostDecl();
      }
    }
    return "";
  }
}
