/**
 * Copyright (c) 2014 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.xtend;

import com.google.common.collect.Iterables;
import java.util.Objects;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * @author Önder GÜRCAN (onder.gurcan@cea.fr)
 */
@SuppressWarnings("all")
public class CppClassOperationsDeclaration {
  public static CharSequence CppClassOperationsDeclaration(final Classifier clazz, final VisibilityKind visibilityFilter) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<Operation, Boolean> _function = (Operation it) -> {
        VisibilityKind _visibility = it.getVisibility();
        return Boolean.valueOf(Objects.equals(_visibility, visibilityFilter));
      };
      Iterable<Operation> _filter = IterableExtensions.<Operation>filter(CppOperations.getOwnedOperations(clazz), _function);
      for(final Operation op : _filter) {
        _builder.newLine();
        CharSequence _CppOperationDeclaration = CppOperations.CppOperationDeclaration(op);
        _builder.append(_CppOperationDeclaration);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      final Function1<OpaqueBehavior, Boolean> _function_1 = (OpaqueBehavior it) -> {
        VisibilityKind _visibility = it.getVisibility();
        return Boolean.valueOf(Objects.equals(_visibility, visibilityFilter));
      };
      Iterable<OpaqueBehavior> _filter_1 = IterableExtensions.<OpaqueBehavior>filter(Iterables.<OpaqueBehavior>filter(clazz.getOwnedMembers(), OpaqueBehavior.class), _function_1);
      for(final OpaqueBehavior ob : _filter_1) {
        {
          BehavioralFeature _specification = ob.getSpecification();
          boolean _tripleEquals = (_specification == null);
          if (_tripleEquals) {
            _builder.append("// opaque behavior without specification");
            _builder.newLine();
            CharSequence _CppBehaviorDeclaration = CppOperations.CppBehaviorDeclaration(clazz, ob);
            _builder.append(_CppBehaviorDeclaration);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
}
