/**
 * Copyright (c) 2014, 2019 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.xtend;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.cpp.codegen.preferences.CppCodeGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.Modifier;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/**
 * @author Önder GÜRCAN (onder.gurcan@cea.fr)
 */
@SuppressWarnings("all")
public class CppAttribute {
  public static String CppStaticAttributes(final Classifier classifier) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// static attributes (if any)");
    _builder.newLine();
    {
      Collection<Property> _ownedAttributes = CppAttribute.getOwnedAttributes(classifier);
      for(final Property ownedAttribute : _ownedAttributes) {
        {
          boolean _isStatic = ownedAttribute.isStatic();
          if (_isStatic) {
            CharSequence _CppStaticAttributeImplementation = CppAttribute.CppStaticAttributeImplementation(ownedAttribute);
            _builder.append(_CppStaticAttributeImplementation);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    String code = _builder.toString();
    return code;
  }

  public static Collection<Property> getOwnedAttributes(final Classifier cl) {
    Collection<Property> _xblockexpression = null;
    {
      final EList<Property> attributes = CppAttribute.getOwnedAttributesWNull(cl);
      Collection<Property> _xifexpression = null;
      if ((attributes == null)) {
        _xifexpression = CollectionLiterals.<Property>emptySet();
      } else {
        _xifexpression = attributes;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  public static EList<Property> getOwnedAttributesWNull(final Classifier cl) {
    EList<Property> _xifexpression = null;
    if ((cl instanceof org.eclipse.uml2.uml.Class)) {
      _xifexpression = ((org.eclipse.uml2.uml.Class) cl).getOwnedAttributes();
    } else {
      EList<Property> _xifexpression_1 = null;
      if ((cl instanceof DataType)) {
        _xifexpression_1 = ((DataType) cl).getOwnedAttributes();
      } else {
        EList<Property> _xifexpression_2 = null;
        if ((cl instanceof Interface)) {
          _xifexpression_2 = ((Interface) cl).getOwnedAttributes();
        } else {
          EList<Property> _xifexpression_3 = null;
          if ((cl instanceof Signal)) {
            _xifexpression_3 = ((Signal) cl).getOwnedAttributes();
          } else {
            _xifexpression_3 = null;
          }
          _xifexpression_2 = _xifexpression_3;
        }
        _xifexpression_1 = _xifexpression_2;
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }

  public static CharSequence CppStaticAttributeImplementation(final Property attribute) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _CppElementDoc = CppDocumentation.CppElementDoc(attribute);
    _builder.append(_CppElementDoc);
    _builder.newLineIfNotEmpty();
    String _modCVQualifier = Modifier.modCVQualifier(attribute);
    _builder.append(_modCVQualifier);
    String _cppType = CppTypedElement.cppType(attribute);
    _builder.append(_cppType);
    String _modPtr = Modifier.modPtr(attribute);
    _builder.append(_modPtr);
    String _modRef = Modifier.modRef(attribute);
    _builder.append(_modRef);
    _builder.append("  ");
    String _name = attribute.getClass_().getName();
    _builder.append(_name);
    _builder.append("::");
    String _name_1 = attribute.getName();
    _builder.append(_name_1);
    String _modArray = Modifier.modArray(attribute);
    _builder.append(_modArray);
    String _defaultValue = CppAttribute.defaultValue(attribute, true);
    _builder.append(_defaultValue);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  /**
   * create a default-value assignment, optionally for static values
   */
  public static String defaultValue(final Property attribute, final boolean forStatic) {
    String _xifexpression = null;
    if ((((attribute.getDefaultValue() != null) && (CppAttribute.textValue(attribute.getDefaultValue()) != null)) && 
      (attribute.isStatic() == forStatic))) {
      String _textValue = CppAttribute.textValue(attribute.getDefaultValue());
      _xifexpression = ("=" + _textValue);
    }
    return _xifexpression;
  }

  public static CharSequence CppAttributeDeclaration(final Property attribute) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    CharSequence _CppElementDoc = CppDocumentation.CppElementDoc(attribute);
    _builder.append(_CppElementDoc);
    _builder.newLineIfNotEmpty();
    String _staticValue = CppAttribute.staticValue(attribute);
    _builder.append(_staticValue);
    String _modCVQualifier = Modifier.modCVQualifier(attribute);
    _builder.append(_modCVQualifier);
    String _cppType = CppTypedElement.cppType(attribute);
    _builder.append(_cppType);
    String _modPtr = Modifier.modPtr(attribute);
    _builder.append(_modPtr);
    String _modRef = Modifier.modRef(attribute);
    _builder.append(_modRef);
    _builder.append(" ");
    String _name = attribute.getName();
    _builder.append(_name);
    String _modArray = Modifier.modArray(attribute);
    _builder.append(_modArray);
    String _defaultValue = CppAttribute.defaultValue(attribute, false);
    _builder.append(_defaultValue);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public static String staticValue(final Property attribute) {
    String _xifexpression = null;
    boolean _isStatic = attribute.isStatic();
    if (_isStatic) {
      _xifexpression = "static ";
    }
    return _xifexpression;
  }

  /**
   * Similar to UML's stringValue, but with a particular handling of
   * enumerations
   */
  public static String textValue(final ValueSpecification value) {
    if ((value instanceof InstanceValue)) {
      final InstanceValue iv = ((InstanceValue) value);
      InstanceSpecification _instance = iv.getInstance();
      if ((_instance instanceof EnumerationLiteral)) {
        InstanceSpecification _instance_1 = iv.getInstance();
        final EnumerationLiteral literal = ((EnumerationLiteral) _instance_1);
        boolean _c11ClassEnum = CppCodeGenUtils.getC11ClassEnum(literal.getEnumeration());
        if (_c11ClassEnum) {
          String _cppQualifiedName = CppGenUtils.cgu(value).cppQualifiedName(literal.getEnumeration());
          String _plus = (_cppQualifiedName + Namespace.SEPARATOR);
          String _name = literal.getName();
          return (_plus + _name);
        } else {
          String _cppQualifiedName_1 = CppGenUtils.cgu(value).cppQualifiedName(literal.getEnumeration().getNamespace());
          String _plus_1 = (_cppQualifiedName_1 + Namespace.SEPARATOR);
          String _name_1 = literal.getName();
          return (_plus_1 + _name_1);
        }
      }
    }
    return value.stringValue();
  }
}
