/**
 * Copyright (c) 2015 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.c.codegen.header;

import com.google.common.collect.Iterables;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.ClassScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.CommonScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.DataTypeScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.FunctionScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.ImportScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.variableScript;
import org.eclipse.papyrus.designer.languages.c.codegen.services.UmlCommentServices;
import org.eclipse.papyrus.designer.uml.tools.utils.StateMachineUtils;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class ClassHeaderScript {
  public static CharSequence classHeaderScript(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t\t");
    CharSequence _genHeading = CommonScript.genHeading(clazz);
    _builder.append(_genHeading, "\t\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _genHeadingHeader = CommonHeaderScript.genHeadingHeader(clazz);
    _builder.append(_genHeadingHeader);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _genHeaderIncludes = ImportScript.genHeaderIncludes(clazz);
    _builder.append(_genHeaderIncludes);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _classHeaderBody = ClassHeaderScript.classHeaderBody(clazz);
    _builder.append(_classHeaderBody);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _genEndHeader = CommonHeaderScript.genEndHeader(clazz);
    _builder.append(_genEndHeader);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public static CharSequence classHeaderBody(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    {
      if (((clazz.getClassifierBehavior() != null) && (!IterableExtensions.isEmpty(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class))))) {
        _builder.append("\t");
        _builder.append("// ----------------------------------Enum State declaration ----------------------------------");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        String _partComment = UmlCommentServices.partComment(clazz, "Enum State declaration");
        _builder.append(_partComment, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _genStateEnumPrototype = DataTypeScript.genStateEnumPrototype(IterableExtensions.<StateMachine>head(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class)));
        _builder.append(_genStateEnumPrototype, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("// ----------------------------------Structure State_t declaration ----------------------------------");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        String _partComment_1 = UmlCommentServices.partComment(clazz, "State_t declaration");
        _builder.append(_partComment_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        CharSequence _genStatetStructure = DataTypeScript.genStatetStructure(IterableExtensions.<StateMachine>head(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class)));
        _builder.append(_genStatetStructure, "\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      VisibilityKind _visibility = clazz.getVisibility();
      boolean _equals = Objects.equals(_visibility, VisibilityKind.PUBLIC_LITERAL);
      if (_equals) {
        _builder.append("\t");
        String _partComment_2 = UmlCommentServices.partComment(clazz, "Public Class Description");
        _builder.append(_partComment_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("//  Structure ");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _genClassStructDeclarations = ClassScript.genClassStructDeclarations(clazz);
        _builder.append(_genClassStructDeclarations, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Constructor and destructor declarations ");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _genDynamicInstanciationOperationPrototypes = ClassScript.genDynamicInstanciationOperationPrototypes(clazz);
        _builder.append(_genDynamicInstanciationOperationPrototypes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Property initialisation declarations");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _genDefaultInitialisationProtoype = ClassScript.genDefaultInitialisationProtoype(clazz);
        _builder.append(_genDefaultInitialisationProtoype, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Class methods declarations");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _genNonStaticFunctionDeclarations = ClassScript.genNonStaticFunctionDeclarations(clazz);
        _builder.append(_genNonStaticFunctionDeclarations, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Class receptions declarations");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _genReceptionDeclarations = ClassScript.genReceptionDeclarations(clazz);
        _builder.append(_genReceptionDeclarations, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// ----------------------------------Public Global VariableDescription----------------------------------");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    {
      final Function1<Property, Boolean> _function = (Property it) -> {
        return Boolean.valueOf(((it.isStatic() && Objects.equals(it.getVisibility(), VisibilityKind.PUBLIC_LITERAL)) && (it.getType() != null)));
      };
      int _size = IterableExtensions.size(IterableExtensions.<Property>filter(clazz.getOwnedAttributes(), _function));
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        _builder.append("\t");
        String _partComment_3 = UmlCommentServices.partComment(clazz, "Global Public Variable Declarations");
        _builder.append(_partComment_3, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<Property> _ownedAttributes = clazz.getOwnedAttributes();
      for(final Property attribute : _ownedAttributes) {
        {
          if (((attribute.isStatic() && Objects.equals(attribute.getVisibility(), VisibilityKind.PUBLIC_LITERAL)) && (attribute.getType() != null))) {
            _builder.append("\t");
            _builder.append("// global variable declaration");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _genVariableDeclaration = variableScript.genVariableDeclaration(attribute);
            _builder.append(_genVariableDeclaration, "\t");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// ----------------------------------Global Public Functions----------------------------------");
    _builder.newLine();
    {
      final Function1<Operation, Boolean> _function_1 = (Operation it) -> {
        return Boolean.valueOf((it.isStatic() && Objects.equals(it.getVisibility(), VisibilityKind.PUBLIC_LITERAL)));
      };
      int _size_1 = IterableExtensions.size(IterableExtensions.<Operation>filter(clazz.getOperations(), _function_1));
      boolean _greaterThan_1 = (_size_1 > 0);
      if (_greaterThan_1) {
        _builder.append("\t");
        String _partComment_4 = UmlCommentServices.partComment(clazz, "Global Public Function Declarations");
        _builder.append(_partComment_4, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<Operation> _operations = clazz.getOperations();
      final Function1<InterfaceRealization, EList<Operation>> _function_2 = (InterfaceRealization it) -> {
        return it.getContract().getOwnedOperations();
      };
      Iterable<Operation> _flatten = Iterables.<Operation>concat(ListExtensions.<InterfaceRealization, EList<Operation>>map(clazz.getInterfaceRealizations(), _function_2));
      Iterable<Operation> _plus = Iterables.<Operation>concat(_operations, _flatten);
      for(final Operation operation : _plus) {
        {
          if ((operation.isStatic() && Objects.equals(operation.getVisibility(), VisibilityKind.PUBLIC_LITERAL))) {
            _builder.append("\t");
            CharSequence _genFunctionPrototype = FunctionScript.genFunctionPrototype(operation);
            _builder.append(_genFunctionPrototype, "\t");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.newLine();
    _builder.append("// ----------------------------------Signal Event Process Functions Implementations--------------------------------");
    _builder.newLine();
    {
      Behavior _classifierBehavior = clazz.getClassifierBehavior();
      boolean _tripleNotEquals = (_classifierBehavior != null);
      if (_tripleNotEquals) {
        {
          Iterable<SignalEvent> _filter = Iterables.<SignalEvent>filter(clazz.getModel().allOwnedElements(), SignalEvent.class);
          for(final SignalEvent signalEvent : _filter) {
            CharSequence _genFunctionPrototype_1 = FunctionScript.genFunctionPrototype(signalEvent, clazz);
            _builder.append(_genFunctionPrototype_1);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// ----------------------------------Call Event Process Functions ----------------------------------");
    _builder.newLine();
    {
      Behavior _classifierBehavior_1 = clazz.getClassifierBehavior();
      boolean _tripleNotEquals_1 = (_classifierBehavior_1 != null);
      if (_tripleNotEquals_1) {
        {
          Iterable<CallEvent> _filter_1 = Iterables.<CallEvent>filter(clazz.getModel().allOwnedElements(), CallEvent.class);
          for(final CallEvent callevent : _filter_1) {
            {
              if (((callevent.getOperation() != null) && clazz.getOperations().contains(callevent.getOperation()))) {
                CharSequence _genFunctionPrototype_2 = FunctionScript.genFunctionPrototype(callevent);
                _builder.append(_genFunctionPrototype_2);
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
      }
    }
    _builder.newLine();
    _builder.newLine();
    {
      if (((clazz.getClassifierBehavior() != null) && (!IterableExtensions.isEmpty(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class))))) {
        StateMachine sm = IterableExtensions.<StateMachine>head(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class));
        _builder.append("\t");
        _builder.newLineIfNotEmpty();
        _builder.append("// ----------------------------------Entry Exit and DoActivity Prototypes for each state ----------------------------------");
        _builder.newLine();
        {
          final Function1<State, Boolean> _function_3 = (State it) -> {
            return Boolean.valueOf((!(it instanceof FinalState)));
          };
          boolean _isEmpty = IterableExtensions.isEmpty(IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(sm.getRegions()).getSubvertices(), State.class), _function_3));
          boolean _not = (!_isEmpty);
          if (_not) {
            final Function1<State, Boolean> _function_4 = (State it) -> {
              return Boolean.valueOf((!(it instanceof FinalState)));
            };
            Iterable<State> states = IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(sm.getRegions()).getSubvertices(), State.class), _function_4);
            _builder.newLineIfNotEmpty();
            {
              for(final State state : states) {
                {
                  boolean _isBehaviorExist = StateMachineUtils.isBehaviorExist(state.getEntry());
                  if (_isBehaviorExist) {
                    String _genEntryPrototype = FunctionScript.genEntryPrototype(state);
                    _builder.append(_genEntryPrototype);
                    _builder.newLineIfNotEmpty();
                  }
                }
                {
                  boolean _isBehaviorExist_1 = StateMachineUtils.isBehaviorExist(state.getExit());
                  if (_isBehaviorExist_1) {
                    String _genExitPrototype = FunctionScript.genExitPrototype(state);
                    _builder.append(_genExitPrototype);
                    _builder.newLineIfNotEmpty();
                  }
                }
                {
                  boolean _isBehaviorExist_2 = StateMachineUtils.isBehaviorExist(state.getDoActivity());
                  if (_isBehaviorExist_2) {
                    String _genDoActivityPrototype = FunctionScript.genDoActivityPrototype(state);
                    _builder.append(_genDoActivityPrototype);
                    _builder.newLineIfNotEmpty();
                  }
                }
              }
            }
          }
        }
        {
          boolean _hasTriggerlessTransition = StateMachineUtils.hasTriggerlessTransition(sm);
          if (_hasTriggerlessTransition) {
            _builder.append("//--------------------process Completion Event for completion transition-------------------//");
            _builder.newLine();
            _builder.append("void ProcessCompletionEvent(");
            CharSequence _genName = CommonScript.genName(clazz);
            _builder.append(_genName);
            _builder.append("* self);");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
}
