/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml16.requirementsextension;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RiskKind implements Enumerator
{
    HIGH(0, "High", "High"),
    MEDIUM(1, "Medium", "Medium"),
    LOW(2, "Low", "Low");

    public static final int HIGH_VALUE = 0;
    public static final int MEDIUM_VALUE = 1;
    public static final int LOW_VALUE = 2;
    private static final RiskKind[] VALUES_ARRAY;
    public static final List<RiskKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RiskKind[]{HIGH, MEDIUM, LOW};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RiskKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RiskKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RiskKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RiskKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RiskKind get(int value) {
        switch (value) {
            case 0: {
                return HIGH;
            }
            case 1: {
                return MEDIUM;
            }
            case 2: {
                return LOW;
            }
        }
        return null;
    }

    private RiskKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

